/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.fabrication.engine.log;

import codechicken.lib.colour.EnumColour;
import codechicken.lib.data.MCDataInput;
import codechicken.lib.data.MCDataOutput;
import codechicken.lib.render.CCRenderState;
import codechicken.lib.vec.Vector3;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import mrtjp.fengine.TileCoord;
import mrtjp.projectred.fabrication.editor.EditorDataUtils;
import mrtjp.projectred.fabrication.engine.log.CompileProblem;
import mrtjp.projectred.fabrication.engine.log.CompileProblemSeverity;
import mrtjp.projectred.fabrication.engine.log.CompileProblemType;
import mrtjp.projectred.fabrication.gui.ICRenderTypes;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;

public abstract class MultiPositionProblem
extends CompileProblem {
    public final List<TileCoord> coordList = new LinkedList<TileCoord>();

    public MultiPositionProblem(CompileProblemType type, CompileProblemSeverity severity) {
        super(type, severity);
    }

    public MultiPositionProblem(CompileProblemType type, CompileProblemSeverity severity, Collection<TileCoord> coordList) {
        this(type, severity);
        this.coordList.addAll(coordList);
    }

    @Override
    public void save(CompoundTag tag) {
        EditorDataUtils.saveTileCoordList(tag, "coordList", this.coordList);
    }

    @Override
    public void load(CompoundTag tag) {
        this.coordList.clear();
        EditorDataUtils.loadTileCoordList(tag, "coordList", this.coordList);
    }

    @Override
    public void writeDesc(MCDataOutput out) {
        out.writeShort(this.coordList.size());
        for (TileCoord coord : this.coordList) {
            out.writeByte(coord.x).writeByte(coord.y).writeByte(coord.z);
        }
    }

    @Override
    public void readDesc(MCDataInput in) {
        this.coordList.clear();
        int size = in.readUShort();
        for (int i = 0; i < size; ++i) {
            this.coordList.add(new TileCoord(in.readByte(), in.readByte(), in.readByte()));
        }
    }

    @Override
    public void buildToolTip(List<Component> tooltip, TileCoord hoverPosition) {
        if (this.coordList.contains(hoverPosition)) {
            this.buildToolTip(tooltip);
        }
    }

    @Override
    public void renderOverlay(Vector3 mousePosition, CCRenderState ccrs, MultiBufferSource getter, PoseStack matrixStack) {
        ccrs.baseColour = this.severity == CompileProblemSeverity.ERROR ? EnumColour.RED.rgba(200) : EnumColour.YELLOW.rgba(200);
        Vector3 vec = new Vector3();
        for (TileCoord coord : this.coordList) {
            vec.set((double)coord.x, (double)coord.y, (double)coord.z).add(0.5);
            ICRenderTypes.renderSelection(ccrs, vec, vec, 0.1875, 0.125);
        }
    }
}

