/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.fabrication.inventory.container;

import codechicken.lib.inventory.container.ICCLContainerFactory;
import mrtjp.projectred.core.inventory.container.TakeOnlySlot;
import mrtjp.projectred.fabrication.init.FabricationMenus;
import mrtjp.projectred.fabrication.inventory.container.FabricationMachineMenu;
import mrtjp.projectred.fabrication.item.BlankPhotomaskItem;
import mrtjp.projectred.fabrication.item.ICBlueprintItem;
import mrtjp.projectred.fabrication.tile.PlottingTableBlockEntity;
import mrtjp.projectred.lib.InventoryLib;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;

public class PlottingTableMenu
extends FabricationMachineMenu {
    public static ICCLContainerFactory<PlottingTableMenu> FACTORY = (windowId, inventory, packet) -> {
        BlockEntity tile = inventory.f_35978_.m_9236_().m_7702_(packet.readPos());
        if (!(tile instanceof PlottingTableBlockEntity)) {
            return null;
        }
        return new PlottingTableMenu(inventory, (PlottingTableBlockEntity)tile, windowId);
    };
    private final Inventory playerInventory;
    private final PlottingTableBlockEntity tile;

    public PlottingTableMenu(Inventory playerInventory, PlottingTableBlockEntity tile, int windowId) {
        super((MenuType)FabricationMenus.PLOTTING_TABLE_MENU.get(), windowId, tile);
        this.playerInventory = playerInventory;
        this.tile = tile;
        InventoryLib.addPlayerInventory((Inventory)playerInventory, (int)8, (int)89, x$0 -> this.m_38897_((Slot)x$0));
        this.addPlottingTableInventory();
    }

    private void addPlottingTableInventory() {
        this.m_38897_(new Slot(this.tile.getInventory(), 0, 56, 31));
        this.m_38897_(new Slot(this.tile.getInventory(), 1, 56, 49));
        this.m_38897_((Slot)new TakeOnlySlot(this.tile.getInventory(), 2, 116, 40));
    }

    public boolean m_6875_(Player pPlayer) {
        return Container.m_272074_((BlockEntity)this.tile, (Player)pPlayer);
    }

    public ItemStack m_7648_(Player player, int slotIndex) {
        Slot slot = (Slot)this.f_38839_.get(slotIndex);
        if (!slot.m_6657_()) {
            return ItemStack.f_41583_;
        }
        ItemStack stack = slot.m_7993_();
        ItemStack originalStack = stack.m_41777_();
        if (this.isOutput(slotIndex) ? !this.moveToEntireInventory(stack, true) : (this.isHotbar(slotIndex) || this.isPlayerInventory(slotIndex) ? (this.isBlueprint(stack) ? !this.moveToBlueprintInput(stack, false) : (this.isBlankPhotomask(stack) ? !this.moveToPhotomaskInput(stack, false) : (this.isPlayerInventory(slotIndex) ? !this.moveToHotbar(stack, false) : !this.moveToPlayerInventory(stack, false)))) : this.isInputs(slotIndex) && !this.moveToEntireInventory(stack, false))) {
            return ItemStack.f_41583_;
        }
        if (stack.m_41619_()) {
            slot.m_5852_(ItemStack.f_41583_);
        } else {
            slot.m_6654_();
        }
        if (stack.m_41613_() == originalStack.m_41613_()) {
            return ItemStack.f_41583_;
        }
        slot.m_142406_(player, stack);
        return originalStack;
    }

    private boolean isHotbar(int slotIndex) {
        return slotIndex >= 27 && slotIndex < 36;
    }

    private boolean isPlayerInventory(int slotIndex) {
        return slotIndex >= 0 && slotIndex < 27;
    }

    private boolean isInputs(int slotIndex) {
        return slotIndex >= 36 && slotIndex < 38;
    }

    private boolean isOutput(int slotIndex) {
        return slotIndex == 38;
    }

    private boolean moveToHotbar(ItemStack stack, boolean reverse) {
        return this.m_38903_(stack, 27, 36, reverse);
    }

    private boolean moveToPlayerInventory(ItemStack stack, boolean reverse) {
        return this.m_38903_(stack, 0, 27, reverse);
    }

    private boolean moveToEntireInventory(ItemStack stack, boolean reverse) {
        return this.m_38903_(stack, 0, 36, reverse);
    }

    private boolean moveToBlueprintInput(ItemStack stack, boolean reverse) {
        return this.m_38903_(stack, 36, 37, reverse);
    }

    private boolean moveToPhotomaskInput(ItemStack stack, boolean reverse) {
        return this.m_38903_(stack, 37, 38, reverse);
    }

    private boolean isBlueprint(ItemStack stack) {
        return stack.m_41720_() instanceof ICBlueprintItem;
    }

    private boolean isBlankPhotomask(ItemStack stack) {
        return stack.m_41720_() instanceof BlankPhotomaskItem;
    }
}

