/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.fabrication.lithography;

public enum WaferType {
    ROUGH_WAFER(4096, 0.5, "roughWafer"),
    PURIFIED_WAFER(4096, 0.1, "purifiedWafer"),
    POLISHED_WAFER(4096, 0.01, "polishedWafer");

    private final String unlocalizedName;
    private final int waferLen;
    private final int waferArea;
    private final double defectRatePerUnitArea;

    private WaferType(int waferLen, double standardDieDefectRate, String unlocalizedName) {
        this.waferLen = waferLen;
        this.waferArea = waferLen * waferLen;
        this.defectRatePerUnitArea = standardDieDefectRate / Math.pow(1024.0, 2.0);
        this.unlocalizedName = unlocalizedName;
    }

    public int getWaferArea() {
        return this.waferArea;
    }

    public int getWaferWidth() {
        return this.waferLen;
    }

    public int getWaferHeight() {
        return this.waferLen;
    }

    public double getDefectRatePerUnitArea() {
        return this.defectRatePerUnitArea;
    }

    public String getUnlocalizedName() {
        return this.unlocalizedName;
    }
}

