/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.fabrication.lithography;

import mrtjp.projectred.fabrication.lithography.LithographyPipeline;
import mrtjp.projectred.fabrication.lithography.ProcessNode;
import mrtjp.projectred.fabrication.lithography.WaferType;
import mrtjp.projectred.lib.Size;
import net.minecraft.network.chat.Component;

public class YieldCalculator {
    private int tileMapWidth;
    private int tileMapHeight;
    private int tileMapLayers;
    private LithographyPipeline pipeline = LithographyPipeline.BASIC;
    private ProcessNode processNode = ProcessNode.PROCESS_64NM;
    private WaferType waferType = WaferType.ROUGH_WAFER;

    public LithographyPipeline getPipeline() {
        return this.pipeline;
    }

    public void setPipeline(LithographyPipeline pipeline) {
        this.pipeline = pipeline;
    }

    public ProcessNode getProcessNode() {
        return this.processNode;
    }

    public void setProcessNode(ProcessNode processNode) {
        this.processNode = processNode;
    }

    public WaferType getWaferType() {
        return this.waferType;
    }

    public void setWaferType(WaferType waferType) {
        this.waferType = waferType;
    }

    public void setTileMapSize(int width, int height, int layers) {
        this.tileMapWidth = width;
        this.tileMapHeight = height;
        this.tileMapLayers = layers;
    }

    public Size getTileMapSize() {
        return new Size(this.tileMapWidth, this.tileMapHeight);
    }

    public Size getDieSize() {
        return new Size(this.tileMapWidth * this.processNode.getTileWidth(), this.tileMapHeight * this.processNode.getTileHeight());
    }

    public Size getWaferSize() {
        return new Size(this.waferType.getWaferWidth(), this.waferType.getWaferHeight());
    }

    public Size getDieCount() {
        return this.getWaferSize().divide(this.getDieSize());
    }

    public double getSingleLayerYield() {
        Size dieSize = this.getDieSize();
        return 1.0 - this.waferType.getDefectRatePerUnitArea() * (double)dieSize.width * (double)dieSize.height;
    }

    public double getMultiLayerYield() {
        return Math.pow(this.getSingleLayerYield(), this.tileMapLayers);
    }

    public Component getDieDimensionsText() {
        Size dieSize = this.getDieSize();
        return Component.m_237110_((String)"projectred_fabrication.f.dimensions.nm", (Object[])new Object[]{dieSize.width, dieSize.height});
    }

    public Component getWaferDimensionsText() {
        return Component.m_237110_((String)"projectred_fabrication.f.dimensions.nm", (Object[])new Object[]{this.waferType.getWaferWidth(), this.waferType.getWaferHeight()});
    }

    public Component getDieCountDimensionsText() {
        Size dieCount = this.getDieCount();
        return Component.m_237110_((String)"projectred_fabrication.f.dimensions.dies_total", (Object[])new Object[]{dieCount.width, dieCount.height, dieCount.width * dieCount.height});
    }

    public Component getSingleLayerYieldText() {
        return Component.m_237113_((String)String.format("%.2f%%", this.getSingleLayerYield() * 100.0));
    }

    public Component getYieldText() {
        return Component.m_237113_((String)String.format("%.2f%%", this.getMultiLayerYield() * 100.0));
    }
}

