/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.dummmmmmy.network;

import net.mehvahdjukaar.dummmmmmy.Dummmmmmy;
import net.mehvahdjukaar.dummmmmmy.common.CritRecord;
import net.mehvahdjukaar.dummmmmmy.common.TargetDummyEntity;
import net.mehvahdjukaar.dummmmmmy.configs.ClientConfigs;
import net.mehvahdjukaar.dummmmmmy.configs.CritMode;
import net.mehvahdjukaar.moonlight.api.platform.network.ChannelHandler;
import net.mehvahdjukaar.moonlight.api.platform.network.Message;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.minecraft.client.Minecraft;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class ClientBoundDamageNumberMessage
implements Message {
    private final int entityID;
    private final float damageAmount;
    private final ResourceLocation damageType;
    private final boolean isCrit;
    private final float critMult;

    public ClientBoundDamageNumberMessage(FriendlyByteBuf buf) {
        this.entityID = buf.readInt();
        this.damageAmount = buf.readFloat();
        this.damageType = buf.m_130281_();
        this.isCrit = buf.readBoolean();
        this.critMult = this.isCrit ? buf.readFloat() : 0.0f;
    }

    public ClientBoundDamageNumberMessage(int id, float damage, DamageSource source, @Nullable CritRecord critical) {
        this(id, damage, ClientBoundDamageNumberMessage.encodeDamage(source), critical != null, critical == null ? 0.0f : critical.getMultiplier());
    }

    public static ResourceLocation encodeDamage(DamageSource source) {
        if (source == null) {
            return Dummmmmmy.TRUE_DAMAGE;
        }
        DamageType damageType = source.m_269415_();
        if (damageType == null) {
            throw new AssertionError((Object)("Damage source has null type. How?: " + String.valueOf(source)));
        }
        ResourceLocation id = Utils.hackyGetRegistry((ResourceKey)Registries.f_268580_).m_7981_((Object)damageType);
        if (id == null) {
            throw new AssertionError((Object)("Damage type not found in registry. This is a bug from that mod that added it!: " + String.valueOf(damageType)));
        }
        return id;
    }

    protected ClientBoundDamageNumberMessage(int id, float damage, ResourceLocation damageType, boolean isCrit, float critMult) {
        this.entityID = id;
        this.damageAmount = damage;
        this.damageType = damageType;
        this.isCrit = isCrit;
        this.critMult = critMult;
    }

    public void writeToBuffer(FriendlyByteBuf buf) {
        buf.writeInt(this.entityID);
        buf.writeFloat(this.damageAmount);
        buf.m_130085_(this.damageType);
        buf.writeBoolean(this.isCrit);
        if (this.isCrit) {
            buf.writeFloat(this.critMult);
        }
    }

    public void handle(ChannelHandler.Context context) {
        Entity entity = Minecraft.m_91087_().f_91073_.m_6815_(this.entityID);
        if (entity instanceof TargetDummyEntity) {
            TargetDummyEntity dummy = (TargetDummyEntity)entity;
            if (ClientConfigs.DAMAGE_NUMBERS.get().booleanValue()) {
                int i = dummy.getNextNumberPos();
                this.spawnParticle(entity, i);
            }
            if (ClientConfigs.HAY_PARTICLES.get().booleanValue()) {
                this.spawnHay(entity);
            }
        } else if (entity != null) {
            this.spawnParticle(entity, 0);
        }
    }

    private void spawnParticle(Entity entity, int animationPos) {
        ResourceLocation type = this.damageType;
        float mult = 0.0f;
        CritMode critMode = ClientConfigs.CRIT_MODE.get();
        if (critMode != CritMode.OFF && this.isCrit) {
            type = Dummmmmmy.CRITICAL_DAMAGE;
            if (critMode == CritMode.COLOR_AND_MULTIPLIER) {
                mult = this.critMult;
            }
        }
        double z = CritMode.encodeIntFloatToDouble(animationPos, mult);
        int color = ClientConfigs.getDamageColor(type);
        entity.m_9236_().m_7106_((ParticleOptions)Dummmmmmy.NUMBER_PARTICLE.get(), entity.m_20185_(), entity.m_20186_() + 1.0, entity.m_20189_(), (double)this.damageAmount, (double)color, z);
    }

    private void spawnHay(Entity entity) {
        RandomSource random = entity.m_9236_().f_46441_;
        int amount = (int)(1.0f + Mth.m_184637_((float)this.damageAmount, (float)0.0f, (float)40.0f, (float)0.0f, (float)10.0f));
        amount = Mth.m_14045_((int)amount, (int)0, (int)10);
        for (int i = 0; i < amount; ++i) {
            Vec3 pos = new Vec3(entity.m_20208_(0.5), entity.m_20186_() + 0.75 + (double)random.m_188501_() * 0.85, entity.m_20262_(0.5));
            Vec3 speed = ClientBoundDamageNumberMessage.getOutwardSpeed(pos.m_82546_(entity.m_20182_()), random);
            entity.m_9236_().m_7106_((ParticleOptions)Dummmmmmy.HAY_PARTICLE.get(), pos.f_82479_, pos.f_82480_, pos.f_82481_, speed.f_82479_, (double)random.m_188501_() * 0.04, speed.f_82481_);
        }
    }

    public static Vec3 getOutwardSpeed(Vec3 position, RandomSource random) {
        Vec3 direction = position.m_82541_();
        float randomLen = 0.02f + random.m_188501_() * 0.04f;
        float angleVariation = (float)(random.m_188583_() * (double)0.3f);
        float sin = Mth.m_14031_((float)angleVariation);
        float cos = Mth.m_14089_((float)angleVariation);
        double newX = direction.f_82479_ * (double)cos - direction.f_82481_ * (double)sin;
        double newY = direction.f_82479_ * (double)sin + direction.f_82481_ * (double)cos;
        return new Vec3(newX * (double)randomLen, 0.0, newY * (double)randomLen);
    }
}

