/*
 * Decompiled with CFR 0.152.
 */
package com.diggydwarff.herbalistmod.block.entity;

import com.diggydwarff.herbalistmod.block.entity.ModBlockEntities;
import com.diggydwarff.herbalistmod.client.screen.ExtractionStandMenu;
import com.diggydwarff.herbalistmod.items.ModItems;
import java.util.Arrays;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExtractionStandEntity
extends BlockEntity
implements MenuProvider {
    private final ItemStackHandler itemHandler = new ItemStackHandler(5){

        protected void onContentsChanged(int slot) {
            ExtractionStandEntity.this.m_6596_();
        }
    };
    private LazyOptional<IItemHandler> lazyItemHandler = LazyOptional.empty();
    protected final ContainerData data = new ContainerData(){

        public int m_6413_(int index) {
            return switch (index) {
                case 0 -> ExtractionStandEntity.this.progress;
                case 1 -> ExtractionStandEntity.this.fuelLevel;
                default -> 0;
            };
        }

        public void m_8050_(int index, int value) {
            switch (index) {
                case 0: {
                    ExtractionStandEntity.this.progress = value;
                    break;
                }
                case 1: {
                    ExtractionStandEntity.this.fuelLevel = value;
                }
            }
        }

        public int m_6499_() {
            return 2;
        }
    };
    private int progress = 0;
    public int fuelLevel = 0;
    public int maxFuelLevel = 3000;
    private int maxProgress = 1000;

    public ExtractionStandEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntities.EXTRACTION_STAND_ENTITY.get(), pos, state);
    }

    public Component m_5446_() {
        return Component.m_237113_((String)"Extraction Stand");
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int id, Inventory inventory, Player player) {
        return new ExtractionStandMenu(id, inventory, this, this.data);
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            return this.lazyItemHandler.cast();
        }
        return super.getCapability(cap, side);
    }

    public void onLoad() {
        super.onLoad();
        this.lazyItemHandler = LazyOptional.of(() -> this.itemHandler);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.lazyItemHandler.invalidate();
    }

    protected void m_183515_(CompoundTag nbt) {
        nbt.m_128365_("inventory", (Tag)this.itemHandler.serializeNBT());
        nbt.m_128405_("extraction_stand.progress", this.progress);
        nbt.m_128405_("extraction_stand.maxProgress", this.maxProgress);
        nbt.m_128405_("extraction_stand.fuelLevel", this.fuelLevel);
        nbt.m_128405_("extraction_stand.maxFuelLevel", this.maxFuelLevel);
        super.m_183515_(nbt);
    }

    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        this.itemHandler.deserializeNBT(nbt.m_128469_("inventory"));
        this.progress = nbt.m_128451_("extraction_stand.progress");
        this.maxProgress = nbt.m_128451_("extraction_stand.maxProgress");
        this.fuelLevel = nbt.m_128451_("extraction_stand.fuelLevel");
        this.maxFuelLevel = nbt.m_128451_("extraction_stand.maxFuelLevel");
    }

    public void drops() {
        SimpleContainer inventory = new SimpleContainer(this.itemHandler.getSlots());
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            inventory.m_6836_(i, this.itemHandler.getStackInSlot(i));
        }
        Containers.m_19002_((Level)this.f_58857_, (BlockPos)this.f_58858_, (Container)inventory);
    }

    public static void tick(Level level, BlockPos pos, BlockState state, ExtractionStandEntity pEntity) {
        if (level.m_5776_()) {
            return;
        }
        if (pEntity.itemHandler.getStackInSlot(0).m_41720_() == Items.f_42593_ && pEntity.fuelLevel <= 0) {
            pEntity.itemHandler.extractItem(0, 1, false);
            pEntity.fuelLevel = pEntity.maxFuelLevel;
        }
        if (ExtractionStandEntity.hasRecipe(pEntity)) {
            if (pEntity.fuelLevel > 0) {
                --pEntity.fuelLevel;
            }
            ServerLevel serverLevel = (ServerLevel)level;
            serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123777_, (double)pos.m_123341_(), (double)(pos.m_123342_() + 1), (double)pos.m_123343_(), 1, 0.0, 0.0, 0.0, 0.0);
            ++pEntity.progress;
            ItemStack itemStack = pEntity.itemHandler.getStackInSlot(1);
            itemStack.m_41721_(itemStack.m_41773_() + 1);
            ExtractionStandEntity.m_155232_((Level)level, (BlockPos)pos, (BlockState)state);
            if (pEntity.progress >= pEntity.maxProgress) {
                ExtractionStandEntity.craftItem(pEntity);
            }
        } else {
            pEntity.resetProgress();
            ExtractionStandEntity.m_155232_((Level)level, (BlockPos)pos, (BlockState)state);
        }
    }

    private void resetProgress() {
        this.progress = 0;
    }

    private static void craftItem(ExtractionStandEntity pEntity) {
        if (ExtractionStandEntity.hasRecipe(pEntity)) {
            if (pEntity.itemHandler.getStackInSlot(1).m_41720_() == ModItems.ETHEREAL_FUNGUS.get() || pEntity.itemHandler.getStackInSlot(1).m_41720_() == ModItems.DREAMCAP_MUSHROOM.get() || pEntity.itemHandler.getStackInSlot(1).m_41720_() == ModItems.SNOWCAP_MUSHROOM.get() || pEntity.itemHandler.getStackInSlot(1).m_41720_() == ModItems.GOLDENGLOW_MUSHROOM.get()) {
                if (pEntity.itemHandler.getStackInSlot(2).m_41720_() == ModItems.GLASS_VIAL.get()) {
                    pEntity.itemHandler.extractItem(2, 1, false);
                    pEntity.itemHandler.insertItem(2, new ItemStack((ItemLike)ModItems.ETHEREAL_EXTRACT.get()), false);
                }
                if (pEntity.itemHandler.getStackInSlot(3).m_41720_() == ModItems.GLASS_VIAL.get()) {
                    pEntity.itemHandler.extractItem(3, 1, false);
                    pEntity.itemHandler.insertItem(3, new ItemStack((ItemLike)ModItems.ETHEREAL_EXTRACT.get()), false);
                }
                if (pEntity.itemHandler.getStackInSlot(4).m_41720_() == ModItems.GLASS_VIAL.get()) {
                    pEntity.itemHandler.extractItem(4, 1, false);
                    pEntity.itemHandler.insertItem(4, new ItemStack((ItemLike)ModItems.ETHEREAL_EXTRACT.get()), false);
                }
            } else if (pEntity.itemHandler.getStackInSlot(1).m_41720_() == ModItems.MIRAGE_CACTUS.get()) {
                if (pEntity.itemHandler.getStackInSlot(2).m_41720_() == ModItems.GLASS_VIAL.get()) {
                    pEntity.itemHandler.extractItem(2, 1, false);
                    pEntity.itemHandler.insertItem(2, new ItemStack((ItemLike)ModItems.MIRAGE_CACTUS_EXTRACT.get()), false);
                }
                if (pEntity.itemHandler.getStackInSlot(3).m_41720_() == ModItems.GLASS_VIAL.get()) {
                    pEntity.itemHandler.extractItem(3, 1, false);
                    pEntity.itemHandler.insertItem(3, new ItemStack((ItemLike)ModItems.MIRAGE_CACTUS_EXTRACT.get()), false);
                }
                if (pEntity.itemHandler.getStackInSlot(4).m_41720_() == ModItems.GLASS_VIAL.get()) {
                    pEntity.itemHandler.extractItem(4, 1, false);
                    pEntity.itemHandler.insertItem(4, new ItemStack((ItemLike)ModItems.MIRAGE_CACTUS_EXTRACT.get()), false);
                }
            } else if (pEntity.itemHandler.getStackInSlot(1).m_41720_() == Items.f_42675_) {
                if (pEntity.itemHandler.getStackInSlot(2).m_41720_() == ModItems.GLASS_VIAL.get()) {
                    pEntity.itemHandler.extractItem(2, 1, false);
                    pEntity.itemHandler.insertItem(2, new ItemStack((ItemLike)ModItems.SUSPICIOUS_EXTRACT.get()), false);
                }
                if (pEntity.itemHandler.getStackInSlot(3).m_41720_() == ModItems.GLASS_VIAL.get()) {
                    pEntity.itemHandler.extractItem(3, 1, false);
                    pEntity.itemHandler.insertItem(3, new ItemStack((ItemLike)ModItems.SUSPICIOUS_EXTRACT.get()), false);
                }
                if (pEntity.itemHandler.getStackInSlot(4).m_41720_() == ModItems.GLASS_VIAL.get()) {
                    pEntity.itemHandler.extractItem(4, 1, false);
                    pEntity.itemHandler.insertItem(4, new ItemStack((ItemLike)ModItems.SUSPICIOUS_EXTRACT.get()), false);
                }
            } else if (pEntity.itemHandler.getStackInSlot(1).m_41720_() == Items.f_42730_) {
                if (pEntity.itemHandler.getStackInSlot(2).m_41720_() == ModItems.GLASS_VIAL.get()) {
                    pEntity.itemHandler.extractItem(2, 1, false);
                    pEntity.itemHandler.insertItem(2, new ItemStack((ItemLike)ModItems.CHORUS_EXTRACT.get()), false);
                }
                if (pEntity.itemHandler.getStackInSlot(3).m_41720_() == ModItems.GLASS_VIAL.get()) {
                    pEntity.itemHandler.extractItem(3, 1, false);
                    pEntity.itemHandler.insertItem(3, new ItemStack((ItemLike)ModItems.CHORUS_EXTRACT.get()), false);
                }
                if (pEntity.itemHandler.getStackInSlot(4).m_41720_() == ModItems.GLASS_VIAL.get()) {
                    pEntity.itemHandler.extractItem(4, 1, false);
                    pEntity.itemHandler.insertItem(4, new ItemStack((ItemLike)ModItems.CHORUS_EXTRACT.get()), false);
                }
            }
            pEntity.itemHandler.extractItem(1, 1, false);
        }
    }

    private static boolean hasRecipe(ExtractionStandEntity entity) {
        SimpleContainer inventory = new SimpleContainer(entity.itemHandler.getSlots());
        for (int i = 0; i < entity.itemHandler.getSlots(); ++i) {
            inventory.m_6836_(i, entity.itemHandler.getStackInSlot(i));
        }
        List<Item> possibleIngredientItems = Arrays.asList((Item)ModItems.MIRAGE_CACTUS.get(), (Item)ModItems.ETHEREAL_FUNGUS.get(), (Item)ModItems.DREAMCAP_MUSHROOM.get(), (Item)ModItems.SNOWCAP_MUSHROOM.get(), (Item)ModItems.GOLDENGLOW_MUSHROOM.get(), Items.f_42730_, Items.f_42675_);
        boolean hasFuel = entity.fuelLevel > 0;
        boolean hasIngredient = possibleIngredientItems.contains(entity.itemHandler.getStackInSlot(1).m_41720_());
        boolean hasVials = entity.itemHandler.getStackInSlot(2).m_41720_() == ModItems.GLASS_VIAL.get() || entity.itemHandler.getStackInSlot(3).m_41720_() == ModItems.GLASS_VIAL.get() || entity.itemHandler.getStackInSlot(4).m_41720_() == ModItems.GLASS_VIAL.get();
        return hasFuel && hasVials && hasIngredient;
    }

    private static boolean canInsertItemIntoOutputSlot(SimpleContainer inventory, ItemStack stack) {
        return inventory.m_8020_(2).m_41720_() == stack.m_41720_() || inventory.m_8020_(2).m_41619_();
    }

    private static boolean canInsertAmountIntoOutputSlot(SimpleContainer inventory) {
        return inventory.m_8020_(2).m_41741_() > inventory.m_8020_(2).m_41613_();
    }
}

