/*
 * Decompiled with CFR 0.152.
 */
package com.diggydwarff.herbalistmod.recipes;

import com.diggydwarff.herbalistmod.items.BlazebudItem;
import com.diggydwarff.herbalistmod.items.ModItems;
import com.diggydwarff.herbalistmod.recipes.ModRecipes;
import com.diggydwarff.tobacconistmod.items.custom.TobaccoLeafItem;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class BlazebudCigarRecipe
extends CustomRecipe {
    private final ResourceLocation id;
    private final ItemStack output;
    private final NonNullList<Ingredient> recipeItems;

    public BlazebudCigarRecipe(ResourceLocation id, ItemStack output, NonNullList<Ingredient> recipeItems) {
        super(id, CraftingBookCategory.MISC);
        this.id = id;
        this.output = output;
        this.recipeItems = recipeItems;
    }

    public boolean matches(CraftingContainer craftingContainer, Level level) {
        ItemStack itemstack = ItemStack.f_41583_;
        ItemStack blazebudStack = ItemStack.f_41583_;
        ItemStack tobaccoLeafStack = ItemStack.f_41583_;
        for (int i = 0; i < craftingContainer.m_6643_(); ++i) {
            itemstack = craftingContainer.m_8020_(i);
            if (itemstack.m_41619_()) continue;
            if (itemstack.m_41720_() instanceof BlazebudItem) {
                blazebudStack = itemstack;
                continue;
            }
            if (itemstack.m_41720_() instanceof TobaccoLeafItem) {
                tobaccoLeafStack = itemstack;
                continue;
            }
            return false;
        }
        return !blazebudStack.m_41619_() && !tobaccoLeafStack.m_41619_();
    }

    public ItemStack assemble(CraftingContainer craftingContainer, RegistryAccess pRegistryAccess) {
        ItemStack itemstack = ItemStack.f_41583_;
        ItemStack blazebudStack = ItemStack.f_41583_;
        ItemStack tobaccoLeafStack = ItemStack.f_41583_;
        for (int i = 0; i < craftingContainer.m_6643_(); ++i) {
            itemstack = craftingContainer.m_8020_(i);
            if (itemstack.m_41619_()) continue;
            if (itemstack.m_41720_() instanceof BlazebudItem) {
                blazebudStack = itemstack;
                continue;
            }
            if (!(itemstack.m_41720_() instanceof TobaccoLeafItem)) continue;
            tobaccoLeafStack = itemstack;
        }
        Item newItem = (Item)ModItems.BLAZEBUD_CIGAR.get();
        ItemStack returnStack = new ItemStack((ItemLike)newItem, 1);
        CompoundTag compoundtag = new CompoundTag();
        String displayType = "";
        BlazebudItem budItem = (BlazebudItem)blazebudStack.m_41720_();
        switch (budItem.getBlazebudType()) {
            case "enderpearl_echos": {
                displayType = "Enderpearl Echos";
                break;
            }
            case "redstone_charge": {
                displayType = "Redstone Charge";
                break;
            }
            case "creeper_green": {
                displayType = "Creeper Green";
                break;
            }
            case "emerald_dream": {
                displayType = "Emerald Dream ";
                break;
            }
            case "blockhead_blue": {
                displayType = "Blockhead Blue";
                break;
            }
            case "netherwart_echos": {
                displayType = "Netherwart Echos";
            }
        }
        compoundtag.m_128359_("wrapper", tobaccoLeafStack.m_41611_().getString());
        compoundtag.m_128359_("blazebud", displayType);
        returnStack.m_41751_(compoundtag);
        return returnStack;
    }

    public boolean m_8004_(int p_44298_, int p_44299_) {
        return p_44298_ * p_44299_ >= 2;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)ModRecipes.BLAZEBUD_CIGAR_RECIPE_SERIALIZER.get();
    }

    public static class Serializer
    implements RecipeSerializer<BlazebudCigarRecipe> {
        public static final Serializer INSTANCE = new Serializer();
        public static final ResourceLocation ID = new ResourceLocation("herbalistmod", "crafting_special_blazebud_cigar");

        public BlazebudCigarRecipe fromJson(ResourceLocation id, JsonObject json) {
            ItemStack output = ShapedRecipe.m_151274_((JsonObject)GsonHelper.m_13930_((JsonObject)json, (String)"output"));
            JsonArray ingredients = GsonHelper.m_13933_((JsonObject)json, (String)"ingredients");
            NonNullList inputs = NonNullList.m_122780_((int)1, (Object)Ingredient.f_43901_);
            for (int i = 0; i < inputs.size(); ++i) {
                inputs.set(i, (Object)Ingredient.m_43917_((JsonElement)ingredients.get(i)));
            }
            return new BlazebudCigarRecipe(id, output, (NonNullList<Ingredient>)inputs);
        }

        public BlazebudCigarRecipe fromNetwork(ResourceLocation id, FriendlyByteBuf buf) {
            NonNullList inputs = NonNullList.m_122780_((int)buf.readInt(), (Object)Ingredient.f_43901_);
            for (int i = 0; i < inputs.size(); ++i) {
                inputs.set(i, (Object)Ingredient.m_43940_((FriendlyByteBuf)buf));
            }
            ItemStack output = buf.m_130267_();
            return new BlazebudCigarRecipe(id, output, (NonNullList<Ingredient>)inputs);
        }

        public void toNetwork(FriendlyByteBuf buf, BlazebudCigarRecipe recipe) {
            buf.writeInt(recipe.m_7527_().size());
            for (Ingredient ing : recipe.m_7527_()) {
                ing.m_43923_(buf);
            }
            buf.writeItemStack(recipe.m_8043_(null), false);
        }

        private static <G> Class<G> castClass(Class<?> cls) {
            return cls;
        }
    }

    public static class Type
    implements RecipeType<BlazebudCigarRecipe> {
        public static final Type INSTANCE = new Type();
        public static final String ID = "crafting_special_blazebud_cigar";

        private Type() {
        }
    }
}

