/*
 * Decompiled with CFR 0.152.
 */
package com.diggydwarff.herbalistmod.world;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderSet;
import net.minecraft.core.RegistrySetBuilder;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraftforge.common.data.DatapackBuiltinEntriesProvider;
import net.minecraftforge.common.world.BiomeModifier;
import net.minecraftforge.common.world.ModifiableBiomeInfo;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;

public class HerbalistBiomeModifier {
    public static final String MODID = "herbalistmod";
    private static final boolean ENABLED = true;
    private static final DeferredRegister<Codec<? extends BiomeModifier>> BIOME_MODIFIER_SERIALIZERS = DeferredRegister.create((ResourceKey)ForgeRegistries.Keys.BIOME_MODIFIER_SERIALIZERS, (String)"herbalistmod");
    private static final RegistryObject<Codec<HerbalistModifier>> MODIFY_BIOMES = BIOME_MODIFIER_SERIALIZERS.register("modify_biomes", () -> RecordCodecBuilder.create(builder -> builder.group((App)Biome.f_47432_.fieldOf("biomes").forGetter(HerbalistModifier::biomes), (App)Codec.STRING.xmap(s -> Biome.Precipitation.valueOf((String)s.toUpperCase(Locale.ROOT)), e -> e.name().toLowerCase(Locale.ROOT)).fieldOf("precipitation").forGetter(HerbalistModifier::precipitation), (App)Codec.INT.fieldOf("water_color").forGetter(HerbalistModifier::waterColor)).apply((Applicative)builder, HerbalistModifier::new)));
    private static final ResourceKey<PlacedFeature> DREAMCAP_MUSHROOM_PATCH = ResourceKey.m_135785_((ResourceKey)Registries.f_256988_, (ResourceLocation)new ResourceLocation("herbalistmod", "dreamcap_mushroom_patch"));
    private static final ResourceKey<PlacedFeature> SNOWCAP_MUSHROOM_PATCH = ResourceKey.m_135785_((ResourceKey)Registries.f_256988_, (ResourceLocation)new ResourceLocation("herbalistmod", "snowcap_mushroom_patch"));
    private static final ResourceKey<PlacedFeature> GOLDENGLOW_MUSHROOM_PATCH = ResourceKey.m_135785_((ResourceKey)Registries.f_256988_, (ResourceLocation)new ResourceLocation("herbalistmod", "goldenglow_mushroom_patch"));
    private static final ResourceKey<PlacedFeature> ETHEREAL_FUNGUS_PATCH = ResourceKey.m_135785_((ResourceKey)Registries.f_256988_, (ResourceLocation)new ResourceLocation("herbalistmod", "ethereal_fungus_patch"));
    private static final ResourceKey<PlacedFeature> DIVINERS_SAGE_PATCH = ResourceKey.m_135785_((ResourceKey)Registries.f_256988_, (ResourceLocation)new ResourceLocation("herbalistmod", "diviners_sage_patch"));
    private static final ResourceKey<PlacedFeature> MIRAGE_CACTUS_PATCH = ResourceKey.m_135785_((ResourceKey)Registries.f_256988_, (ResourceLocation)new ResourceLocation("herbalistmod", "mirage_cactus_patch"));
    private static final ResourceKey<BiomeModifier> ADD_DREAMCAP_MUSHROOM_PATCH = ResourceKey.m_135785_((ResourceKey)ForgeRegistries.Keys.BIOME_MODIFIERS, (ResourceLocation)new ResourceLocation("herbalistmod", "add_dreamcap_mushroom_patch"));
    private static final ResourceKey<BiomeModifier> ADD_SNOWCAP_MUSHROOM_PATCH = ResourceKey.m_135785_((ResourceKey)ForgeRegistries.Keys.BIOME_MODIFIERS, (ResourceLocation)new ResourceLocation("herbalistmod", "add_snowcap_mushroom_patch"));
    private static final ResourceKey<BiomeModifier> ADD_GOLDENGLOW_MUSHROOM_PATCH = ResourceKey.m_135785_((ResourceKey)ForgeRegistries.Keys.BIOME_MODIFIERS, (ResourceLocation)new ResourceLocation("herbalistmod", "add_goldenglow_mushroom_patch"));
    private static final ResourceKey<BiomeModifier> ADD_ETHEREAL_FUNGUS_PATCH = ResourceKey.m_135785_((ResourceKey)ForgeRegistries.Keys.BIOME_MODIFIERS, (ResourceLocation)new ResourceLocation("herbalistmod", "add_ethereal_fungus_patch"));
    private static final ResourceKey<BiomeModifier> ADD_DIVINERS_SAGE_PATCH = ResourceKey.m_135785_((ResourceKey)ForgeRegistries.Keys.BIOME_MODIFIERS, (ResourceLocation)new ResourceLocation("herbalistmod", "add_diviners_sage_patch"));
    private static final ResourceKey<BiomeModifier> ADD_MIRAGE_CACTUS_PATCH = ResourceKey.m_135785_((ResourceKey)ForgeRegistries.Keys.BIOME_MODIFIERS, (ResourceLocation)new ResourceLocation("herbalistmod", "add_mirage_cactus_patch"));
    private static final RegistrySetBuilder BUILDER = new RegistrySetBuilder();

    public static void register(IEventBus modEventBus) {
        BIOME_MODIFIER_SERIALIZERS.register(modEventBus);
    }

    private void onGatherData(GatherDataEvent event) {
        event.getGenerator().addProvider(event.includeServer(), output -> new BiomeModifiers(output, event.getLookupProvider()));
    }

    private static class BiomeModifiers
    extends DatapackBuiltinEntriesProvider {
        public BiomeModifiers(PackOutput output, CompletableFuture<HolderLookup.Provider> registries) {
            super(output, registries, BUILDER, Set.of(HerbalistBiomeModifier.MODID));
        }

        public String m_6055_() {
            return "Biome Modifier Registries: herbalistmod";
        }
    }

    public record HerbalistModifier(HolderSet<Biome> biomes, Biome.Precipitation precipitation, int waterColor) implements BiomeModifier
    {
        public void modify(Holder<Biome> biome, BiomeModifier.Phase phase, ModifiableBiomeInfo.BiomeInfo.Builder builder) {
            if (phase == BiomeModifier.Phase.MODIFY && this.biomes.m_203333_(biome)) {
                builder.getClimateSettings().setHasPrecipitation(true);
                builder.getSpecialEffects().m_48034_(this.waterColor);
                if (this.precipitation == Biome.Precipitation.SNOW) {
                    builder.getClimateSettings().setTemperature(0.0f);
                }
            }
        }

        public Codec<? extends BiomeModifier> codec() {
            return (Codec)MODIFY_BIOMES.get();
        }
    }
}

