/*
 * Decompiled with CFR 0.152.
 */
package me.itzme1on.alcocraftplus.client.gui.handler;

import me.itzme1on.alcocraftplus.client.gui.handler.KegSlot;
import me.itzme1on.alcocraftplus.core.registries.RecipesRegistry;
import me.itzme1on.alcocraftplus.core.registries.ScreenHandlerRegistry;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class KegGuiHandler
extends AbstractContainerMenu {
    private final Container inventory;
    private final Level level;
    private final ContainerData propertyDelegate;

    public KegGuiHandler(int containerId, Inventory playerInventory) {
        this(containerId, playerInventory, (Container)new SimpleContainer(4), (ContainerData)new SimpleContainerData(5));
    }

    public KegGuiHandler(int containerId, Inventory playerInventory, Container inventory, ContainerData propertyDelegate) {
        super((MenuType)ScreenHandlerRegistry.KEG_MENU.get(), containerId);
        KegGuiHandler.m_38869_((Container)inventory, (int)4);
        this.inventory = inventory;
        this.level = playerInventory.f_35978_.m_9236_();
        this.propertyDelegate = propertyDelegate;
        inventory.m_5856_(playerInventory.f_35978_);
        this.m_38897_(new KegSlot(inventory, 0, 22, 27, this::isIngredient));
        this.m_38897_(new KegSlot(inventory, 1, 50, 27, this::isIngredient));
        this.m_38897_(new KegSlot(inventory, 2, 78, 27, this::isIngredient));
        this.m_38897_(new KegSlot(inventory, 3, 106, 27, this::isIngredient));
        this.addPlayerInventory(playerInventory);
        this.addPlayerHotBar(playerInventory);
        this.m_38884_(propertyDelegate);
    }

    public boolean isCrafting(int index) {
        return this.propertyDelegate.m_6413_(index * 2) > 0;
    }

    @NotNull
    public ItemStack m_7648_(Player player, int index) {
        ItemStack newStack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(index);
        if (slot.m_6657_()) {
            ItemStack originalStack = slot.m_7993_();
            newStack = originalStack.m_41777_();
            if (index < this.inventory.m_6643_() ? !this.m_38903_(originalStack, this.inventory.m_6643_(), this.f_38839_.size(), true) : !this.m_38903_(originalStack, 0, this.inventory.m_6643_(), false)) {
                return ItemStack.f_41583_;
            }
            if (originalStack.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
        }
        return newStack;
    }

    public boolean m_6875_(Player player) {
        return this.inventory.m_6542_(player);
    }

    private void addPlayerInventory(Inventory playerInventory) {
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.m_38897_(new Slot((Container)playerInventory, j + i * 9 + 9, 8 + j * 18, 84 + i * 18));
            }
        }
    }

    private void addPlayerHotBar(Inventory playerInventory) {
        for (int i = 0; i < 9; ++i) {
            this.m_38897_(new Slot((Container)playerInventory, i, 8 + i * 18, 142));
        }
    }

    private boolean isIngredient(ItemStack stack) {
        return this.level.m_7465_().m_44013_((RecipeType)RecipesRegistry.KEG_RECIPE_TYPE.get()).stream().anyMatch(recipe -> recipe.m_7527_().stream().anyMatch(ingredient -> ingredient.test(stack)));
    }

    public int getProgress() {
        return this.propertyDelegate.m_6413_(0);
    }

    public int getMaxProgress() {
        return this.propertyDelegate.m_6413_(1);
    }

    public int getWaterLevel() {
        return this.propertyDelegate.m_6413_(2);
    }

    public int getBeerLevel() {
        return this.propertyDelegate.m_6413_(3);
    }

    public int getBeerType() {
        return this.propertyDelegate.m_6413_(4);
    }
}

