/*
 * Decompiled with CFR 0.152.
 */
package me.itzme1on.alcocraftplus.core.loot;

import dev.architectury.event.events.common.LootEvent;
import me.itzme1on.alcocraftplus.core.registries.ItemsRegistry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.LootTableReference;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemCountFunction;
import net.minecraft.world.level.storage.loot.predicates.LootItemRandomChanceCondition;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;

public class LootModifier {
    public static void modifyChestLootTable(ResourceLocation id, LootEvent.LootTableModificationContext context) {
        String prefix = "minecraft:chests/";
        String name = id.toString();
        if (name.startsWith(prefix)) {
            String file;
            switch (file = name.substring(name.indexOf(prefix) + prefix.length())) {
                case "abandoned_mineshaft": 
                case "bastion_treasure": 
                case "end_city_treasure": 
                case "igloo_chest": 
                case "nether_bridge": 
                case "pillager_outpost": 
                case "ruined_portal": 
                case "shipwreck_supply": 
                case "simple_dungeon": 
                case "underwater_ruin_big": 
                case "underwater_ruin_small": {
                    context.addPool(LootModifier.getPool(file));
                    break;
                }
            }
        }
    }

    public static void modifyGrassLootTable(LootEvent.LootTableModificationContext context) {
        LootPool.Builder builder = LootPool.m_79043_().m_79080_(LootItemRandomChanceCondition.m_81927_((float)0.07f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)ItemsRegistry.HOP_SEEDS.get()))).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)ConstantValue.m_165692_((float)1.0f)));
        context.addPool(builder.m_79082_());
    }

    public static LootPool getPool(String entryName) {
        return LootPool.m_79043_().m_79076_(LootModifier.getPoolEntry(entryName)).m_79082_();
    }

    private static LootPoolEntryContainer.Builder getPoolEntry(String name) {
        ResourceLocation table = new ResourceLocation("alcocraftplus", "chests/" + name);
        return LootTableReference.m_79776_((ResourceLocation)table);
    }

    public static void modifyLootTable(ResourceLocation id, LootEvent.LootTableModificationContext context) {
        if (id.equals((Object)new ResourceLocation("minecraft", "blocks/grass"))) {
            LootModifier.modifyGrassLootTable(context);
        } else {
            LootModifier.modifyChestLootTable(id, context);
        }
    }
}

