/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.bakery.core.compat.jei.category;

import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.satisfy.bakery.core.recipe.BakingStationRecipe;
import net.satisfy.bakery.core.registry.ObjectRegistry;
import org.jetbrains.annotations.NotNull;

public class BakerStationCategory
implements IRecipeCategory<BakingStationRecipe> {
    public static final RecipeType<BakingStationRecipe> CAKING = RecipeType.create((String)"bakery", (String)"caking", BakingStationRecipe.class);
    public static final ResourceLocation TEXTURE = new ResourceLocation("bakery", "textures/gui/baking_station.png");
    private final IDrawable background;
    private final IDrawable icon;

    public BakerStationCategory(IGuiHelper helper) {
        this.background = helper.createDrawable(TEXTURE, 0, 0, 176, 85);
        this.icon = helper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)ObjectRegistry.BAKER_STATION.get()));
    }

    @NotNull
    public RecipeType<BakingStationRecipe> getRecipeType() {
        return CAKING;
    }

    @NotNull
    public Component getTitle() {
        return ((Block)ObjectRegistry.BAKER_STATION.get()).m_49954_();
    }

    @NotNull
    public IDrawable getBackground() {
        return this.background;
    }

    @NotNull
    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, BakingStationRecipe recipe, IFocusGroup focuses) {
        builder.addSlot(RecipeIngredientRole.INPUT, 50, 25).addIngredients((Ingredient)recipe.m_7527_().get(0));
        builder.addSlot(RecipeIngredientRole.INPUT, 50, 43).addIngredients((Ingredient)recipe.m_7527_().get(1));
        builder.addSlot(RecipeIngredientRole.OUTPUT, 110, 35).addItemStack(recipe.m_8043_(null));
    }
}

