/*
 * Decompiled with CFR 0.152.
 */
package mekanism.generators.client.model;

import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.client.render.MekanismRenderer;
import mekanism.client.render.lib.Quad;
import mekanism.common.lib.Color;
import mekanism.generators.common.tile.fission.TileEntityFissionAssembly;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.ChunkRenderTypeSet;
import net.minecraftforge.client.model.BakedModelWrapper;
import net.minecraftforge.client.model.data.ModelData;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@NothingNullByDefault
public class FuelAssemblyBakedModel
extends BakedModelWrapper<BakedModel> {
    private static final Color GLOW_ARGB = Color.rgbad((double)0.466, (double)0.882, (double)0.929, (double)0.6);
    private static final Vec3 NORTH_EAST = new Vec3(0.95, 0.125, 0.05);
    private static final Vec3 SOUTH_WEST = new Vec3(0.05, 0.125, 0.95);
    private final Map<Direction, List<BakedQuad>> cachedGlows = new EnumMap<Direction, List<BakedQuad>>(Direction.class);
    @Nullable
    private ChunkRenderTypeSet renderTypes;
    private final double height;

    public FuelAssemblyBakedModel(BakedModel original, double height) {
        super(original);
        this.height = height;
    }

    @NotNull
    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, RandomSource rand, ModelData data, @Nullable RenderType renderType) {
        List quads = super.getQuads(state, side, rand, data, renderType);
        if (side != null && side.m_122434_().m_122479_() && renderType == RenderType.m_110466_() && data.has(TileEntityFissionAssembly.GLOWING)) {
            List allQuads = this.cachedGlows.computeIfAbsent(side, s -> {
                Vec3 startPos = switch (s) {
                    case Direction.NORTH, Direction.EAST -> NORTH_EAST;
                    case Direction.SOUTH, Direction.WEST -> SOUTH_WEST;
                    default -> throw new IllegalStateException("Unexpected face");
                };
                Quad.Builder quadBuilder = new Quad.Builder(MekanismRenderer.whiteIcon, s).light(240, 0xF00000).uv(0.0f, 0.0f, 16.0f, 16.0f).color(GLOW_ARGB).rect(startPos, 0.9, this.height, 1.0);
                return List.of(quadBuilder.build().bake());
            });
            if (quads.isEmpty()) {
                return allQuads;
            }
            ArrayList<BakedQuad> mergedQuads = new ArrayList<BakedQuad>(quads);
            mergedQuads.addAll(allQuads);
            return mergedQuads;
        }
        return quads;
    }

    public ChunkRenderTypeSet getRenderTypes(BlockState state, RandomSource rand, ModelData data) {
        if (data.has(TileEntityFissionAssembly.GLOWING)) {
            if (this.renderTypes == null) {
                this.renderTypes = ChunkRenderTypeSet.union((ChunkRenderTypeSet[])new ChunkRenderTypeSet[]{super.getRenderTypes(state, rand, data), ChunkRenderTypeSet.of((RenderType[])new RenderType[]{RenderType.m_110466_()})});
            }
            return this.renderTypes;
        }
        return super.getRenderTypes(state, rand, data);
    }
}

