/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.blocks;

import com.brandon3055.brandonscore.blocks.BlockBCore;
import com.brandon3055.brandonscore.registry.Feature;
import com.brandon3055.brandonscore.registry.IRegistryOverride;
import com.brandon3055.brandonscore.registry.IRenderOverride;
import com.brandon3055.draconicevolution.DraconicEvolution;
import com.brandon3055.draconicevolution.blocks.tileentity.TileEnergyCoreStabilizer;
import com.brandon3055.draconicevolution.blocks.tileentity.TileEnergyStorageCore;
import com.brandon3055.draconicevolution.blocks.tileentity.TileParticleGenerator;
import com.brandon3055.draconicevolution.client.render.tile.RenderTileECStabilizer;
import com.brandon3055.draconicevolution.lib.PropertyStringTemp;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ParticleGenerator
extends BlockBCore
implements ITileEntityProvider,
IRegistryOverride,
IRenderOverride {
    public static final PropertyStringTemp TYPE = new PropertyStringTemp("type", "normal", "inverted", "stabilizer", "stabilizer2");

    public ParticleGenerator() {
        super(Material.field_151573_f);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)TYPE, (Comparable)((Object)"normal")));
        this.addName(0, "particle_generator");
        this.addName(2, "energy_core_stabilizer");
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{TYPE});
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        return state;
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)TYPE, (Comparable)((Object)TYPE.fromMeta(meta)));
    }

    public int func_176201_c(IBlockState state) {
        return TYPE.toMeta((String)((Object)state.func_177229_b((IProperty)TYPE)));
    }

    public void func_149666_a(CreativeTabs tab, NonNullList<ItemStack> list) {
        list.add((Object)new ItemStack((Block)this, 1, 0));
        list.add((Object)new ItemStack((Block)this, 1, 2));
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean isNormalCube(IBlockState state, IBlockAccess world, BlockPos pos) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public int func_180651_a(IBlockState state) {
        return Math.min(this.func_176201_c(state), 2);
    }

    public TileEntity func_149915_a(World worldIn, int meta) {
        return meta == 0 || meta == 1 ? new TileParticleGenerator() : (meta == 2 || meta == 3 ? new TileEnergyCoreStabilizer() : null);
    }

    public boolean canConnectRedstone(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return ((String)((Object)state.func_177229_b((IProperty)TYPE))).equals("normal") || ((String)((Object)state.func_177229_b((IProperty)TYPE))).equals("inverted");
    }

    public int func_149750_m(IBlockState state) {
        return ((String)((Object)state.func_177229_b((IProperty)TYPE))).equals("stabilizer") || ((String)((Object)state.func_177229_b((IProperty)TYPE))).equals("stabilizer2") ? 10 : 0;
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return ((String)((Object)state.func_177229_b((IProperty)TYPE))).equals("stabilizer2") ? EnumBlockRenderType.INVISIBLE : super.func_149645_b(state);
    }

    public AxisAlignedBB func_180640_a(IBlockState state, World world, BlockPos pos) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileEnergyCoreStabilizer && ((TileEnergyCoreStabilizer)tile).isValidMultiBlock.value) {
            AxisAlignedBB bb = new AxisAlignedBB(tile.func_174877_v());
            bb = ((TileEnergyCoreStabilizer)tile).multiBlockAxis.func_176716_d() == EnumFacing.Plane.HORIZONTAL ? (((TileEnergyCoreStabilizer)tile).multiBlockAxis == EnumFacing.Axis.X ? bb.func_72314_b(0.0, 1.0, 1.0) : bb.func_72314_b(1.0, 1.0, 0.0)) : bb.func_72314_b(1.0, 0.0, 1.0);
            return bb;
        }
        return super.func_180640_a(state, world, pos);
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (((String)((Object)state.func_177229_b((IProperty)TYPE))).equals("normal") || ((String)((Object)state.func_177229_b((IProperty)TYPE))).equals("inverted")) {
            if (player.func_70093_af()) {
                world.func_175656_a(pos, state.func_177226_a((IProperty)TYPE, (Comparable)((Object)(((String)((Object)state.func_177229_b((IProperty)TYPE))).equals("normal") ? "inverted" : "normal"))));
            } else if (world.field_72995_K) {
                player.openGui((Object)DraconicEvolution.instance, 5, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
            }
        } else {
            TileEntity tile = world.func_175625_s(pos);
            if (tile instanceof TileEnergyCoreStabilizer) {
                ((TileEnergyCoreStabilizer)tile).onTileClicked(world, pos, state, player);
            }
        }
        return true;
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        world.func_175656_a(pos, state.func_177226_a((IProperty)TYPE, (Comparable)((Object)TYPE.fromMeta(stack.func_77952_i()))));
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileEnergyCoreStabilizer) {
            ((TileEnergyCoreStabilizer)tile).onPlaced();
        }
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileEnergyCoreStabilizer) {
            TileEnergyStorageCore core;
            if (((TileEnergyCoreStabilizer)tile).isValidMultiBlock.value) {
                ((TileEnergyCoreStabilizer)tile).deFormStructure();
            }
            if ((core = ((TileEnergyCoreStabilizer)tile).getCore()) != null) {
                world.func_175713_t(pos);
                ((TileEnergyCoreStabilizer)tile).validateStructure();
            }
        }
        super.func_180663_b(world, pos, state);
    }

    public void handleCustomRegistration(Feature feature) {
        GameRegistry.registerTileEntity(TileParticleGenerator.class, (String)(feature.getRegistryName() + ".particle"));
        GameRegistry.registerTileEntity(TileEnergyCoreStabilizer.class, (String)(feature.getRegistryName() + ".stabilize"));
    }

    @SideOnly(value=Side.CLIENT)
    public void registerRenderer(Feature feature) {
        ClientRegistry.bindTileEntitySpecialRenderer(TileEnergyCoreStabilizer.class, (TileEntitySpecialRenderer)new RenderTileECStabilizer());
    }

    public boolean registerNormal(Feature feature) {
        return true;
    }
}

