/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.blocks.tileentity;

import codechicken.lib.data.MCDataInput;
import com.brandon3055.brandonscore.blocks.TileBCBase;
import com.brandon3055.brandonscore.lib.Vec3I;
import com.brandon3055.brandonscore.lib.datamanager.IManagedData;
import com.brandon3055.brandonscore.lib.datamanager.ManagedBool;
import com.brandon3055.brandonscore.lib.datamanager.ManagedByte;
import com.brandon3055.brandonscore.lib.datamanager.ManagedLong;
import com.brandon3055.brandonscore.lib.datamanager.ManagedString;
import com.brandon3055.brandonscore.lib.datamanager.ManagedVec3I;
import com.brandon3055.draconicevolution.DEConfig;
import com.brandon3055.draconicevolution.DraconicEvolution;
import com.brandon3055.draconicevolution.api.IExtendedRFStorage;
import com.brandon3055.draconicevolution.blocks.tileentity.IMultiBlockPart;
import com.brandon3055.draconicevolution.blocks.tileentity.TileEnergyCoreStabilizer;
import com.brandon3055.draconicevolution.lib.EnergyCoreBuilder;
import com.brandon3055.draconicevolution.utils.LogHelper;
import com.brandon3055.draconicevolution.world.EnergyCoreStructure;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.internal.FMLNetworkHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileEnergyStorageCore
extends TileBCBase
implements ITickable,
IExtendedRFStorage,
IMultiBlockPart {
    public int frameMoveContactPoints = 0;
    public boolean isFrameMoving = false;
    public boolean moveBlocksProvided = false;
    public static final byte ORIENT_UNKNOWN = 0;
    public static final byte ORIENT_UP_DOWN = 1;
    public static final byte ORIENT_NORTH_SOUTH = 2;
    public static final byte ORIENT_EAST_WEST = 3;
    public static final EnumFacing[][] STAB_ORIENTATIONS = new EnumFacing[][]{new EnumFacing[0], EnumFacing.field_176754_o, {EnumFacing.UP, EnumFacing.DOWN, EnumFacing.EAST, EnumFacing.WEST}, {EnumFacing.UP, EnumFacing.DOWN, EnumFacing.NORTH, EnumFacing.SOUTH}};
    public final EnergyCoreStructure coreStructure = new EnergyCoreStructure().initialize(this);
    public final ManagedBool active = (ManagedBool)this.register("active", (IManagedData)new ManagedBool(false)).syncViaTile().saveToTile().trigerUpdate().finish();
    public final ManagedBool structureValid = (ManagedBool)this.register("structureValid", (IManagedData)new ManagedBool(false)).syncViaTile().saveToTile().trigerUpdate().finish();
    public final ManagedBool coreValid = (ManagedBool)this.register("coreValid", (IManagedData)new ManagedBool(false)).syncViaTile().saveToTile().trigerUpdate().finish();
    public final ManagedString invalidMessage = (ManagedString)this.register("invalidMessage", (IManagedData)new ManagedString("")).syncViaTile().finish();
    public final ManagedBool buildGuide = (ManagedBool)this.register("buildGuide", (IManagedData)new ManagedBool(false)).syncViaTile().saveToTile().trigerUpdate().finish();
    public final ManagedBool stabilizersOK = (ManagedBool)this.register("stabilizersOK", (IManagedData)new ManagedBool(false)).syncViaTile().saveToTile().trigerUpdate().finish();
    public final ManagedByte tier = (ManagedByte)this.register("tier", (IManagedData)new ManagedByte(1)).syncViaTile().saveToTile().trigerUpdate().finish();
    public final ManagedLong energy = (ManagedLong)this.register("energy", (IManagedData)new ManagedLong(0L)).syncViaTile().saveToTile().finish();
    public final ManagedVec3I[] stabOffsets = new ManagedVec3I[4];
    public final ManagedLong transferRate = (ManagedLong)this.register("transferRate", (IManagedData)new ManagedLong(0L)).syncViaContainer().finish();
    private int ticksElapsed = 0;
    private long[] flowArray = new long[20];
    private EnergyCoreBuilder activeBuilder = null;
    public float rotation = 0.0f;

    public TileEnergyStorageCore() {
        this.setShouldRefreshOnBlockChange();
        for (int i = 0; i < this.stabOffsets.length; ++i) {
            this.stabOffsets[i] = (ManagedVec3I)this.register("stabOffset" + i, (IManagedData)new ManagedVec3I(new Vec3I(0, -1, 0))).saveToTile().syncViaTile().finish();
        }
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            this.flowArray[this.ticksElapsed % 20] = this.energy.value - this.energy.lastTickValue;
            long total = 0L;
            for (long i : this.flowArray) {
                total += i;
            }
            this.transferRate.value = total / 20L;
            if (this.activeBuilder != null) {
                if (this.activeBuilder.isDead()) {
                    this.activeBuilder = null;
                } else {
                    this.activeBuilder.updateProcess();
                }
            }
            if (this.ticksElapsed % 500 == 0) {
                this.validateStructure();
            }
        } else {
            this.rotation += 1.0f;
        }
        super.update();
        if (this.ticksElapsed % 20 == 0 && !this.field_145850_b.field_72995_K && this.transferRate.detectChanges()) {
            this.dataManager.forceSync((IManagedData)this.transferRate);
        }
        if (this.field_145850_b.field_72995_K && this.active.value) {
            List players = this.field_145850_b.func_72872_a(EntityPlayer.class, new AxisAlignedBB(this.field_174879_c, this.field_174879_c.func_177982_a(1, 1, 1)).func_72314_b(10.0, 10.0, 10.0));
            for (EntityPlayer player : players) {
                double dist = player.func_70011_f((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() - 0.4, (double)this.field_174879_c.func_177952_p() + 0.5);
                double distNext = player.func_70011_f((double)this.field_174879_c.func_177958_n() + player.field_70159_w + 0.5, (double)this.field_174879_c.func_177956_o() + player.field_70181_x - 0.4, (double)this.field_174879_c.func_177952_p() + player.field_70179_y + 0.5);
                double threshold = this.tier.value > 2 ? (double)this.tier.value - 0.5 : (double)this.tier.value + 0.5;
                double boundary = distNext - threshold;
                double dir = dist - distNext;
                if (!(boundary <= 0.0)) continue;
                if (dir < 0.0) {
                    player.func_70091_d(MoverType.PLAYER, -player.field_70159_w * 1.5, -player.field_70181_x * 1.5, -player.field_70179_y * 1.5);
                }
                double multiplier = (threshold - dist) * 0.05;
                double xm = ((double)this.field_174879_c.func_177958_n() + 0.5 - player.field_70165_t) / distNext * multiplier;
                double ym = ((double)this.field_174879_c.func_177956_o() - 0.4 - player.field_70163_u) / distNext * multiplier;
                double zm = ((double)this.field_174879_c.func_177952_p() + 0.5 - player.field_70161_v) / distNext * multiplier;
                player.func_70091_d(MoverType.PLAYER, -xm, -ym, -zm);
            }
        }
        ++this.ticksElapsed;
    }

    public void onStructureClicked(World world, BlockPos blockClicked, IBlockState state, EntityPlayer player) {
        if (!world.field_72995_K) {
            this.validateStructure();
            FMLNetworkHandler.openGui((EntityPlayer)player, (Object)DraconicEvolution.instance, (int)16, (World)world, (int)this.field_174879_c.func_177958_n(), (int)this.field_174879_c.func_177956_o(), (int)this.field_174879_c.func_177952_p());
        }
    }

    public void activateCore() {
        if (this.field_145850_b.field_72995_K || !this.validateStructure()) {
            return;
        }
        if (this.energy.value > this.getCapacity()) {
            this.energy.value = this.getCapacity();
        }
        this.buildGuide.value = false;
        this.coreStructure.formTier(this.tier.value);
        this.active.value = true;
        this.updateStabilizers(true);
    }

    public void deactivateCore() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        this.coreStructure.revertTier(this.tier.value);
        this.active.value = false;
        this.updateStabilizers(false);
    }

    private long getCapacity() {
        if (this.tier.value <= 0 || this.tier.value > 8) {
            LogHelper.error("Tier not valid! WTF!!!");
            return 0L;
        }
        return (long)DEConfig.coreCapacity[this.tier.value - 1];
    }

    public void receivePacketFromClient(MCDataInput data, EntityPlayerMP client, int id) {
        if (id == 0) {
            if (this.active.value) {
                this.deactivateCore();
            } else {
                this.activateCore();
            }
        } else if (id == 1) {
            if (!this.active.value && this.tier.value < 8) {
                this.tier.value = (byte)(this.tier.value + 1);
                this.validateStructure();
            }
        } else if (id == 2) {
            if (!this.active.value && this.tier.value > 1) {
                this.tier.value = (byte)(this.tier.value - 1);
                this.validateStructure();
            }
        } else if (id == 3) {
            if (!this.active.value) {
                this.buildGuide.value = !this.buildGuide.value;
            }
        } else if (id == 4 && !this.active.value) {
            this.startBuilder((EntityPlayer)client);
        }
    }

    private void startBuilder(EntityPlayer player) {
        if (this.activeBuilder != null && !this.activeBuilder.isDead()) {
            player.func_145747_a(new TextComponentTranslation("ecore.de.already_assembling.txt", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.RED)));
        } else {
            this.activeBuilder = new EnergyCoreBuilder(this, player);
        }
    }

    private void updateStabilizers(boolean coreActive) {
        for (ManagedVec3I offset : this.stabOffsets) {
            BlockPos tilePos = this.field_174879_c.func_177982_a(-offset.vec.x, -offset.vec.y, -offset.vec.z);
            TileEntity tile = this.field_145850_b.func_175625_s(tilePos);
            if (!(tile instanceof TileEnergyCoreStabilizer)) continue;
            ((TileEnergyCoreStabilizer)tile).isCoreActive.value = coreActive;
        }
    }

    @Override
    public boolean validateStructure() {
        boolean valid = this.checkStabilizers();
        this.coreValid.value = this.coreStructure.checkTier(this.tier.value);
        if (!this.coreValid.value) {
            BlockPos pos = this.coreStructure.invalidBlock;
            this.invalidMessage.value = "Error At: x:" + pos.func_177958_n() + ", y:" + pos.func_177956_o() + ", z:" + pos.func_177952_p() + " Expected: " + this.coreStructure.expectedBlock;
            valid = false;
        }
        if (!valid && this.active.value) {
            this.active.value = false;
            this.deactivateCore();
        }
        this.structureValid.value = valid;
        if (valid) {
            this.invalidMessage.value = "";
        }
        return valid;
    }

    public boolean checkStabilizers() {
        boolean flag = true;
        if (this.stabilizersOK.value) {
            for (ManagedVec3I offset : this.stabOffsets) {
                BlockPos tilePos = this.field_174879_c.func_177973_b((Vec3i)offset.vec.getPos());
                TileEntity tile = this.field_145850_b.func_175625_s(tilePos);
                if (tile instanceof TileEnergyCoreStabilizer && ((TileEnergyCoreStabilizer)tile).hasCoreLock.value && ((TileEnergyCoreStabilizer)tile).getCore() == this && ((TileEnergyCoreStabilizer)tile).isStabilizerValid(this.tier.value, this)) continue;
                flag = false;
                break;
            }
            if (!flag) {
                this.stabilizersOK.value = false;
                this.releaseStabilizers();
            }
        } else {
            for (int orient = 1; orient < STAB_ORIENTATIONS.length; ++orient) {
                EnumFacing[] dirs = STAB_ORIENTATIONS[orient];
                ArrayList<TileEnergyCoreStabilizer> stabsFound = new ArrayList<TileEnergyCoreStabilizer>();
                block2: for (int fIndex = 0; fIndex < dirs.length; ++fIndex) {
                    EnumFacing facing = dirs[fIndex];
                    for (int dist = 0; dist < 16; ++dist) {
                        BlockPos pos1 = this.field_174879_c.func_177982_a(facing.func_82601_c() * dist, facing.func_96559_d() * dist, facing.func_82599_e() * dist);
                        TileEntity stabilizer = this.field_145850_b.func_175625_s(pos1);
                        if (!(stabilizer instanceof TileEnergyCoreStabilizer) || ((TileEnergyCoreStabilizer)stabilizer).hasCoreLock.value && !((TileEnergyCoreStabilizer)stabilizer).getCore().equals(this) || !((TileEnergyCoreStabilizer)stabilizer).isStabilizerValid(this.tier.value, this)) continue;
                        stabsFound.add((TileEnergyCoreStabilizer)stabilizer);
                        continue block2;
                    }
                }
                if (stabsFound.size() == 4) {
                    for (TileEnergyCoreStabilizer stab : stabsFound) {
                        this.stabOffsets[stabsFound.indexOf((Object)stab)].vec = new Vec3I(this.field_174879_c.func_177958_n() - stab.func_174877_v().func_177958_n(), this.field_174879_c.func_177956_o() - stab.func_174877_v().func_177956_o(), this.field_174879_c.func_177952_p() - stab.func_174877_v().func_177952_p());
                        stab.setCore(this);
                    }
                    this.stabilizersOK.value = true;
                    break;
                }
                flag = false;
            }
        }
        return flag;
    }

    private void releaseStabilizers() {
        for (ManagedVec3I offset : this.stabOffsets) {
            BlockPos tilePos = this.field_174879_c.func_177982_a(-offset.vec.x, -offset.vec.y, -offset.vec.z);
            TileEntity tile = this.field_145850_b.func_175625_s(tilePos);
            if (tile instanceof TileEnergyCoreStabilizer) {
                ((TileEnergyCoreStabilizer)tile).hasCoreLock.value = false;
                ((TileEnergyCoreStabilizer)tile).coreOffset.vec.y = 0;
            }
            offset.vec = new Vec3I(0, -1, 0);
        }
    }

    public int receiveEnergy(int maxReceive, boolean simulate) {
        if (this.field_145850_b.field_72995_K) {
            return 0;
        }
        long energyReceived = Math.min(this.getExtendedCapacity() - this.energy.value, (long)maxReceive);
        if (!simulate) {
            this.energy.value += energyReceived;
        }
        return (int)energyReceived;
    }

    public int extractEnergy(int maxExtract, boolean simulate) {
        if (this.field_145850_b.field_72995_K) {
            return 0;
        }
        long energyExtracted = Math.min(this.energy.value, (long)maxExtract);
        if (!simulate) {
            this.energy.value -= energyExtracted;
        }
        return (int)energyExtracted;
    }

    @Override
    public long getExtendedStorage() {
        return this.energy.value;
    }

    @Override
    public long getExtendedCapacity() {
        return this.getCapacity();
    }

    @Override
    public boolean isStructureValid() {
        return this.structureValid.value;
    }

    @Override
    public IMultiBlockPart getController() {
        return this;
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        return INFINITE_EXTENT_AABB;
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return 65536.0;
    }

    public boolean shouldRenderInPass(int pass) {
        return true;
    }
}

