/*
 * Decompiled with CFR 0.152.
 */
package twilightforest;

import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nullable;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.WrongUsageException;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import twilightforest.TFFeature;
import twilightforest.capabilities.CapabilityList;
import twilightforest.capabilities.shield.IShieldCapability;
import twilightforest.world.ChunkGeneratorTFBase;
import twilightforest.world.TFWorld;
import twilightforest.world.WorldProviderTwilightForest;

public class CommandTF
extends CommandBase {
    private static final List<String> aliases = ImmutableList.of((Object)"tffeature", (Object)"twilightforest", (Object)"tf");

    public List<String> func_71514_a() {
        return aliases;
    }

    public String func_71517_b() {
        return "tffeature";
    }

    public String func_71518_a(ICommandSender sender) {
        return "commands.tffeature.usage";
    }

    public int func_82362_a() {
        return 2;
    }

    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, @Nullable BlockPos targetPos) {
        if (args.length == 1) {
            return CommandTF.func_71530_a((String[])args, (String[])EnumActions.ACTION_LIST);
        }
        if (args.length > 1) {
            try {
                String[] argsMoved = Arrays.copyOfRange(args, 1, args.length);
                return EnumActions.valueOf(args[0].toUpperCase(Locale.ROOT)).tabCompletion(server, sender, argsMoved, targetPos);
            }
            catch (Throwable e) {
                return Collections.emptyList();
            }
        }
        return Collections.emptyList();
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        if (args.length > 0) {
            try {
                EnumActions.valueOf(args[0].toUpperCase(Locale.ROOT)).execute(server, sender, args);
            }
            catch (IllegalArgumentException e) {
                throw new WrongUsageException("commands.tffeature.usage", new Object[0]);
            }
        } else {
            throw new CommandException("commands.tffeature.usage", new Object[0]);
        }
    }

    private static void changeStructureActivity(ICommandSender sender, boolean flag) throws CommandException {
        BlockPos pos;
        EntityPlayerMP player = CommandTF.func_71521_c((ICommandSender)sender);
        int dx = MathHelper.func_76128_c((double)player.field_70165_t);
        int dy = MathHelper.func_76128_c((double)player.field_70163_u);
        int dz = MathHelper.func_76128_c((double)player.field_70161_v);
        if (!(player.field_70170_p.field_73011_w instanceof WorldProviderTwilightForest)) {
            throw new CommandException("commands.tffeature.not_in_twilight_forest", new Object[0]);
        }
        ChunkGeneratorTFBase chunkProvider = (ChunkGeneratorTFBase)TFWorld.getChunkGenerator(player.field_70170_p);
        if (!chunkProvider.isBlockInStructureBB(pos = new BlockPos(dx, dy, dz))) {
            throw new CommandException("commands.tffeature.structure.required", new Object[0]);
        }
        sender.func_145747_a((ITextComponent)new TextComponentTranslation("commands.tffeature.structure.conquer.update", new Object[]{chunkProvider.isStructureConquered(pos), flag}));
        chunkProvider.setStructureConquered(dx, dy, dz, flag);
    }

    public boolean func_82358_a(String[] args, int index) {
        try {
            return EnumActions.valueOf(args[0].toUpperCase(Locale.ROOT)).isUsernameIndex(args, index);
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    private static enum EnumActions {
        CENTER{

            @Override
            protected void execute(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
                EntityPlayerMP player = CommandBase.func_71521_c((ICommandSender)sender);
                int dx = MathHelper.func_76128_c((double)player.field_70165_t);
                int dz = MathHelper.func_76128_c((double)player.field_70161_v);
                BlockPos cc = TFFeature.getNearestCenterXYZ(dx >> 4, dz >> 4, player.field_70170_p);
                boolean fc = TFFeature.isInFeatureChunk(player.field_70170_p, dx, dz);
                sender.func_145747_a((ITextComponent)new TextComponentTranslation("commands.tffeature.center", new Object[]{cc}));
                sender.func_145747_a((ITextComponent)new TextComponentTranslation("commands.tffeature.chunk", new Object[]{fc}));
            }
        }
        ,
        CONQUER{

            @Override
            protected void execute(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
                CommandTF.changeStructureActivity(sender, true);
            }
        }
        ,
        INFO{

            @Override
            protected void execute(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
                EntityPlayerMP player = CommandBase.func_71521_c((ICommandSender)sender);
                int dx = MathHelper.func_76128_c((double)player.field_70165_t);
                int dy = MathHelper.func_76128_c((double)player.field_70163_u);
                int dz = MathHelper.func_76128_c((double)player.field_70161_v);
                if (!(player.field_70170_p.field_73011_w instanceof WorldProviderTwilightForest)) {
                    throw new CommandException("commands.tffeature.not_in_twilight_forest", new Object[0]);
                }
                TFFeature nearbyFeature = TFFeature.getFeatureAt(dx, dz, player.field_70170_p);
                sender.func_145747_a((ITextComponent)new TextComponentTranslation("commands.tffeature.nearest", new Object[]{nearbyFeature.name}));
                ChunkGeneratorTFBase chunkProvider = (ChunkGeneratorTFBase)TFWorld.getChunkGenerator(player.field_70170_p);
                BlockPos pos = new BlockPos(dx, dy, dz);
                if (chunkProvider.isBlockInStructureBB(pos)) {
                    sender.func_145747_a((ITextComponent)new TextComponentTranslation("commands.tffeature.structure.inside", new Object[0]));
                    sender.func_145747_a((ITextComponent)new TextComponentTranslation("commands.tffeature.structure.conquer.status", new Object[]{chunkProvider.isStructureConquered(pos)}));
                } else {
                    sender.func_145747_a((ITextComponent)new TextComponentTranslation("commands.tffeature.structure.outside", new Object[0]));
                }
            }
        }
        ,
        LOCATE{
            private final String[] STRUCTURE_LIST;
            {
                this.STRUCTURE_LIST = new String[]{TFFeature.SMALL_HILL.name, TFFeature.MEDIUM_HILL.name, TFFeature.LARGE_HILL.name, TFFeature.HEDGE_MAZE.name, TFFeature.NAGA_COURTYARD.name, TFFeature.LICH_TOWER.name, TFFeature.ICE_TOWER.name, TFFeature.QUEST_GROVE.name, TFFeature.HYDRA_LAIR.name, TFFeature.LABYRINTH.name, TFFeature.DARK_TOWER.name, TFFeature.KNIGHT_STRONGHOLD.name, TFFeature.YETI_CAVE.name, TFFeature.TROLL_CAVE.name, TFFeature.FINAL_CASTLE.name, TFFeature.MUSHROOM_TOWER.name};
            }

            @Override
            protected void execute(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
                if (args.length != 2) {
                    throw new WrongUsageException("commands.tffeature.locate.usage", new Object[0]);
                }
                if (!(CommandBase.func_71521_c((ICommandSender)sender).field_70170_p.field_73011_w instanceof WorldProviderTwilightForest)) {
                    throw new CommandException("commands.tffeature.not_in_twilight_forest", new Object[0]);
                }
                String s = args[1];
                BlockPos blockpos = sender.func_130014_f_().func_190528_a(s, sender.func_180425_c(), false);
                if (blockpos != null) {
                    sender.func_145747_a((ITextComponent)new TextComponentTranslation("commands.locate.success", new Object[]{s, blockpos.func_177958_n(), blockpos.func_177952_p()}));
                } else {
                    blockpos = sender.func_130014_f_().func_190528_a("twilightforest:" + s, sender.func_180425_c(), false);
                    if (blockpos != null) {
                        sender.func_145747_a((ITextComponent)new TextComponentTranslation("commands.locate.success", new Object[]{s, blockpos.func_177958_n(), blockpos.func_177952_p()}));
                    } else {
                        throw new CommandException("commands.locate.failure", new Object[]{s});
                    }
                }
            }

            @Override
            protected List<String> tabCompletion(MinecraftServer server, ICommandSender sender, String[] args, @Nullable BlockPos targetPos) {
                return args.length == 1 ? CommandBase.func_71530_a((String[])args, (String[])this.STRUCTURE_LIST) : Collections.emptyList();
            }
        }
        ,
        REACTIVATE{

            @Override
            protected void execute(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
                CommandTF.changeStructureActivity(sender, false);
            }
        }
        ,
        SHIELD{

            @Override
            protected boolean isUsernameIndex(String[] args, int index) {
                return index == 1;
            }

            @Override
            protected void execute(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
                Entity entity = CommandBase.func_184885_b((MinecraftServer)server, (ICommandSender)sender, (String)args[1]);
                if (args.length >= 4 && entity.hasCapability(CapabilityList.SHIELDS, null)) {
                    boolean temp = args.length < 5 || Boolean.valueOf(args[4]) != false;
                    IShieldCapability cap = (IShieldCapability)entity.getCapability(CapabilityList.SHIELDS, null);
                    if (cap != null) {
                        if ("set".equals(args[2].toLowerCase(Locale.ROOT))) {
                            cap.setShields(Integer.valueOf(args[3]), temp);
                        } else if ("add".equals(args[2].toLowerCase(Locale.ROOT))) {
                            cap.addShields(Integer.valueOf(args[3]), temp);
                        }
                    }
                }
            }
        };

        private static final String[] ACTION_LIST;

        protected abstract void execute(MinecraftServer var1, ICommandSender var2, String[] var3) throws CommandException;

        protected List<String> tabCompletion(MinecraftServer server, ICommandSender sender, String[] args, @Nullable BlockPos targetPos) {
            return Collections.emptyList();
        }

        protected boolean isUsernameIndex(String[] args, int index) {
            return false;
        }

        static {
            int length = EnumActions.values().length;
            String[] list = new String[length];
            for (EnumActions action : EnumActions.values()) {
                list[action.ordinal()] = action.toString().toLowerCase(Locale.ROOT);
            }
            ACTION_LIST = list;
        }
    }
}

