/*
 * Decompiled with CFR 0.152.
 */
package twilightforest;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import twilightforest.IMCHandler;
import twilightforest.TwilightForestMod;

@Config(modid="twilightforest")
@Mod.EventBusSubscriber(modid="twilightforest")
public class TFConfig {
    @Config.Ignore
    private static final String config = "twilightforest.config.";
    @Config.LangKey(value="twilightforest.config.dimension")
    @Config.Comment(value={"Settings that are not reversible without consequences."})
    public static Dimension dimension = new Dimension();
    @Config.LangKey(value="twilightforest.config.compat")
    @Config.Comment(value={"Should TF Compatibility load? Turn off if TF's Compatibility is causing crashes or if not desired."})
    public static boolean doCompat = true;
    @Config.LangKey(value="twilightforest.config.tree_tweaks")
    @Config.Comment(value={"Lets you sacrifice various things to improve world performance."})
    public static Performance performance = new Performance();
    @Config.LangKey(value="twilightforest.config.silent_cicadas")
    @Config.Comment(value={"Make cicadas silent for those having sound library problems, or otherwise finding them annoying."})
    public static boolean silentCicadas = false;
    @Config.LangKey(value="twilightforest.config.first_person_effects")
    @Config.Comment(value={"Controls whether various effects from the mod are rendered while in first-person view. Turn this off if you find them distracting."})
    public static boolean firstPersonEffects = true;
    @Config.LangKey(value="twilightforest.config.portals_in_other_dimensions")
    @Config.Comment(value={"Allow portals to the Twilight Forest to be made outside of dimension 0. May be considered an exploit."})
    public static boolean allowPortalsInOtherDimensions = false;
    @Config.LangKey(value="twilightforest.config.admin_portals")
    @Config.Comment(value={"Allow portals only for admins (Operators). This severely reduces the range in which the mod usually scans for valid portal conditions, and it scans near ops only."})
    public static boolean adminOnlyPortals = false;
    @Config.LangKey(value="twilightforest.config.portals")
    @Config.Comment(value={"Disable Twilight Forest portal creation entirely. Provided for server operators looking to restrict action to the dimension."})
    public static boolean disablePortalCreation = false;
    @Config.LangKey(value="twilightforest.config.portal_creator")
    @Config.Comment(value={"Registry String IDs of items used to create the Twilight Forest Portal. (domain:regname:meta) meta is optional."})
    public static String[] portalCreationItems = new String[]{"minecraft:diamond"};
    @Config.LangKey(value="twilightforest.config.portal_lighting")
    @Config.Comment(value={"Set this true if you want the lightning that zaps the portal to not set things on fire. For those who don't like fun."})
    public static boolean portalLightning = false;
    @Config.LangKey(value="twilightforest.config.portal_return")
    @Config.Comment(value={"If false, the return portal will require the activation item."})
    public static boolean shouldReturnPortalBeUsable = true;
    @Config.LangKey(value="twilightforest.config.uncrafting")
    @Config.Comment(value={"Disable the uncrafting function of the uncrafting table. Provided as an option when interaction with other mods produces exploitable recipes."})
    public static boolean disableUncrafting = false;
    @Config.LangKey(value="twilightforest.config.antibuilder_blacklist")
    @Config.Comment(value={"Anti-Builder blacklist. (domain:block:meta) meta is optional."})
    public static String[] antibuilderBlacklist = new String[]{"minecraft:bedrock", "tombmanygraves:grave_block"};
    @Config.LangKey(value="twilightforest.config.animate_trophyitem")
    @Config.Comment(value={"Rotate trophy heads on item model. Has no performance impact at all. For those who don't like fun."})
    public static boolean rotateTrophyHeadsGui = true;
    @Config.LangKey(value="twilightforest.config.shield_parry")
    public static ShieldInteractions shieldInteractions = new ShieldInteractions();
    @Config.LangKey(value="twilightforest.config.loading_screen")
    @Config.Comment(value={"Client only: Controls for the Loading screen"})
    public static final LoadingScreen loadingScreen = new LoadingScreen();
    @Config.Ignore
    private static ImmutableSet<IBlockState> disallowBreakingBlockList;

    @SubscribeEvent
    public static void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.getModID().equals("twilightforest")) {
            ConfigManager.sync((String)"twilightforest", (Config.Type)Config.Type.INSTANCE);
            TFConfig.loadAntiBuilderBlacklist();
            loadingScreen.loadLoadingScreenIcons();
        }
    }

    private static void loadAntiBuilderBlacklist() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        builder.addAll(IMCHandler.getBlacklistedBlocks());
        for (String s : antibuilderBlacklist) {
            Block block;
            String[] data = s.split(":");
            if (data.length < 2 || (block = (Block)Block.field_149771_c.func_82594_a((Object)new ResourceLocation(data[0], data[1]))) == Blocks.field_150350_a) continue;
            int meta = 0;
            if (data.length >= 3) {
                try {
                    meta = Integer.parseInt(data[2]);
                }
                catch (NumberFormatException e) {
                    TwilightForestMod.LOGGER.warn("Had a slight hiccup processing \"" + s + "\" as part of the antibuilder blacklist.");
                    meta = 0;
                }
            }
            builder.add((Object)block.func_176203_a(meta));
        }
        disallowBreakingBlockList = builder.build();
    }

    public static ImmutableSet<IBlockState> getDisallowedBlocks() {
        if (disallowBreakingBlockList == null || disallowBreakingBlockList.isEmpty()) {
            TFConfig.loadAntiBuilderBlacklist();
        }
        return disallowBreakingBlockList;
    }

    public static class LoadingScreen {
        @Config.LangKey(value="twilightforest.config.loading_icon_enable")
        @Config.Comment(value={"Wobble the Loading icon. Has no performance impact at all. For those who don't like fun."})
        public boolean enable = true;
        @Config.LangKey(value="twilightforest.config.loading_screen_swap_frequency")
        @Config.RangeInt(min=0)
        @Config.Comment(value={"How many ticks between each loading screen change. Set to 0 to not cycle at all."})
        public int cycleLoadingScreenFrequency = 0;
        @Config.LangKey(value="twilightforest.config.loading_icon_wobble_bounce_frequency")
        @Config.RangeDouble(min=0.0)
        @Config.Comment(value={"Frequency of wobble and bounce."})
        public float frequency = 5.0f;
        @Config.LangKey(value="twilightforest.config.loading_icon_scale")
        @Config.RangeDouble(min=0.0)
        @Config.Comment(value={"Scale of whole bouncy loading icon."})
        public float scale = 3.0f;
        @Config.LangKey(value="twilightforest.config.loading_icon_bounciness")
        @Config.RangeDouble(min=0.0)
        @Config.Comment(value={"How much the loading icon bounces."})
        public float scaleDeviation = 5.25f;
        @Config.LangKey(value="twilightforest.config.loading_icon_tilting")
        @Config.RangeDouble(min=0.0, max=360.0)
        @Config.Comment(value={"How far the loading icon wobbles."})
        public float tiltRange = 11.25f;
        @Config.LangKey(value="twilightforest.config.loading_icon_tilt_pushback")
        @Config.RangeDouble(min=0.0, max=360.0)
        @Config.Comment(value={"Pushback value to re-center the wobble of loading icon."})
        public float tiltConstant = 22.5f;
        @Config.LangKey(value="twilightforest.config.loading_icon_stacks")
        @Config.Comment(value={"List of items to be used for the wobbling Loading Icon. (domain:item:meta) meta is optional."})
        public String[] loadingIconStacks = new String[]{"twilightforest:experiment_115", "twilightforest:magic_map", "twilightforest:charm_of_life_2", "twilightforest:charm_of_keeping_3", "twilightforest:phantom_helmet", "twilightforest:lamp_of_cinders", "twilightforest:carminite", "twilightforest:block_and_chain", "twilightforest:yeti_helmet", "twilightforest:hydra_chop", "twilightforest:magic_beans", "twilightforest:ironwood_raw", "twilightforest:naga_scale", "twilightforest:experiment_115:2", "twilightforest:miniature_structure", "twilightforest:miniature_structure:6", "twilightforest:knightmetal_block", "twilightforest:tower_device:10", "twilightforest:twilight_sapling:5", "twilightforest:twilight_sapling:6", "twilightforest:twilight_sapling:7", "twilightforest:twilight_sapling:8", "twilightforest:twilight_sapling:9", "twilightforest:borer_essence"};
        @Config.Ignore
        private List<ItemStack> loadingScreenIcons;

        public List<ItemStack> getLoadingScreenIcons() {
            if (this.loadingScreenIcons == null || this.loadingScreenIcons.isEmpty()) {
                this.loadLoadingScreenIcons();
            }
            return this.loadingScreenIcons;
        }

        void loadLoadingScreenIcons() {
            ImmutableList.Builder iconList = ImmutableList.builder();
            iconList.addAll(IMCHandler.getLoadingIconStacks());
            for (String s : this.loadingIconStacks) {
                int meta;
                String[] data = s.split(":");
                Item item = (Item)Item.field_150901_e.func_82594_a((Object)new ResourceLocation(data[0], data[1]));
                if (item == null) continue;
                try {
                    meta = Integer.parseInt(data[2]);
                }
                catch (Exception e) {
                    meta = 0;
                }
                iconList.add((Object)new ItemStack(item, 1, meta));
            }
            this.loadingScreenIcons = iconList.build();
        }
    }

    public static class ShieldInteractions {
        @Config.LangKey(value="twilightforest.config.parry_non_twilight")
        public boolean parryNonTwilightAttacks = false;
        @Config.LangKey(value="twilightforest.config.parry_window_arrow")
        @Config.RangeInt(min=0)
        public int shieldParryTicksArrow = 40;
        @Config.LangKey(value="twilightforest.config.parry_window_fireball")
        @Config.RangeInt(min=0)
        public int shieldParryTicksFireball = 40;
        @Config.LangKey(value="twilightforest.config.parry_window_throwable")
        @Config.RangeInt(min=0)
        public int shieldParryTicksThrowable = 40;
        @Config.LangKey(value="twilightforest.config.parry_window_beam")
        @Config.RangeInt(min=0)
        public int shieldParryTicksBeam = 10;
    }

    public static class Performance {
        @Config.LangKey(value="twilightforest.config.canopy_coverage")
        @Config.RangeDouble(min=0.0)
        @Config.Comment(value={"Amount of canopy coverage. Lower numbers improve chunk generation speed at the cost of a thinner forest."})
        public float canopyCoverage = 1.7f;
        @Config.LangKey(value="twilightforest.config.twilight_oaks")
        @Config.RangeInt(min=1)
        @Config.Comment(value={"Chance that a chunk in the Twilight Forest will contain a twilight oak tree. Higher numbers reduce the number of trees, increasing performance."})
        public int twilightOakChance = 48;
        @Config.LangKey(value="twilightforest.config.leaves_light_opacity")
        @Config.RangeInt(min=0, max=255)
        @Config.Comment(value={"This controls the opacity of leaves, changing the amount of light blocked. Can be used to decrease complexity in some lighting checks."})
        public int leavesLightOpacity = 1;
        @Config.LangKey(value="twilightforest.config.glacer_packed_ice")
        @Config.Comment(value={"Setting this true will make Twilight Glaciers generate with Packed Ice instead of regular translucent Ice, decreasing amount of light checking calculations."})
        public boolean glacierPackedIce = false;
        @Config.Ignore
        public boolean shadersSupported = true;
    }

    public static class Dimension {
        @Config.LangKey(value="twilightforest.config.dimension_id")
        @Config.RequiresMcRestart
        @Config.Comment(value={"What ID number to assign to the Twilight Forest dimension. Change if you are having conflicts with another mod."})
        public int dimensionID = 7;
        @Config.LangKey(value="twilightforest.config.dimension_seed")
        @Config.RequiresWorldRestart
        @Config.Comment(value={"If set, this will override the normal world seed when generating parts of the Twilight Forest Dimension."})
        public String twilightForestSeed = "";
        @Config.LangKey(value="twilightforest.config.spawn_in_tf")
        @Config.Comment(value={"If true, players spawning for the first time will spawn in the Twilight Forest."})
        public boolean newPlayersSpawnInTF = false;
        @Config.LangKey(value="twilightforest.config.skylight_forest")
        @Config.RequiresWorldRestart
        @Config.Comment(value={"If true, Twilight Forest will generate as a void except for Major Structures"})
        public boolean skylightForest = false;
    }
}

