/*
 * Decompiled with CFR 0.152.
 */
package twilightforest;

import net.minecraft.command.ICommand;
import net.minecraft.item.EnumRarity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.DimensionType;
import net.minecraft.world.gen.structure.MapGenStructureIO;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.util.EnumHelper;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLInterModComms;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.registry.GameRegistry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import twilightforest.CommandTF;
import twilightforest.IMCHandler;
import twilightforest.TFCommonProxy;
import twilightforest.TFConfig;
import twilightforest.TFDataFixers;
import twilightforest.TFFeature;
import twilightforest.advancements.TFAdvancements;
import twilightforest.capabilities.CapabilityList;
import twilightforest.compat.TFCompat;
import twilightforest.item.TFItems;
import twilightforest.loot.TFTreasure;
import twilightforest.network.TFPacketHandler;
import twilightforest.structures.hollowtree.TFHollowTreePieces;
import twilightforest.structures.start.StructureStartNothing;
import twilightforest.tileentity.TileEntityTFAlphaYetiSpawner;
import twilightforest.tileentity.TileEntityTFAntibuilder;
import twilightforest.tileentity.TileEntityTFCReactorActive;
import twilightforest.tileentity.TileEntityTFCinderFurnace;
import twilightforest.tileentity.TileEntityTFFlameJet;
import twilightforest.tileentity.TileEntityTFGhastTrapActive;
import twilightforest.tileentity.TileEntityTFGhastTrapInactive;
import twilightforest.tileentity.TileEntityTFHydraSpawner;
import twilightforest.tileentity.TileEntityTFKnightPhantomsSpawner;
import twilightforest.tileentity.TileEntityTFLichSpawner;
import twilightforest.tileentity.TileEntityTFMinoshroomSpawner;
import twilightforest.tileentity.TileEntityTFNagaSpawner;
import twilightforest.tileentity.TileEntityTFPoppingJet;
import twilightforest.tileentity.TileEntityTFSmoker;
import twilightforest.tileentity.TileEntityTFSnowQueenSpawner;
import twilightforest.tileentity.TileEntityTFTowerBossSpawner;
import twilightforest.tileentity.TileEntityTFTowerBuilder;
import twilightforest.tileentity.TileEntityTFTrophy;
import twilightforest.world.WorldProviderTwilightForest;

@Mod(modid="twilightforest", name="The Twilight Forest", version="3.8.689", acceptedMinecraftVersions="[1.12.2]", dependencies="after:ctm@[MC1.12.2-0.3.2.18,);before:immersiveengineering@[0.12-83,);before:tconstruct;required-after:forge@[14.23.3.2655,);after:thaumcraft@[6.1.BETA21,)", updateJSON="https://raw.githubusercontent.com/TeamTwilight/twilightforest/1.12.x/update.json")
public class TwilightForestMod {
    public static final String ID = "twilightforest";
    public static final String VERSION = "3.8.689";
    public static final String MODEL_DIR = "twilightforest:textures/model/";
    public static final String GUI_DIR = "twilightforest:textures/gui/";
    public static final String ENVIRO_DIR = "twilightforest:textures/environment/";
    public static final String ARMOR_DIR = "twilightforest:textures/armor/";
    public static final String ENFORCED_PROGRESSION_RULE = "tfEnforcedProgression";
    public static final int GUI_ID_UNCRAFTING = 1;
    public static final int GUI_ID_FURNACE = 2;
    public static DimensionType dimType;
    public static int backupdimensionID;
    public static final Logger LOGGER;
    private static final EnumRarity rarity;
    private static boolean compat;
    @Mod.Instance(value="twilightforest")
    public static TwilightForestMod instance;
    @SidedProxy(clientSide="twilightforest.client.TFClientProxy", serverSide="twilightforest.TFCommonProxy")
    public static TFCommonProxy proxy;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        if (Loader.isModLoaded((String)"sponge")) {
            LOGGER.info("It looks like you have Sponge installed! You may notice Hydras spawning incorrectly with floating heads.\nIf so, please update Sponge to resolve this issue. Have fun!");
        }
        this.registerTileEntities();
        dimType = DimensionType.register((String)"twilight_forest", (String)"_twilightforest", (int)TFConfig.dimension.dimensionID, WorldProviderTwilightForest.class, (boolean)false);
        proxy.preInit();
        CapabilityList.registerCapabilities();
        TFTreasure.init();
        LOGGER.debug("There are " + TFFeature.values().length + " entries in TTFeature enum. Maximum structure size is " + TFFeature.getMaxSize());
        MapGenStructureIO.func_143034_b(StructureStartNothing.class, (String)"TFNothing");
        TFHollowTreePieces.registerPieces();
        compat = TFConfig.doCompat;
        if (compat) {
            try {
                TFCompat.preInitCompat();
            }
            catch (Exception e) {
                compat = false;
                LOGGER.error("twilightforest had an error loading preInit compatibility!");
                LOGGER.catching(e.fillInStackTrace());
            }
        } else {
            LOGGER.warn("twilightforest is skipping! compatibility!");
        }
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent evt) {
        TFItems.initRepairMaterials();
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)instance, (IGuiHandler)proxy);
        TFPacketHandler.init();
        proxy.init();
        TFAdvancements.init();
        if (compat) {
            try {
                TFCompat.initCompat();
            }
            catch (Exception e) {
                compat = false;
                LOGGER.error("twilightforest had an error loading init compatibility!");
                LOGGER.catching(e.fillInStackTrace());
            }
        }
        TFDataFixers.init();
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent evt) {
        if (!DimensionManager.isDimensionRegistered((int)TFConfig.dimension.dimensionID)) {
            DimensionManager.registerDimension((int)TFConfig.dimension.dimensionID, (DimensionType)dimType);
        } else {
            LOGGER.warn("Detected that the configured dimension id '{}' is being used. Using backup ID. It is recommended that you configure this mod to use a unique dimension ID.", (Object)TFConfig.dimension.dimensionID);
            DimensionManager.registerDimension((int)backupdimensionID, (DimensionType)dimType);
            TFConfig.dimension.dimensionID = backupdimensionID;
        }
        if (compat) {
            try {
                TFCompat.postInitCompat();
            }
            catch (Exception e) {
                LOGGER.error("twilightforest had an error loading postInit compatibility!");
                LOGGER.catching(e.fillInStackTrace());
            }
        }
    }

    @Mod.EventHandler
    public void onIMC(FMLInterModComms.IMCEvent event) {
        IMCHandler.onIMC(event);
    }

    @Mod.EventHandler
    public void startServer(FMLServerStartingEvent event) {
        event.registerServerCommand((ICommand)new CommandTF());
    }

    private void registerTileEntities() {
        proxy.registerCritterTileEntities();
        GameRegistry.registerTileEntity(TileEntityTFNagaSpawner.class, (ResourceLocation)TwilightForestMod.prefix("naga_spawner"));
        GameRegistry.registerTileEntity(TileEntityTFLichSpawner.class, (ResourceLocation)TwilightForestMod.prefix("lich_spawner"));
        GameRegistry.registerTileEntity(TileEntityTFHydraSpawner.class, (ResourceLocation)TwilightForestMod.prefix("hydra_spawner"));
        GameRegistry.registerTileEntity(TileEntityTFSmoker.class, (ResourceLocation)TwilightForestMod.prefix("smoker"));
        GameRegistry.registerTileEntity(TileEntityTFPoppingJet.class, (ResourceLocation)TwilightForestMod.prefix("popping_jet"));
        GameRegistry.registerTileEntity(TileEntityTFFlameJet.class, (ResourceLocation)TwilightForestMod.prefix("flame_jet"));
        GameRegistry.registerTileEntity(TileEntityTFTowerBuilder.class, (ResourceLocation)TwilightForestMod.prefix("tower_builder"));
        GameRegistry.registerTileEntity(TileEntityTFAntibuilder.class, (ResourceLocation)TwilightForestMod.prefix("tower_reverter"));
        GameRegistry.registerTileEntity(TileEntityTFTrophy.class, (ResourceLocation)TwilightForestMod.prefix("trophy"));
        GameRegistry.registerTileEntity(TileEntityTFTowerBossSpawner.class, (ResourceLocation)TwilightForestMod.prefix("tower_boss_spawner"));
        GameRegistry.registerTileEntity(TileEntityTFGhastTrapInactive.class, (ResourceLocation)TwilightForestMod.prefix("ghast_trap_inactive"));
        GameRegistry.registerTileEntity(TileEntityTFGhastTrapActive.class, (ResourceLocation)TwilightForestMod.prefix("ghast_trap_active"));
        GameRegistry.registerTileEntity(TileEntityTFCReactorActive.class, (ResourceLocation)TwilightForestMod.prefix("carminite_reactor_active"));
        GameRegistry.registerTileEntity(TileEntityTFKnightPhantomsSpawner.class, (ResourceLocation)TwilightForestMod.prefix("knight_phantom_spawner"));
        GameRegistry.registerTileEntity(TileEntityTFSnowQueenSpawner.class, (ResourceLocation)TwilightForestMod.prefix("snow_queen_spawner"));
        GameRegistry.registerTileEntity(TileEntityTFCinderFurnace.class, (ResourceLocation)TwilightForestMod.prefix("cinder_furnace"));
        GameRegistry.registerTileEntity(TileEntityTFMinoshroomSpawner.class, (ResourceLocation)TwilightForestMod.prefix("minoshroom_spawner"));
        GameRegistry.registerTileEntity(TileEntityTFAlphaYetiSpawner.class, (ResourceLocation)TwilightForestMod.prefix("alpha_yeti_spawner"));
    }

    private static ResourceLocation prefix(String name) {
        return new ResourceLocation(ID, name);
    }

    public static EnumRarity getRarity() {
        return rarity != null ? rarity : EnumRarity.EPIC;
    }

    static {
        backupdimensionID = -777;
        LOGGER = LogManager.getLogger((String)ID);
        rarity = EnumHelper.addRarity((String)"TWILIGHT", (TextFormatting)TextFormatting.DARK_GREEN, (String)"Twilight");
        compat = true;
    }
}

