/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.block;

import java.util.List;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFence;
import net.minecraft.block.BlockRotatedPillar;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import twilightforest.TwilightForestMod;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public abstract class BlockTFConnectableRotatedPillar
extends BlockRotatedPillar {
    protected final int boundingBoxLower;
    protected final int boundingBoxUpper;

    BlockTFConnectableRotatedPillar(Material materialIn, int boundingBoxLower, int boundingBoxUpper) {
        super(materialIn);
        this.boundingBoxLower = boundingBoxLower;
        this.boundingBoxUpper = boundingBoxUpper;
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)field_176298_M, (Comparable)EnumFacing.Axis.Y).func_177226_a((IProperty)BlockFence.field_176526_a, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)BlockFence.field_176528_N, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)BlockFence.field_176527_M, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)BlockFence.field_176525_b, (Comparable)Boolean.valueOf(false)));
    }

    protected abstract IProperty[] getAdditionalProperties();

    private IProperty[] getPropertiesForInit(IProperty ... additionalProperties) {
        IProperty[] propertiesWithSiding = new IProperty[additionalProperties.length + 5];
        IProperty[] booleanSides = new IProperty[]{BlockFence.field_176526_a, BlockFence.field_176525_b, BlockFence.field_176527_M, BlockFence.field_176528_N};
        propertiesWithSiding[0] = field_176298_M;
        System.arraycopy(booleanSides, 0, propertiesWithSiding, 1, booleanSides.length);
        System.arraycopy(additionalProperties, 0, propertiesWithSiding, booleanSides.length + 1, additionalProperties.length);
        return propertiesWithSiding;
    }

    public BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, this.getPropertiesForInit(this.getAdditionalProperties()));
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        EnumFacing.Axis axis = (EnumFacing.Axis)state.func_177229_b((IProperty)field_176298_M);
        for (PairHelper pair : PairHelper.values()) {
            EnumFacing connectTo = PairHelper.getFacingFromPropertyWithAxis(pair.property, axis);
            state = state.func_177226_a((IProperty)pair.property, (Comparable)Boolean.valueOf(this.canConnectTo(state, world.func_180495_p(pos.func_177972_a(connectTo)), world, pos, connectTo)));
        }
        return state;
    }

    protected boolean canConnectTo(IBlockState state, IBlockState otherState, IBlockAccess world, BlockPos pos, EnumFacing connectTo) {
        return state.func_177230_c() == otherState.func_177230_c() && state.func_177229_b((IProperty)field_176298_M) != connectTo.func_176740_k();
    }

    public void func_185477_a(IBlockState state, World world, BlockPos pos, AxisAlignedBB aabb, List<AxisAlignedBB> list, @Nullable Entity entity, boolean useActualState) {
        EnumFacing.Axis axis;
        if (!useActualState) {
            state = this.func_176221_a(state, (IBlockAccess)world, pos);
        }
        BlockTFConnectableRotatedPillar.func_185492_a((BlockPos)pos, (AxisAlignedBB)aabb, list, (AxisAlignedBB)this.makeQuickAABB((axis = (EnumFacing.Axis)state.func_177229_b((IProperty)field_176298_M)) == EnumFacing.Axis.X ? 16 : this.boundingBoxLower, axis == EnumFacing.Axis.Y ? 16 : this.boundingBoxLower, axis == EnumFacing.Axis.Z ? 16 : this.boundingBoxLower, axis == EnumFacing.Axis.X ? 0 : this.boundingBoxUpper, axis == EnumFacing.Axis.Y ? 0 : this.boundingBoxUpper, axis == EnumFacing.Axis.Z ? 0 : this.boundingBoxUpper));
        for (EnumFacing facing : EnumFacing.field_82609_l) {
            if (facing.func_176740_k() == axis || !((Boolean)state.func_177229_b((IProperty)PairHelper.getPropertyFromFacingWithAxis(facing, axis))).booleanValue()) continue;
            BlockTFConnectableRotatedPillar.func_185492_a((BlockPos)pos, (AxisAlignedBB)aabb, list, (AxisAlignedBB)this.getSidedAABBStraight(facing, axis));
        }
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        state = this.func_176221_a(state, world, pos);
        switch ((EnumFacing.Axis)state.func_177229_b((IProperty)field_176298_M)) {
            case X: {
                return this.makeQuickAABB(0, (Boolean)state.func_177229_b((IProperty)BlockFence.field_176526_a) != false ? 0 : this.boundingBoxLower, (Boolean)state.func_177229_b((IProperty)BlockFence.field_176528_N) != false ? 0 : this.boundingBoxLower, 16, (Boolean)state.func_177229_b((IProperty)BlockFence.field_176527_M) != false ? 16 : this.boundingBoxUpper, (Boolean)state.func_177229_b((IProperty)BlockFence.field_176525_b) != false ? 16 : this.boundingBoxUpper);
            }
            case Z: {
                return this.makeQuickAABB((Boolean)state.func_177229_b((IProperty)BlockFence.field_176525_b) != false ? 0 : this.boundingBoxLower, (Boolean)state.func_177229_b((IProperty)BlockFence.field_176527_M) != false ? 0 : this.boundingBoxLower, 0, (Boolean)state.func_177229_b((IProperty)BlockFence.field_176528_N) != false ? 16 : this.boundingBoxUpper, (Boolean)state.func_177229_b((IProperty)BlockFence.field_176526_a) != false ? 16 : this.boundingBoxUpper, 16);
            }
        }
        return this.makeQuickAABB((Boolean)state.func_177229_b((IProperty)BlockFence.field_176528_N) != false ? 0 : this.boundingBoxLower, 0, (Boolean)state.func_177229_b((IProperty)BlockFence.field_176526_a) != false ? 0 : this.boundingBoxLower, (Boolean)state.func_177229_b((IProperty)BlockFence.field_176525_b) != false ? 16 : this.boundingBoxUpper, 16, (Boolean)state.func_177229_b((IProperty)BlockFence.field_176527_M) != false ? 16 : this.boundingBoxUpper);
    }

    protected AxisAlignedBB getSidedAABBStraight(EnumFacing facing, EnumFacing.Axis axis) {
        return this.makeQuickAABB(facing == EnumFacing.EAST ? 16 : this.boundingBoxLower, facing == EnumFacing.UP ? 16 : this.boundingBoxLower, facing == EnumFacing.SOUTH ? 16 : this.boundingBoxLower, facing == EnumFacing.WEST ? 0 : this.boundingBoxUpper, facing == EnumFacing.DOWN ? 0 : this.boundingBoxUpper, facing == EnumFacing.NORTH ? 0 : this.boundingBoxUpper);
    }

    protected AxisAlignedBB makeQuickAABB(int x1, int y1, int z1, int x2, int y2, int z2) {
        return new AxisAlignedBB((double)x1 / 16.0, (double)y1 / 16.0, (double)z1 / 16.0, (double)x2 / 16.0, (double)y2 / 16.0, (double)z2 / 16.0);
    }

    static enum PairHelper {
        NORTH(EnumFacing.NORTH, BlockFence.field_176526_a),
        EAST(EnumFacing.EAST, BlockFence.field_176525_b),
        SOUTH(EnumFacing.SOUTH, BlockFence.field_176527_M),
        WEST(EnumFacing.WEST, BlockFence.field_176528_N);

        final EnumFacing facing;
        final PropertyBool property;

        private PairHelper(EnumFacing facing, PropertyBool property) {
            this.facing = facing;
            this.property = property;
        }

        static EnumFacing getFacingFromPropertyWithAxis(PropertyBool property, EnumFacing.Axis axis) {
            switch (axis) {
                case X: {
                    if (property == BlockFence.field_176526_a) {
                        return EnumFacing.DOWN;
                    }
                    if (property == BlockFence.field_176527_M) {
                        return EnumFacing.UP;
                    }
                    if (property == BlockFence.field_176528_N) {
                        return EnumFacing.NORTH;
                    }
                    if (property == BlockFence.field_176525_b) {
                        return EnumFacing.SOUTH;
                    }
                }
                case Z: {
                    if (property == BlockFence.field_176526_a) {
                        return EnumFacing.UP;
                    }
                    if (property == BlockFence.field_176527_M) {
                        return EnumFacing.DOWN;
                    }
                    if (property == BlockFence.field_176528_N) {
                        return EnumFacing.EAST;
                    }
                    if (property != BlockFence.field_176525_b) break;
                    return EnumFacing.WEST;
                }
            }
            if (property == BlockFence.field_176526_a) {
                return EnumFacing.NORTH;
            }
            if (property == BlockFence.field_176527_M) {
                return EnumFacing.SOUTH;
            }
            if (property == BlockFence.field_176528_N) {
                return EnumFacing.WEST;
            }
            if (property == BlockFence.field_176525_b) {
                return EnumFacing.EAST;
            }
            return EnumFacing.UP;
        }

        static PropertyBool getPropertyFromFacingWithAxis(EnumFacing facing, EnumFacing.Axis axis) {
            switch (axis) {
                case X: {
                    if (facing == EnumFacing.DOWN) {
                        return BlockFence.field_176526_a;
                    }
                    if (facing == EnumFacing.UP) {
                        return BlockFence.field_176527_M;
                    }
                    if (facing == EnumFacing.NORTH) {
                        return BlockFence.field_176528_N;
                    }
                    if (facing != EnumFacing.SOUTH) break;
                    return BlockFence.field_176525_b;
                }
                case Z: {
                    if (facing == EnumFacing.UP) {
                        return BlockFence.field_176526_a;
                    }
                    if (facing == EnumFacing.DOWN) {
                        return BlockFence.field_176527_M;
                    }
                    if (facing == EnumFacing.EAST) {
                        return BlockFence.field_176528_N;
                    }
                    if (facing != EnumFacing.WEST) break;
                    return BlockFence.field_176525_b;
                }
                case Y: {
                    if (facing == EnumFacing.NORTH) {
                        return BlockFence.field_176526_a;
                    }
                    if (facing == EnumFacing.SOUTH) {
                        return BlockFence.field_176527_M;
                    }
                    if (facing == EnumFacing.WEST) {
                        return BlockFence.field_176528_N;
                    }
                    if (facing != EnumFacing.EAST) break;
                    return BlockFence.field_176525_b;
                }
            }
            TwilightForestMod.LOGGER.info("ConnectableRotatedPillar helper had a problem? " + facing.func_176610_l() + " with " + axis.func_176610_l());
            return BlockFence.field_176526_a;
        }
    }
}

