/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.charset.lib;

import java.util.IdentityHashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.capabilities.Capability;
import pl.asie.charset.api.CharsetAPI;
import pl.asie.charset.api.audio.AudioAPI;
import pl.asie.charset.api.audio.AudioData;
import pl.asie.charset.api.audio.AudioSink;
import pl.asie.charset.api.lib.IBlockCapabilityProvider;
import pl.asie.charset.api.lib.ISimpleInstantiatingRegistry;
import pl.asie.charset.lib.capability.CapabilityHelper;
import pl.asie.charset.lib.utils.CharsetSimpleInstantiatingRegistry;

public final class CharsetImplAPI
extends CharsetAPI {
    private final Map<Class, ISimpleInstantiatingRegistry> registryMap = new IdentityHashMap<Class, ISimpleInstantiatingRegistry>();

    @Override
    public boolean isPresent() {
        return true;
    }

    @Override
    public <T> boolean mayHaveBlockCapability(Capability<T> capability, IBlockState state) {
        return CapabilityHelper.hasBlockCapability(capability, state);
    }

    @Override
    @Nullable
    public <T> T getBlockCapability(Capability<T> capability, IBlockAccess world, BlockPos pos, IBlockState state, EnumFacing facing) {
        return CapabilityHelper.getBlockCapability(world, pos, state, facing, capability);
    }

    @Override
    public <T> void registerBlockCapabilityProvider(Capability<T> capability, Block block, IBlockCapabilityProvider<T> provider) {
        CapabilityHelper.registerBlockProvider(capability, block, provider);
    }

    @Override
    @Nullable
    public <T> ISimpleInstantiatingRegistry<T> findSimpleInstantiatingRegistry(Class<T> c) {
        if (c == AudioData.class) {
            return AudioAPI.DATA_REGISTRY;
        }
        if (c == AudioSink.class) {
            return AudioAPI.SINK_REGISTRY;
        }
        return this.registryMap.computeIfAbsent(c, cc -> new CharsetSimpleInstantiatingRegistry());
    }
}

