/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.charset.lib.command;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Lists;
import com.google.common.collect.Table;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.function.BiFunction;
import javax.annotation.Nullable;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItemFrame;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.oredict.OreDictionary;
import pl.asie.charset.lib.CharsetLib;
import pl.asie.charset.lib.command.CommandCharset;
import pl.asie.charset.lib.command.SubCommand;
import pl.asie.charset.lib.material.ItemMaterial;
import pl.asie.charset.lib.material.ItemMaterialRegistry;
import pl.asie.charset.lib.utils.MethodHandleHelper;
import pl.asie.charset.lib.utils.MultipartUtils;
import pl.asie.charset.lib.utils.RayTraceUtils;

public class SubCommandAt
extends SubCommand {
    private static final String END_KEY = "[[END]]";
    private final Table<Class, String, BiFunction<Context, Object, Object>> transformationTable = HashBasedTable.create();

    private static Object printClasses(Context ctx, Object o) {
        ctx.sender.func_145747_a((ITextComponent)new TextComponentString("Classes:"));
        for (Class cl : MethodHandleHelper.classes(o.getClass())) {
            String name = cl.getName();
            if (cl.isInterface()) {
                name = TextFormatting.AQUA + name;
            }
            ctx.sender.func_145747_a((ITextComponent)new TextComponentString("- " + name));
        }
        return null;
    }

    public SubCommandAt() {
        super("at", Side.SERVER);
        this.transformationTable.put(Dummy.class, (Object)"hand", (ctx, a) -> {
            Entity e = ((Context)ctx).sender.func_174793_f();
            if (e instanceof EntityLivingBase) {
                ItemStack stack = ((EntityLivingBase)e).func_184614_ca();
                if (stack.func_190926_b()) {
                    ((Context)ctx).sender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.RED + "Empty hand!"));
                    return null;
                }
                return stack;
            }
            ((Context)ctx).sender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.RED + "Not a valid hand holder!"));
            return null;
        });
        this.transformationTable.put(Dummy.class, (Object)"block", (ctx, a) -> {
            Entity e = ((Context)ctx).sender.func_174793_f();
            if (e instanceof EntityLivingBase) {
                RayTraceResult result = e.func_130014_f_().func_72901_a(RayTraceUtils.getStart((EntityLivingBase)e), RayTraceUtils.getEnd((EntityLivingBase)e), false);
                if (result.field_72313_a == RayTraceResult.Type.BLOCK) {
                    return result.func_178782_a();
                }
            }
            ((Context)ctx).sender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.RED + "No block found!"));
            return null;
        });
        this.transformationTable.put(Dummy.class, (Object)"part", (ctx, a) -> {
            Entity e = ((Context)ctx).sender.func_174793_f();
            if (e instanceof EntityLivingBase) {
                RayTraceResult result = e.func_130014_f_().func_72901_a(RayTraceUtils.getStart((EntityLivingBase)e), RayTraceUtils.getEnd((EntityLivingBase)e), false);
                if (result.field_72313_a == RayTraceResult.Type.BLOCK) {
                    MultipartUtils.ExtendedRayTraceResult trueResult = MultipartUtils.INSTANCE.getTrueResult(result);
                    return trueResult.getTile((IBlockAccess)((Context)ctx).sender.func_130014_f_());
                }
            }
            ((Context)ctx).sender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.RED + "No tile found!"));
            return null;
        });
        this.transformationTable.put(Dummy.class, (Object)"self", (ctx, a) -> {
            Entity e = ((Context)ctx).sender.func_174793_f();
            if (e instanceof EntityLivingBase) {
                return e;
            }
            ((Context)ctx).sender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.RED + "No self entity found!"));
            return null;
        });
        this.transformationTable.put(ItemStack.class, (Object)"material", (ctx, a) -> {
            ItemStack stack = (ItemStack)a;
            ItemMaterial material = ItemMaterialRegistry.INSTANCE.getMaterialIfPresent(stack);
            if (material == null) {
                ((Context)ctx).sender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.RED + "Not a material!"));
            } else {
                ((Context)ctx).sender.func_145747_a((ITextComponent)new TextComponentString("Material ID: " + TextFormatting.GREEN + material.getId()));
                ((Context)ctx).sender.func_145747_a((ITextComponent)new TextComponentString("Material types: [" + CommandCharset.COMMAS.join(material.getTypes()) + "]"));
                for (Map.Entry<String, ItemMaterial> entry : material.getRelations().entrySet()) {
                    ((Context)ctx).sender.func_145747_a((ITextComponent)new TextComponentString("-> " + entry.getKey() + ": " + entry.getValue().getId()));
                }
            }
            return null;
        });
        this.transformationTable.put(ItemStack.class, (Object)"ore", (ctx, a) -> {
            ItemStack stack = (ItemStack)a;
            ArrayList<String> names = new ArrayList<String>();
            for (int id : OreDictionary.getOreIDs((ItemStack)stack)) {
                String name = OreDictionary.getOreName((int)id);
                names.add(name);
            }
            ((Context)ctx).sender.func_145747_a((ITextComponent)new TextComponentString("Ores: [" + CommandCharset.COMMAS.join(names) + "]"));
            return null;
        });
        this.transformationTable.put(BlockPos.class, (Object)"tile", (ctx, a) -> {
            BlockPos pos = (BlockPos)a;
            return ((Context)ctx).sender.func_130014_f_().func_175625_s(pos);
        });
        this.transformationTable.put(ItemStack.class, (Object)"tag", (ctx, a) -> ((ItemStack)a).func_77942_o() ? ((ItemStack)a).func_77978_p() : new NBTTagCompound());
        this.transformationTable.put(Entity.class, (Object)"tag", (ctx, a) -> {
            NBTTagCompound tag = new NBTTagCompound();
            ((Entity)a).func_189511_e(tag);
            return tag;
        });
        this.transformationTable.put(TileEntity.class, (Object)"tag", (ctx, a) -> {
            NBTTagCompound tag = new NBTTagCompound();
            ((TileEntity)a).func_189515_b(tag);
            return tag;
        });
        this.transformationTable.put(NBTBase.class, (Object)END_KEY, (ctx, a) -> {
            ((Context)ctx).sender.func_145747_a((ITextComponent)new TextComponentString("Tag: " + a));
            return null;
        });
        this.transformationTable.put(BlockPos.class, (Object)END_KEY, (ctx, a) -> {
            BlockPos pos = (BlockPos)a;
            IBlockState state = ((Context)ctx).sender.func_130014_f_().func_180495_p(pos);
            ((Context)ctx).sender.func_145747_a((ITextComponent)new TextComponentString("Block at " + pos + ": " + state.func_177230_c().getRegistryName()));
            for (IProperty property : state.func_177227_a()) {
                ((Context)ctx).sender.func_145747_a((ITextComponent)new TextComponentString("- " + property.func_177701_a() + " = " + state.func_177229_b(property)));
            }
            return null;
        });
        this.transformationTable.put(TileEntity.class, (Object)END_KEY, (ctx, a) -> {
            TileEntity tile = (TileEntity)a;
            ((Context)ctx).sender.func_145747_a((ITextComponent)new TextComponentString("Tile at " + tile.func_174877_v() + ": " + TileEntity.func_190559_a(tile.getClass())));
            return null;
        });
        this.transformationTable.put(Entity.class, (Object)END_KEY, (ctx, a) -> {
            Entity entity = (Entity)a;
            ((Context)ctx).sender.func_145747_a((ITextComponent)new TextComponentString("Entity at " + entity.func_174791_d() + ": " + entity.func_70005_c_()));
            return null;
        });
        this.transformationTable.put(Entity.class, (Object)"item", (ctx, a) -> {
            Entity entity = (Entity)a;
            if (entity instanceof EntityItemFrame) {
                return ((EntityItemFrame)entity).func_82335_i();
            }
            ((Context)ctx).sender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.RED + "No item found!"));
            return null;
        });
        this.transformationTable.put(ItemStack.class, (Object)END_KEY, (ctx, a) -> {
            ItemStack stack = (ItemStack)a;
            ((Context)ctx).sender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.YELLOW + stack.toString() + " " + TextFormatting.GRAY + "(" + stack.func_77973_b().getRegistryName() + ")"));
            ((Context)ctx).sender.func_145747_a((ITextComponent)new TextComponentString("- max stack size = " + stack.func_77976_d()));
            if (stack.func_77984_f()) {
                ((Context)ctx).sender.func_145747_a((ITextComponent)new TextComponentString("- max damage = " + stack.func_77958_k()));
            }
            return null;
        });
        if (CharsetLib.showHandClasses) {
            this.transformationTable.put(ItemStack.class, (Object)"class", (ctx, a) -> SubCommandAt.printClasses(ctx, ((ItemStack)a).func_77973_b()));
            this.transformationTable.put(BlockPos.class, (Object)"class", (ctx, a) -> SubCommandAt.printClasses(ctx, ((Context)ctx).sender.func_130014_f_().func_180495_p((BlockPos)a).func_177230_c()));
            this.transformationTable.put(Entity.class, (Object)"class", SubCommandAt::printClasses);
            this.transformationTable.put(TileEntity.class, (Object)"class", SubCommandAt::printClasses);
        }
    }

    @Override
    public String getUsage() {
        return "Report information about the object being pointed at.";
    }

    @Override
    public List<String> getTabCompletions(MinecraftServer server, ICommandSender sender, String[] args) {
        Context context = new Context(server, sender, args);
        Dummy o = Dummy.INSTANCE;
        while (o != null && context.pos < args.length - 1) {
            boolean found = false;
            String s = context.pop();
            for (Class cl : MethodHandleHelper.classes(o.getClass())) {
                BiFunction func = (BiFunction)this.transformationTable.get((Object)cl, (Object)s);
                if (func == null) continue;
                o = func.apply(context, o);
                found = true;
                break;
            }
            if (found) continue;
            return Collections.emptyList();
        }
        if (o == null) {
            return Collections.emptyList();
        }
        String prefix = args[args.length - 1].toLowerCase();
        TreeSet<String> strs = new TreeSet<String>();
        for (Class cl : MethodHandleHelper.classes(o.getClass())) {
            for (String s : this.transformationTable.row((Object)cl).keySet()) {
                if (s.equals(END_KEY) || !s.toLowerCase().startsWith(prefix)) continue;
                strs.add(s);
            }
        }
        return Lists.newArrayList(strs);
    }

    @Override
    public void execute(MinecraftServer server, ICommandSender sender, String[] args) {
        Context context = new Context(server, sender, args);
        Dummy o = Dummy.INSTANCE;
        while (o != null) {
            boolean found = false;
            String s = context.pop();
            for (Class cl : MethodHandleHelper.classes(o.getClass())) {
                BiFunction func = (BiFunction)this.transformationTable.get((Object)cl, (Object)s);
                if (func == null) continue;
                o = func.apply(context, o);
                found = true;
                break;
            }
            if (found) continue;
            sender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.RED + "Invalid command!"));
            return;
        }
    }

    private static class Context {
        private final MinecraftServer server;
        private final ICommandSender sender;
        private final String[] args;
        private int pos;

        public Context(MinecraftServer server, ICommandSender sender, String[] args) {
            this.server = server;
            this.sender = sender;
            this.args = args;
            this.pos = 0;
        }

        @Nullable
        public String pop() {
            return this.pos >= this.args.length ? SubCommandAt.END_KEY : this.args[this.pos++];
        }
    }

    private static class Dummy {
        static final Dummy INSTANCE = new Dummy();

        private Dummy() {
        }
    }
}

