/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.charset.lib.utils;

import java.lang.invoke.MethodHandle;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import pl.asie.charset.ModCharset;
import pl.asie.charset.lib.utils.MethodHandleHelper;

public final class RecipeUtils {
    private static final MethodHandle EVENT_HANDLER_GETTER = MethodHandleHelper.findFieldGetter(InventoryCrafting.class, "eventHandler", "field_70465_c");

    private RecipeUtils() {
    }

    public static Container getContainer(InventoryCrafting crafting) {
        try {
            return EVENT_HANDLER_GETTER.invokeExact(crafting);
        }
        catch (Throwable t) {
            t.printStackTrace();
            ModCharset.logger.warn("RecipeUtils.getContainer crashed! Stability/functionality may no longer be promised.");
            return RecipeUtils.defaultContainer();
        }
    }

    public static Container defaultContainer() {
        return new Container(){

            public boolean func_75145_c(EntityPlayer playerIn) {
                return false;
            }
        };
    }

    public static Container defaultContainer(final EntityPlayer player) {
        return new Container(){

            public boolean func_75145_c(EntityPlayer playerIn) {
                return playerIn == player;
            }
        };
    }

    public static InventoryCrafting getCraftingInventory(int width, int height) {
        return RecipeUtils.getCraftingInventory(width, height, RecipeUtils.defaultContainer());
    }

    public static InventoryCrafting getCraftingInventory(int width, int height, ItemStack ... stacks) {
        return RecipeUtils.getCraftingInventory(width, height, RecipeUtils.defaultContainer(), stacks);
    }

    public static InventoryCrafting getCraftingInventory(int width, int height, Container container) {
        return new InventoryCrafting(container, width, height);
    }

    public static InventoryCrafting getCraftingInventory(int width, int height, Container container, ItemStack ... stacks) {
        InventoryCrafting crafting = RecipeUtils.getCraftingInventory(width, height, container);
        for (int i = 0; i < Math.min(width * height, stacks.length); ++i) {
            crafting.func_70299_a(i, stacks[i] == null || stacks[i].func_190926_b() ? ItemStack.field_190927_a : stacks[i].func_77946_l());
        }
        return crafting;
    }
}

