/*
 * Decompiled with CFR 0.152.
 */
package info.loenwind.autoconfig.factory;

import info.loenwind.autoconfig.factory.AbstractValue;
import info.loenwind.autoconfig.factory.IRootFactory;
import info.loenwind.autoconfig.factory.IValueFactory;
import info.loenwind.autoconfig.factory.SlaveFactory;
import info.loenwind.autoconfig.util.NullHelper;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraftforge.common.config.Configuration;

public class ValueFactory
implements IRootFactory {
    private final String modid;
    @Nullable
    private Configuration config = null;
    private boolean inInit = false;
    private int generation = 0;
    private final List<AbstractValue<?>> preloadValues = new ArrayList();

    public ValueFactory(String modid) {
        this.modid = modid;
    }

    @Override
    @Nonnull
    public IValueFactory section(@Nonnull String section) {
        return new SlaveFactory(this, section);
    }

    @Override
    @Nonnull
    public String getModid() {
        return this.modid;
    }

    @Override
    @Nonnull
    public String getSection() {
        return "";
    }

    @Override
    public void setConfig(Configuration config) {
        this.config = config;
        ++this.generation;
        this.inInit = true;
        for (AbstractValue<?> value : this.preloadValues) {
            value.get();
        }
        this.inInit = false;
        if (config.hasChanged()) {
            config.save();
        }
    }

    @Override
    public Configuration getConfig() {
        return NullHelper.notnull(this.config, "Cannot access config before it was initialized!");
    }

    @Override
    public boolean isInInit() {
        return this.inInit;
    }

    @Override
    public int getGeneration() {
        return this.generation;
    }

    @Override
    public void addValue(@Nonnull AbstractValue<?> value) {
        this.preloadValues.add(value);
    }
}

