/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.capabilities;

import com.jaquadro.minecraft.storagedrawers.api.capabilities.IItemRepository;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.util.INBTSerializable;

public class CapabilityItemRepository {
    @CapabilityInject(value=IItemRepository.class)
    public static Capability<IItemRepository> ITEM_REPOSITORY_CAPABILITY = null;

    public static void register() {
        CapabilityManager.INSTANCE.register(IItemRepository.class, (Capability.IStorage)new DefaultStorage(), () -> new DefaultImplementation());
    }

    private static class DefaultImplementation
    implements IItemRepository {
        private DefaultImplementation() {
        }

        @Override
        @Nonnull
        public NonNullList<IItemRepository.ItemRecord> getAllItems() {
            return NonNullList.func_191196_a();
        }

        @Override
        @Nonnull
        public ItemStack insertItem(@Nonnull ItemStack stack, boolean simulate, Predicate<ItemStack> predicate) {
            return stack;
        }

        @Override
        @Nonnull
        public ItemStack extractItem(@Nonnull ItemStack stack, int amount, boolean simulate, Predicate<ItemStack> predicate) {
            return ItemStack.field_190927_a;
        }
    }

    private static class DefaultStorage
    implements Capability.IStorage<IItemRepository> {
        private DefaultStorage() {
        }

        @Nullable
        public NBTBase writeNBT(Capability<IItemRepository> capability, IItemRepository instance, EnumFacing side) {
            if (instance instanceof INBTSerializable) {
                return ((INBTSerializable)instance).serializeNBT();
            }
            return new NBTTagCompound();
        }

        public void readNBT(Capability<IItemRepository> capability, IItemRepository instance, EnumFacing side, NBTBase nbt) {
            if (instance instanceof INBTSerializable) {
                INBTSerializable serializer = (INBTSerializable)instance;
                serializer.deserializeNBT(nbt);
                return;
            }
        }
    }
}

