/*
 * Decompiled with CFR 0.152.
 */
package extracells.integration.mekanism.gas;

import appeng.api.config.FuzzyMode;
import appeng.api.storage.IStorageChannel;
import extracells.api.gas.IAEGasStack;
import extracells.item.ItemGas$;
import extracells.registries.ItemEnum;
import extracells.util.StorageChannels$;
import io.netty.buffer.ByteBuf;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import mekanism.api.gas.Gas;
import mekanism.api.gas.GasStack;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005-h\u0001B\u0001\u0003\u0001-\u0011!\"Q#HCN\u001cF/Y2l\u0015\t\u0019A!A\u0002hCNT!!\u0002\u0004\u0002\u00115,7.\u00198jg6T!a\u0002\u0005\u0002\u0017%tG/Z4sCRLwN\u001c\u0006\u0002\u0013\u0005QQ\r\u001f;sC\u000e,G\u000e\\:\u0004\u0001M\u0019\u0001\u0001\u0004\u000b\u0011\u00055\u0011R\"\u0001\b\u000b\u0005=\u0001\u0012\u0001\u00027b]\u001eT\u0011!E\u0001\u0005U\u00064\u0018-\u0003\u0002\u0014\u001d\t1qJ\u00196fGR\u0004\"!F\r\u000e\u0003YQ!aA\f\u000b\u0005aA\u0011aA1qS&\u0011!D\u0006\u0002\f\u0013\u0006+u)Y:Ti\u0006\u001c7\u000eC\u0003\u001d\u0001\u0011\u0005Q$\u0001\u0004=S:LGO\u0010\u000b\u0002=A\u0011q\u0004A\u0007\u0002\u0005!9\u0011\u0005\u0001a\u0001\n\u0013\u0011\u0013\u0001C2b]\u000e\u0013\u0018M\u001a;\u0016\u0003\r\u0002\"\u0001J\u0014\u000e\u0003\u0015R\u0011AJ\u0001\u0006g\u000e\fG.Y\u0005\u0003Q\u0015\u0012qAQ8pY\u0016\fg\u000eC\u0004+\u0001\u0001\u0007I\u0011B\u0016\u0002\u0019\r\fgn\u0011:bMR|F%Z9\u0015\u00051z\u0003C\u0001\u0013.\u0013\tqSE\u0001\u0003V]&$\bb\u0002\u0019*\u0003\u0003\u0005\raI\u0001\u0004q\u0012\n\u0004B\u0002\u001a\u0001A\u0003&1%A\u0005dC:\u001c%/\u00194uA!9A\u0007\u0001a\u0001\n\u0013)\u0014!C:uC\u000e\\7+\u001b>f+\u00051\u0004C\u0001\u00138\u0013\tATE\u0001\u0003M_:<\u0007b\u0002\u001e\u0001\u0001\u0004%IaO\u0001\u000egR\f7m[*ju\u0016|F%Z9\u0015\u00051b\u0004b\u0002\u0019:\u0003\u0003\u0005\rA\u000e\u0005\u0007}\u0001\u0001\u000b\u0015\u0002\u001c\u0002\u0015M$\u0018mY6TSj,\u0007\u0005C\u0004A\u0001\u0001\u0007I\u0011B\u001b\u0002\u0017I,\u0017/^3ti\u0006\u0014G.\u001a\u0005\b\u0005\u0002\u0001\r\u0011\"\u0003D\u0003=\u0011X-];fgR\f'\r\\3`I\u0015\fHC\u0001\u0017E\u0011\u001d\u0001\u0014)!AA\u0002YBaA\u0012\u0001!B\u00131\u0014\u0001\u0004:fcV,7\u000f^1cY\u0016\u0004\u0003bB\u0002\u0001\u0001\u0004%I\u0001S\u000b\u0002\u0013B\u0011!JT\u0007\u0002\u0017*\u00111\u0001\u0014\u0006\u000315S\u0011!B\u0005\u0003\u001f.\u00131aR1t\u0011\u001d\t\u0006\u00011A\u0005\nI\u000bqaZ1t?\u0012*\u0017\u000f\u0006\u0002-'\"9\u0001\u0007UA\u0001\u0002\u0004I\u0005BB+\u0001A\u0003&\u0011*\u0001\u0003hCN\u0004\u0003\"\u0002\u000f\u0001\t\u00039FC\u0001\u0010Y\u0011\u0015If\u000b1\u0001\u001f\u0003!yG\u000eZ*uC\u000e\\\u0007\"\u0002\u000f\u0001\t\u0003YFC\u0001\u0010]\u0011\u0015i&\f1\u0001_\u0003!9\u0017m]*uC\u000e\\\u0007C\u0001&`\u0013\t\u00017J\u0001\u0005HCN\u001cF/Y2l\u0011\u0015a\u0002\u0001\"\u0001c)\tq2\rC\u0003eC\u0002\u0007Q-A\u0002oER\u0004\"A\u001a7\u000e\u0003\u001dT!\u0001\u001a5\u000b\u0005%T\u0017!C7j]\u0016\u001c'/\u00194u\u0015\u0005Y\u0017a\u00018fi&\u0011Qn\u001a\u0002\u000f\u001d\n#F+Y4D_6\u0004x.\u001e8e\u0011\u0015a\u0002\u0001\"\u0001p)\tq\u0002\u000fC\u0003r]\u0002\u0007!/\u0001\u0003eCR\f\u0007CA:{\u001b\u0005!(BA;w\u0003\u0019\u0011WO\u001a4fe*\u0011q\u000f_\u0001\u0006]\u0016$H/\u001f\u0006\u0002s\u0006\u0011\u0011n\\\u0005\u0003wR\u0014qAQ=uK\n+h\rC\u0003~\u0001\u0011\u0005c0A\u0006hKR<\u0015m]*uC\u000e\\G#A@\u0011\u0007\u0011\n\t!C\u0002\u0002\u0004\u0015\u0012a!\u00118z%\u00164\u0007bBA\u0004\u0001\u0011\u0005\u0013\u0011B\u0001\u0004C\u0012$Gc\u0001\u0017\u0002\f!9\u0011QBA\u0003\u0001\u0004!\u0012!B:uC\u000e\\\u0007bBA\t\u0001\u0011\u0005\u00131C\u0001\u0005G>\u0004\u0018\u0010F\u0001\u0015\u0011\u0019\t9\u0002\u0001C!}\u00061q-\u001a;HCNDq!a\u0007\u0001\t\u0003\ni\"A\neK\u000e\u001cu.\u001e8u%\u0016\fX/Z:uC\ndW\rF\u0002-\u0003?Aq!!\t\u0002\u001a\u0001\u0007a'A\u0001m\u0011\u001d\t)\u0003\u0001C!\u0003O\tAb]3u'R\f7m[*ju\u0016$2\u0001FA\u0015\u0011\u001d\t\t#a\tA\u0002YBq!!\f\u0001\t\u0003\ny#\u0001\u0007jg6+\u0017M\\5oO\u001a,H\u000eF\u0001$\u0011\u001d\t\u0019\u0004\u0001C!\u0003k\t1c]3u\u0007>,h\u000e\u001e*fcV,7\u000f^1cY\u0016$2\u0001FA\u001c\u0011\u001d\t\t#!\rA\u0002YBq!a\u000f\u0001\t\u0003\ni$\u0001\u0007j]\u000e\u001cF/Y2l'&TX\rF\u0002-\u0003\u007fAq!!\t\u0002:\u0001\u0007a\u0007C\u0004\u0002D\u0001!\t%!\u0012\u0002'\u001d,GoQ8v]R\u0014V-];fgR\f'\r\\3\u0015\u0003YBq!!\u0013\u0001\t\u0003\nY%A\bgkjT\u0018pQ8na\u0006\u0014\u0018n]8o)\u0015\u0019\u0013QJA)\u0011\u001d\ty%a\u0012A\u0002Q\t\u0011a\u001c\u0005\t\u0003'\n9\u00051\u0001\u0002V\u0005Ia-\u001e>{s6{G-\u001a\t\u0005\u0003/\n\u0019'\u0004\u0002\u0002Z)!\u00111LA/\u0003\u0019\u0019wN\u001c4jO*\u0019\u0001$a\u0018\u000b\u0005\u0005\u0005\u0014AB1qa\u0016tw-\u0003\u0003\u0002f\u0005e#!\u0003$vujLXj\u001c3f\u0011\u001d\tI\u0007\u0001C!\u0003'\tQ!Z7qifDq!!\u001c\u0001\t\u0003\ny#A\u0006jg\u000e\u0013\u0018M\u001a;bE2,\u0007bBA9\u0001\u0011\u0005\u00131O\u0001\u000boJLG/\u001a+p\u001d\n#Fc\u0001\u0017\u0002v!1A-a\u001cA\u0002\u0015Dq!!\u001f\u0001\t\u0003\nY(\u0001\u0007tKR\u001c%/\u00194uC\ndW\rF\u0002\u0015\u0003{Bq!a \u0002x\u0001\u00071%A\u0001c\u0011\u001d\t\u0019\t\u0001C!\u0003\u000b\u000b1#\u001b8d\u0007>,h\u000e\u001e*fcV,7\u000f^1cY\u0016$2\u0001LAD\u0011\u001d\t\t#!!A\u0002YBq!a#\u0001\t\u0003\ni)\u0001\u0006hKR\u001c\u0005.\u00198oK2$\"!a$\u0011\u000b\u0005E\u0015q\u0013\u000b\u000e\u0005\u0005M%\u0002BAK\u0003;\nqa\u001d;pe\u0006<W-\u0003\u0003\u0002\u001a\u0006M%aD%Ti>\u0014\u0018mZ3DQ\u0006tg.\u001a7\t\u000f\u0005u\u0005\u0001\"\u0011\u0002 \u0006iqO]5uKR{\u0007+Y2lKR$2\u0001LAQ\u0011\u001d\t\u0019+a'A\u0002I\fqAY=uK\n+h\rC\u0004\u0002(\u0002!\t%!+\u0002\u0019\u0011,7m\u0015;bG.\u001c\u0016N_3\u0015\u00071\nY\u000bC\u0004\u0002\"\u0005\u0015\u0006\u0019\u0001\u001c\t\u000f\u0005=\u0006\u0001\"\u0011\u00022\u0006I\u0012m]%uK6\u001cF/Y2l%\u0016\u0004(/Z:f]R\fG/[8o)\t\t\u0019\f\u0005\u0003\u00026\u0006mVBAA\\\u0015\r\tI\f[\u0001\u0005SR,W.\u0003\u0003\u0002>\u0006]&!C%uK6\u001cF/Y2l\u0011\u001d\t\t\r\u0001C!\u0003\u000b\nAbZ3u'R\f7m[*ju\u0016Dq!!2\u0001\t\u0003\ny#\u0001\u0004jg&#X-\u001c\u0005\b\u0003\u0013\u0004A\u0011IA\u0018\u0003\u001dI7O\u00127vS\u0012Dq!!4\u0001\t\u0003\n\u0019\"A\u0003sKN,G\u000fC\u0004\u0002R\u0002!\t%a5\u0002\u0011!\f7\u000f[\"pI\u0016$\"!!6\u0011\u0007\u0011\n9.C\u0002\u0002Z\u0016\u00121!\u00138u\u0011\u001d\ti\u000e\u0001C!\u0003?\fa!Z9vC2\u001cHcA\u0012\u0002b\"A\u00111]An\u0001\u0004\t)/A\u0002pE*\u00042\u0001JAt\u0013\r\tI/\n\u0002\u0004\u0003:L\b")
public class AEGasStack
implements IAEGasStack {
    private boolean canCraft = false;
    private long stackSize = 0L;
    private long requestable = 0L;
    private Gas gas = null;

    private boolean canCraft() {
        return this.canCraft;
    }

    private void canCraft_$eq(boolean x$1) {
        this.canCraft = x$1;
    }

    private long stackSize() {
        return this.stackSize;
    }

    private void stackSize_$eq(long x$1) {
        this.stackSize = x$1;
    }

    private long requestable() {
        return this.requestable;
    }

    private void requestable_$eq(long x$1) {
        this.requestable = x$1;
    }

    private Gas gas() {
        return this.gas;
    }

    private void gas_$eq(Gas x$1) {
        this.gas = x$1;
    }

    @Override
    public Object getGasStack() {
        return new GasStack(this.gas(), (int)Math.min(Integer.MAX_VALUE, this.stackSize()));
    }

    @Override
    public void add(IAEGasStack stack) {
        if (stack == null) {
            return;
        }
        this.incStackSize(stack.getStackSize());
        this.setCountRequestable(this.getCountRequestable() + stack.getCountRequestable());
        this.setCraftable(this.isCraftable() || stack.isCraftable());
    }

    @Override
    public IAEGasStack copy() {
        return new AEGasStack(this);
    }

    @Override
    public Object getGas() {
        return this.gas();
    }

    public void decCountRequestable(long l) {
        this.requestable_$eq(this.requestable() - l);
    }

    public IAEGasStack setStackSize(long l) {
        this.stackSize_$eq(l);
        return this;
    }

    public boolean isMeaningful() {
        return this.stackSize() != 0L || this.getCountRequestable() > 0L || this.isCraftable();
    }

    public IAEGasStack setCountRequestable(long l) {
        this.requestable_$eq(l);
        return this;
    }

    public void incStackSize(long l) {
        this.stackSize_$eq(this.stackSize() + l);
    }

    public long getCountRequestable() {
        return this.requestable();
    }

    public boolean fuzzyComparison(IAEGasStack o, FuzzyMode fuzzyMode) {
        boolean bl;
        IAEGasStack iAEGasStack = o;
        if (iAEGasStack instanceof Gas) {
            Gas gas;
            Gas gas2 = gas = (Gas)iAEGasStack;
            Gas gas3 = this.gas();
            bl = !(gas2 != null ? !gas2.equals(gas3) : gas3 != null);
        } else if (iAEGasStack instanceof GasStack) {
            GasStack gasStack = (GasStack)iAEGasStack;
            Gas gas = gasStack.getGas();
            Gas gas4 = this.gas();
            bl = !(gas != null ? !gas.equals(gas4) : gas4 != null);
        } else if (iAEGasStack instanceof AEGasStack) {
            AEGasStack aEGasStack = (AEGasStack)iAEGasStack;
            Gas gas = aEGasStack.gas();
            Gas gas5 = this.gas();
            bl = !(gas != null ? !gas.equals(gas5) : gas5 != null);
        } else {
            bl = false;
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    public IAEGasStack empty() {
        void var1_1;
        IAEGasStack newStack = this.copy();
        newStack.reset();
        return var1_1;
    }

    public boolean isCraftable() {
        return this.canCraft();
    }

    public void writeToNBT(NBTTagCompound nbt) {
        this.gas().write(nbt);
        nbt.func_74772_a("amount", this.getStackSize());
        nbt.func_74757_a("isCraftable", this.isCraftable());
        nbt.func_74772_a("countRequestable", this.getCountRequestable());
    }

    public IAEGasStack setCraftable(boolean b) {
        this.canCraft_$eq(b);
        return this;
    }

    public void incCountRequestable(long l) {
        this.requestable_$eq(this.requestable() + l);
    }

    public IStorageChannel<IAEGasStack> getChannel() {
        return StorageChannels$.MODULE$.GAS();
    }

    public void writeToPacket(ByteBuf byteBuf) {
        ByteArrayOutputStream byteOutputStream = new ByteArrayOutputStream();
        DataOutputStream outputStream = new DataOutputStream(byteOutputStream);
        NBTTagCompound nbt = new NBTTagCompound();
        this.writeToNBT(nbt);
        CompressedStreamTools.func_74799_a((NBTTagCompound)nbt, (OutputStream)outputStream);
        byte[] bytes = byteOutputStream.toByteArray();
        int lenght = bytes.length;
        byteBuf.writeInt(lenght);
        byteBuf.writeBytes(bytes);
    }

    public void decStackSize(long l) {
        this.stackSize_$eq(this.stackSize() - l);
    }

    /*
     * WARNING - void declaration
     */
    public ItemStack asItemStackRepresentation() {
        void var1_1;
        ItemStack stack = ItemEnum.GASITEM.getSizedStack(1);
        ItemGas$.MODULE$.setGasName(stack, this.gas().getName());
        return var1_1;
    }

    public long getStackSize() {
        return this.stackSize();
    }

    public boolean isItem() {
        return false;
    }

    public boolean isFluid() {
        return false;
    }

    public IAEGasStack reset() {
        this.stackSize_$eq(0L);
        this.requestable_$eq(0L);
        this.canCraft_$eq(false);
        return this;
    }

    public int hashCode() {
        return this.gas().hashCode();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        Object object = obj;
        if (!(object instanceof AEGasStack)) return false;
        AEGasStack aEGasStack = (AEGasStack)object;
        if (this.canCraft() != aEGasStack.canCraft()) return false;
        if (this.requestable() != aEGasStack.requestable()) return false;
        if (this.canCraft() != aEGasStack.canCraft()) return false;
        Gas gas = this.gas();
        Gas gas2 = aEGasStack.gas();
        if (gas != null) {
            if (!gas.equals(gas2)) return false;
            return true;
        }
        if (gas2 == null) return true;
        return false;
    }

    public AEGasStack() {
    }

    public AEGasStack(AEGasStack oldStack) {
        this();
        this.gas_$eq(oldStack.gas());
        this.setStackSize(oldStack.getStackSize());
        this.setCraftable(oldStack.isCraftable());
        this.setCountRequestable(oldStack.getCountRequestable());
    }

    public AEGasStack(GasStack gasStack) {
        this();
        if (gasStack == null || gasStack.getGas() == null) {
            throw new IllegalArgumentException("Gas is null");
        }
        this.gas_$eq(gasStack.getGas());
        this.setStackSize(gasStack.amount);
        this.setCraftable(false);
        this.setCountRequestable(0L);
    }

    public AEGasStack(NBTTagCompound nbt) {
        this();
        this.gas_$eq(Gas.readFromNBT((NBTTagCompound)nbt));
        this.setStackSize(nbt.func_74763_f("amount"));
        this.setCraftable(nbt.func_74767_n("isCraftable"));
        this.setCountRequestable(nbt.func_74763_f("countRequestable"));
    }

    public AEGasStack(ByteBuf data) {
        this();
        int lenght = data.readInt();
        byte[] bytes = new byte[lenght];
        data.readBytes(bytes);
        DataInputStream inputStream = new DataInputStream(new ByteArrayInputStream(bytes));
        NBTTagCompound nbt = CompressedStreamTools.func_74796_a((InputStream)inputStream);
        this.gas_$eq(Gas.readFromNBT((NBTTagCompound)nbt));
        this.setStackSize(nbt.func_74763_f("amount"));
        this.setCraftable(nbt.func_74767_n("isCraftable"));
        this.setCountRequestable(nbt.func_74763_f("countRequestable"));
    }
}

