/*
 * Decompiled with CFR 0.152.
 */
package extracells.models.blocks;

import com.google.common.collect.ImmutableList;
import extracells.models.BlankModel;
import extracells.registries.ItemEnum;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import javax.annotation.Nullable;
import mekanism.api.gas.Gas;
import mekanism.api.gas.GasRegistry;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ModelBakery;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.item.Item;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.ICustomModelLoader;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.ItemLayerModel;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.common.model.TRSRTransformation;

public class GasItemModel
implements IModel {
    public Gas gas;

    public GasItemModel(Gas gas) {
        this.gas = gas;
    }

    public Collection<ResourceLocation> getDependencies() {
        return Collections.emptyList();
    }

    public Collection<ResourceLocation> getTextures() {
        return Collections.singletonList(this.gas.getIcon());
    }

    public IBakedModel bake(IModelState state, VertexFormat format, Function<ResourceLocation, TextureAtlasSprite> bakedTextureGetter) {
        TextureAtlasSprite sprite = bakedTextureGetter.apply(this.gas.getIcon());
        if (sprite == null) {
            return new GasItemBakedModel((ImmutableList<BakedQuad>)ImmutableList.of());
        }
        return new GasItemBakedModel((ImmutableList<BakedQuad>)ItemLayerModel.getQuadsForSprite((int)0, (TextureAtlasSprite)sprite, (VertexFormat)format, Optional.empty()));
    }

    public IModelState getDefaultState() {
        return TRSRTransformation.identity();
    }

    private class GasItemBakedModel
    extends BlankModel {
        ImmutableList<BakedQuad> quads;

        public GasItemBakedModel(ImmutableList<BakedQuad> quads) {
            this.quads = quads;
        }

        @Override
        public List<BakedQuad> func_188616_a(@Nullable IBlockState state, @Nullable EnumFacing side, long rand) {
            if (side != EnumFacing.UP) {
                return ImmutableList.of();
            }
            return this.quads;
        }

        @Override
        public boolean func_177556_c() {
            return false;
        }
    }

    public static class ModelLoader
    implements ICustomModelLoader {
        public boolean accepts(ResourceLocation modelLocation) {
            return modelLocation.func_110624_b().equals("extracells") && modelLocation.func_110623_a().contains("models/item/gas/");
        }

        public IModel loadModel(ResourceLocation modelLocation) throws Exception {
            String gasName = modelLocation.func_110623_a().replace("models/item/gas/", "");
            Gas gas = GasRegistry.getGas((String)gasName);
            if (gas == null) {
                gas = (Gas)GasRegistry.getRegisteredGasses().iterator().next();
            }
            return new GasItemModel(gas);
        }

        public void func_110549_a(IResourceManager resourceManager) {
            for (Gas gas : GasRegistry.getRegisteredGasses()) {
                ModelBakery.registerItemVariants((Item)ItemEnum.FLUIDITEM.getItem(), (ResourceLocation[])new ResourceLocation[]{new ResourceLocation("extracells:gas/" + gas.getName())});
            }
        }
    }
}

