/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.core;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import mod.chiselsandbits.api.IChiselAndBitsAPI;
import mod.chiselsandbits.chiseledblock.BlockBitInfo;
import mod.chiselsandbits.chiseledblock.data.VoxelBlob;
import mod.chiselsandbits.client.CreativeClipboardTab;
import mod.chiselsandbits.client.UndoTracker;
import mod.chiselsandbits.client.gui.ModGuiRouter;
import mod.chiselsandbits.commands.SetBit;
import mod.chiselsandbits.config.ModConfig;
import mod.chiselsandbits.core.ClientSide;
import mod.chiselsandbits.core.api.ChiselAndBitsAPI;
import mod.chiselsandbits.core.api.IMCHandler;
import mod.chiselsandbits.crafting.ModRecipes;
import mod.chiselsandbits.events.EventPlayerInteract;
import mod.chiselsandbits.events.VaporizeWater;
import mod.chiselsandbits.integration.Integration;
import mod.chiselsandbits.interfaces.ICacheClearable;
import mod.chiselsandbits.network.NetworkRouter;
import mod.chiselsandbits.registry.ModBlocks;
import mod.chiselsandbits.registry.ModItems;
import net.minecraft.block.material.Material;
import net.minecraft.command.ICommand;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLInterModComms;
import net.minecraftforge.fml.common.event.FMLModIdMappingEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.relauncher.Side;

@Mod(name="Chisels & Bits", modid="chiselsandbits", version="14.30", acceptedMinecraftVersions="[1.12]", guiFactory="mod.chiselsandbits.client.gui.ModConfigGuiFactory")
public class ChiselsAndBits {
    @Nonnull
    public static final String MODNAME = "Chisels & Bits";
    @Nonnull
    public static final String MODID = "chiselsandbits";
    @Nonnull
    public static final String VERSION = "14.30";
    public static final String DEPENDENCIES = "required-after:Forge@[12.17.0.1909,);before:mcmultipart;after:JEI@[3.7.8.234,)";
    private static ChiselsAndBits instance;
    private ModConfig config;
    private ModItems items;
    private ModBlocks blocks;
    private final Integration integration = new Integration();
    private final IChiselAndBitsAPI api = new ChiselAndBitsAPI();
    private boolean loadClientAssets = false;
    List<ICacheClearable> cacheClearables = new ArrayList<ICacheClearable>();
    boolean idsHaveBeenMapped = false;

    public ChiselsAndBits() {
        instance = this;
    }

    public static ChiselsAndBits getInstance() {
        return instance;
    }

    public static ModBlocks getBlocks() {
        return ChiselsAndBits.instance.blocks;
    }

    public static ModItems getItems() {
        return ChiselsAndBits.instance.items;
    }

    public static ModConfig getConfig() {
        return ChiselsAndBits.instance.config;
    }

    public static IChiselAndBitsAPI getApi() {
        return ChiselsAndBits.instance.api;
    }

    @Mod.EventHandler
    private void handleIMCEvent(FMLInterModComms.IMCEvent event) {
        IMCHandler imcHandler = new IMCHandler();
        imcHandler.handleIMCEvent(event);
    }

    @Mod.EventHandler
    public void preinit(FMLPreInitializationEvent event) {
        File configFile = event.getSuggestedConfigurationFile();
        this.config = new ModConfig(configFile);
        this.items = new ModItems(ChiselsAndBits.getConfig());
        this.blocks = new ModBlocks(ChiselsAndBits.getConfig(), event.getSide());
        ChiselsAndBits.registerWithBus(new ModRecipes(ChiselsAndBits.getConfig()));
        this.integration.preinit(event);
        ChiselsAndBits.getApi().addEquivilantMaterial(Material.field_151583_m, Material.field_151571_B);
        ChiselsAndBits.getApi().addEquivilantMaterial(Material.field_151574_g, Material.field_151573_f);
        ChiselsAndBits.getApi().addEquivilantMaterial(Material.field_151585_k, Material.field_151577_b);
        ChiselsAndBits.getApi().addEquivilantMaterial(Material.field_151572_C, Material.field_151585_k);
        ChiselsAndBits.getApi().addEquivilantMaterial(Material.field_151570_A, Material.field_151585_k);
        ChiselsAndBits.getApi().addEquivilantMaterial(Material.field_151589_v, Material.field_151576_e);
        ChiselsAndBits.getApi().addEquivilantMaterial(Material.field_151569_G, Material.field_151585_k);
        ChiselsAndBits.getApi().addEquivilantMaterial(Material.field_151582_l, Material.field_151585_k);
        ChiselsAndBits.getApi().addEquivilantMaterial(Material.field_151590_u, Material.field_151576_e);
        if (event.getSide() == Side.CLIENT) {
            this.loadClientAssets = true;
            CreativeClipboardTab.load(new File(configFile.getParent(), "chiselsandbits_clipboard.cfg"));
            ClientSide.instance.preinit(this);
        }
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        if (event.getSide() == Side.CLIENT) {
            ClientSide.instance.init(this);
        }
        this.integration.init();
        ChiselsAndBits.registerWithBus(new EventPlayerInteract());
        ChiselsAndBits.registerWithBus(new VaporizeWater());
    }

    @Mod.EventHandler
    public void serverStart(FMLServerStartingEvent e) {
        if (ChiselsAndBits.getConfig().enableSetBitCommand) {
            e.registerServerCommand((ICommand)new SetBit());
        }
    }

    @Mod.EventHandler
    public void postinit(FMLPostInitializationEvent event) {
        if (event.getSide() == Side.CLIENT) {
            ClientSide.instance.postinit(this);
        }
        this.integration.postinit();
        NetworkRouter.instance = new NetworkRouter();
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)this, (IGuiHandler)new ModGuiRouter());
    }

    @Mod.EventHandler
    public void idsMapped(FMLModIdMappingEvent event) {
        this.idsHaveBeenMapped = true;
        BlockBitInfo.recalculateFluidBlocks();
        this.clearCache();
    }

    public void clearCache() {
        if (this.idsHaveBeenMapped) {
            for (ICacheClearable clearable : this.cacheClearables) {
                clearable.clearCache();
            }
            this.addClearable(UndoTracker.getInstance());
            VoxelBlob.clearCache();
        }
    }

    public static void registerWithBus(Object obj) {
        MinecraftForge.EVENT_BUS.register(obj);
    }

    public void addClearable(ICacheClearable cache) {
        if (!this.cacheClearables.contains(cache)) {
            this.cacheClearables.add(cache);
        }
    }

    public boolean loadClientAssets() {
        return this.loadClientAssets;
    }
}

