/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.core.common.fluid;

import com.enderio.core.api.common.util.ITankAccess;
import com.enderio.core.common.fluid.IFluidWrapper;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;

public class TankAccessFluidWrapper
implements IFluidWrapper {
    private final ITankAccess tankAccess;

    public TankAccessFluidWrapper(ITankAccess tankAccess) {
        this.tankAccess = tankAccess;
    }

    @Override
    public int offer(FluidStack resource) {
        FluidTank inputTank = this.tankAccess.getInputTank(resource);
        if (inputTank != null) {
            return inputTank.fill(resource, false);
        }
        return 0;
    }

    @Override
    public int fill(FluidStack resource) {
        FluidTank inputTank = this.tankAccess.getInputTank(resource);
        if (inputTank != null) {
            this.tankAccess.setTanksDirty();
            return inputTank.fill(resource, true);
        }
        return 0;
    }

    @Override
    @Nullable
    public FluidStack drain(FluidStack resource) {
        FluidTank[] outputTanks = this.tankAccess.getOutputTanks();
        if (outputTanks.length >= 1 && outputTanks[0] != null) {
            this.tankAccess.setTanksDirty();
            return outputTanks[0].drain(resource, true);
        }
        return null;
    }

    @Override
    @Nullable
    public FluidStack getAvailableFluid() {
        FluidTank[] outputTanks = this.tankAccess.getOutputTanks();
        if (outputTanks.length >= 1 && outputTanks[0] != null) {
            return outputTanks[0].getFluid();
        }
        return null;
    }

    @Override
    @Nonnull
    public List<IFluidWrapper.ITankInfoWrapper> getTankInfoWrappers() {
        return Collections.emptyList();
    }
}

