/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.gui.overlay.bookmarks;

import java.awt.Rectangle;
import java.util.Set;
import javax.annotation.Nullable;
import mezz.jei.bookmarks.BookmarkList;
import mezz.jei.config.Config;
import mezz.jei.gui.GuiHelper;
import mezz.jei.gui.GuiScreenHelper;
import mezz.jei.gui.elements.GuiIconToggleButton;
import mezz.jei.gui.overlay.GridAlignment;
import mezz.jei.gui.overlay.IngredientGrid;
import mezz.jei.gui.overlay.IngredientGridWithNavigation;
import mezz.jei.gui.overlay.bookmarks.BookmarkButton;
import mezz.jei.gui.overlay.bookmarks.ILeftAreaContent;
import mezz.jei.gui.recipes.RecipesGui;
import mezz.jei.input.IClickedIngredient;
import mezz.jei.input.IShowsRecipeFocuses;
import mezz.jei.util.CommandUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.item.ItemStack;

public class BookmarkOverlay
implements IShowsRecipeFocuses,
ILeftAreaContent {
    private static final int BUTTON_SIZE = 20;
    private Rectangle parentArea = new Rectangle();
    private Rectangle displayArea = new Rectangle();
    private final IngredientGridWithNavigation contents;
    private final GuiIconToggleButton bookmarkButton;
    private boolean hasRoom = false;
    private final BookmarkList bookmarkList;

    public BookmarkOverlay(BookmarkList bookmarkList, GuiHelper guiHelper, GuiScreenHelper guiScreenHelper) {
        this.bookmarkList = bookmarkList;
        this.bookmarkButton = BookmarkButton.create(this, bookmarkList, guiHelper);
        this.contents = new IngredientGridWithNavigation(bookmarkList, guiScreenHelper, GridAlignment.RIGHT);
        bookmarkList.addListener(() -> this.contents.updateLayout(false));
    }

    public boolean isListDisplayed() {
        return Config.isBookmarkOverlayEnabled() && this.hasRoom && !this.bookmarkList.isEmpty();
    }

    public boolean hasRoom() {
        return this.hasRoom;
    }

    @Override
    public void updateBounds(Rectangle area, Set<Rectangle> guiExclusionAreas) {
        this.parentArea = area;
        this.hasRoom = this.updateBounds(guiExclusionAreas);
    }

    @Override
    public void drawScreen(Minecraft minecraft, int mouseX, int mouseY, float partialTicks) {
        if (this.isListDisplayed()) {
            this.contents.draw(minecraft, mouseX, mouseY, partialTicks);
        }
        this.bookmarkButton.draw(minecraft, mouseX, mouseY, partialTicks);
    }

    @Override
    public void drawOnForeground(GuiContainer gui, int mouseX, int mouseY) {
    }

    @Override
    public void drawTooltips(Minecraft minecraft, int mouseX, int mouseY) {
        if (this.isListDisplayed()) {
            this.contents.drawTooltips(minecraft, mouseX, mouseY);
        }
        this.bookmarkButton.drawTooltips(minecraft, mouseX, mouseY);
    }

    private static int getMinWidth() {
        return Math.max(80, 4 * IngredientGrid.INGREDIENT_WIDTH);
    }

    public boolean updateBounds(Set<Rectangle> guiExclusionAreas) {
        this.displayArea = new Rectangle(this.parentArea);
        int minWidth = BookmarkOverlay.getMinWidth();
        if (this.displayArea.width < minWidth) {
            return false;
        }
        Rectangle availableContentsArea = new Rectangle(this.displayArea.x, this.displayArea.y, this.displayArea.width, this.displayArea.height - 24);
        boolean contentsHasRoom = this.contents.updateBounds(availableContentsArea, guiExclusionAreas, minWidth);
        Rectangle contentsArea = this.contents.getArea();
        this.displayArea.x = contentsArea.x;
        this.displayArea.width = contentsArea.width;
        this.bookmarkButton.updateBounds(new Rectangle(this.displayArea.x, (int)Math.floor(this.displayArea.getMaxY()) - 20 - 2, 20, 20));
        this.contents.updateLayout(false);
        return contentsHasRoom;
    }

    @Override
    @Nullable
    public IClickedIngredient<?> getIngredientUnderMouse(int mouseX, int mouseY) {
        if (this.isListDisplayed()) {
            return this.contents.getIngredientUnderMouse(mouseX, mouseY);
        }
        return null;
    }

    @Override
    public boolean canSetFocusWithMouse() {
        return this.isListDisplayed() && this.contents.canSetFocusWithMouse();
    }

    @Override
    public boolean handleMouseScrolled(int mouseX, int mouseY, int scrollDelta) {
        return this.isListDisplayed() && this.displayArea.contains(mouseX, mouseY) && this.contents.handleMouseScrolled(mouseX, mouseY, scrollDelta);
    }

    @Override
    public boolean handleMouseClicked(int mouseX, int mouseY, int mouseButton) {
        if (this.isListDisplayed()) {
            if (this.displayArea.contains(mouseX, mouseY)) {
                IClickedIngredient<?> clicked;
                Minecraft minecraft = Minecraft.func_71410_x();
                GuiScreen currentScreen = minecraft.field_71462_r;
                if (currentScreen != null && !(currentScreen instanceof RecipesGui) && (mouseButton == 0 || mouseButton == 1 || minecraft.field_71474_y.field_74322_I.isActiveAndMatches(mouseButton - 100)) && (clicked = this.getIngredientUnderMouse(mouseX, mouseY)) != null && Config.isCheatItemsEnabled()) {
                    ItemStack itemStack = clicked.getCheatItemStack();
                    if (!itemStack.func_190926_b()) {
                        CommandUtil.giveStack(itemStack, mouseButton);
                    }
                    clicked.onClickHandled();
                    return true;
                }
            }
            if (this.contents.isMouseOver(mouseX, mouseY)) {
                this.contents.handleMouseClicked(mouseX, mouseY, mouseButton);
            }
        }
        if (this.bookmarkButton.isMouseOver(mouseX, mouseY)) {
            return this.bookmarkButton.handleMouseClick(mouseX, mouseY);
        }
        return false;
    }
}

