/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.screens.modulesclient;

import java.util.Locale;
import mcjty.rftools.api.screens.IClientScreenModule;
import mcjty.rftools.api.screens.IModuleRenderHelper;
import mcjty.rftools.api.screens.ModuleRenderInfo;
import mcjty.rftools.api.screens.data.IModuleData;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class ClockClientScreenModule
implements IClientScreenModule<IModuleData> {
    private int color = 0xFFFFFF;
    private String line = "";
    private boolean large = false;

    @Override
    public IClientScreenModule.TransformMode getTransformMode() {
        return this.large ? IClientScreenModule.TransformMode.TEXTLARGE : IClientScreenModule.TransformMode.TEXT;
    }

    @Override
    public int getHeight() {
        return this.large ? 20 : 10;
    }

    @Override
    public void render(IModuleRenderHelper renderHelper, FontRenderer fontRenderer, int currenty, IModuleData screenData, ModuleRenderInfo renderInfo) {
        int y;
        int xoffset;
        GlStateManager.func_179140_f();
        Minecraft minecraft = Minecraft.func_71410_x();
        long time = minecraft.field_71441_e.func_72820_D();
        long hour = (time / 1000L + 6L) % 24L;
        long minute = time % 1000L * 60L / 1000L;
        String timeString = String.format(Locale.ENGLISH, "%02d:%02d", hour, minute);
        if (this.large) {
            xoffset = 4;
            y = currenty / 2 + 1;
        } else {
            xoffset = 7;
            y = currenty;
        }
        renderHelper.renderText(xoffset, y, this.color, renderInfo, this.line + " " + timeString);
    }

    @Override
    public void mouseClick(World world, int x, int y, boolean clicked) {
    }

    @Override
    public void setupFromNBT(NBTTagCompound tagCompound, int dim, BlockPos pos) {
        if (tagCompound != null) {
            this.line = tagCompound.func_74779_i("text");
            this.color = tagCompound.func_74764_b("color") ? tagCompound.func_74762_e("color") : 0xFFFFFF;
            this.large = tagCompound.func_74767_n("large");
        }
    }

    @Override
    public boolean needsServerData() {
        return false;
    }
}

