/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.items.smartwrench;

import cofh.api.item.IToolHammer;
import java.util.List;
import mcjty.lib.McJtyRegister;
import mcjty.lib.api.smartwrench.SmartWrench;
import mcjty.lib.api.smartwrench.SmartWrenchMode;
import mcjty.lib.api.smartwrench.SmartWrenchSelector;
import mcjty.lib.base.ModBase;
import mcjty.lib.blocks.GenericBlock;
import mcjty.lib.varia.BlockPosTools;
import mcjty.lib.varia.GlobalCoordinate;
import mcjty.lib.varia.Logging;
import mcjty.rftools.RFTools;
import mcjty.rftools.blocks.ores.DimensionalShardBlock;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelBakery;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@Optional.Interface(iface="cofh.api.item.IToolHammer", modid="cofhapi|item")
public class SmartWrenchItem
extends Item
implements IToolHammer,
SmartWrench {
    public SmartWrenchItem() {
        this.func_77655_b("smartwrench");
        this.setRegistryName("smartwrench");
        this.func_77637_a(RFTools.tabRfTools);
        this.func_77625_d(1);
        McJtyRegister.registerLater((Item)this, (ModBase)RFTools.instance);
    }

    @SideOnly(value=Side.CLIENT)
    public void initModel() {
        ModelResourceLocation selectedModel = new ModelResourceLocation(this.getRegistryName() + "_select", "inventory");
        ModelResourceLocation normalModel = new ModelResourceLocation(this.getRegistryName(), "inventory");
        ModelBakery.registerItemVariants((Item)this, (ResourceLocation[])new ResourceLocation[]{selectedModel, normalModel});
        ModelLoader.setCustomMeshDefinition((Item)this, stack -> {
            SmartWrenchMode mode = SmartWrenchItem.getCurrentMode(stack);
            if (mode == SmartWrenchMode.MODE_SELECT) {
                return selectedModel;
            }
            return normalModel;
        });
    }

    @Optional.Method(modid="cofhapi|item")
    public boolean isUsable(ItemStack item, EntityLivingBase user, BlockPos pos) {
        SmartWrenchMode mode = SmartWrenchItem.getCurrentMode(item);
        return mode == SmartWrenchMode.MODE_WRENCH;
    }

    @Optional.Method(modid="cofhapi|item")
    public boolean isUsable(ItemStack item, EntityLivingBase user, Entity entity) {
        SmartWrenchMode mode = SmartWrenchItem.getCurrentMode(item);
        return mode == SmartWrenchMode.MODE_WRENCH;
    }

    @Optional.Method(modid="cofhapi|item")
    public void toolUsed(ItemStack item, EntityLivingBase user, BlockPos pos) {
    }

    @Optional.Method(modid="cofhapi|item")
    public void toolUsed(ItemStack item, EntityLivingBase user, Entity entity) {
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (!world.field_72995_K) {
            SmartWrenchMode mode = SmartWrenchItem.getCurrentMode(stack);
            mode = mode == SmartWrenchMode.MODE_WRENCH ? SmartWrenchMode.MODE_SELECT : SmartWrenchMode.MODE_WRENCH;
            NBTTagCompound tagCompound = stack.func_77978_p();
            if (tagCompound == null) {
                tagCompound = new NBTTagCompound();
                stack.func_77982_d(tagCompound);
            }
            tagCompound.func_74778_a("mode", mode.getCode());
            Logging.message((EntityPlayer)player, (String)(TextFormatting.YELLOW + "Smart wrench is now in " + mode.getName() + " mode."));
        }
        return super.func_77659_a(world, player, hand);
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemStack stack = player.func_184586_b(hand);
        if (!world.field_72995_K) {
            GlobalCoordinate b;
            IBlockState state;
            Block block;
            if (player.func_70093_af() && (block = (state = world.func_180495_p(pos)).func_177230_c()) instanceof GenericBlock && DimensionalShardBlock.activateBlock(block, world, pos, state, player, hand, facing, hitX, hitY, hitZ)) {
                return EnumActionResult.SUCCESS;
            }
            SmartWrenchMode mode = SmartWrenchItem.getCurrentMode(stack);
            if (mode == SmartWrenchMode.MODE_SELECT && (b = SmartWrenchItem.getCurrentBlock(stack)) != null) {
                if (b.getDimension() != world.field_73011_w.getDimension()) {
                    Logging.message((EntityPlayer)player, (String)(TextFormatting.RED + "The selected block is in another dimension!"));
                    return EnumActionResult.FAIL;
                }
                TileEntity te = world.func_175625_s(b.getCoordinate());
                if (te instanceof SmartWrenchSelector) {
                    SmartWrenchSelector smartWrenchSelector = (SmartWrenchSelector)te;
                    smartWrenchSelector.selectBlock(player, pos);
                }
            }
        }
        return EnumActionResult.SUCCESS;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack itemStack, World player, List<String> list, ITooltipFlag whatIsThis) {
        super.func_77624_a(itemStack, player, list, whatIsThis);
        GlobalCoordinate b = SmartWrenchItem.getCurrentBlock(itemStack);
        if (b != null) {
            list.add(TextFormatting.GREEN + "Block: " + BlockPosTools.toString((BlockPos)b.getCoordinate()) + " at dimension " + b.getDimension());
        }
        SmartWrenchMode mode = SmartWrenchItem.getCurrentMode(itemStack);
        list.add(TextFormatting.WHITE + "Right-click on air to change mode.");
        list.add(TextFormatting.GREEN + "Mode: " + mode.getName());
        if (mode == SmartWrenchMode.MODE_WRENCH) {
            list.add(TextFormatting.WHITE + "Use as a normal wrench:");
            list.add(TextFormatting.WHITE + "    Sneak-right-click to pick up machines.");
            list.add(TextFormatting.WHITE + "    Right-click to rotate machines.");
        } else if (mode == SmartWrenchMode.MODE_SELECT) {
            list.add(TextFormatting.WHITE + "Use as a block selector:");
            list.add(TextFormatting.WHITE + "    Sneak-right-click select master block.");
            list.add(TextFormatting.WHITE + "    Right-click to associate blocks with master.");
        }
    }

    public SmartWrenchMode getMode(ItemStack itemStack) {
        String modeString;
        SmartWrenchMode mode = SmartWrenchMode.MODE_WRENCH;
        NBTTagCompound tagCompound = itemStack.func_77978_p();
        if (tagCompound != null && (modeString = tagCompound.func_74779_i("mode")) != null && !modeString.isEmpty()) {
            mode = SmartWrenchMode.getMode((String)modeString);
        }
        return mode;
    }

    public static SmartWrenchMode getCurrentMode(ItemStack itemStack) {
        String modeString;
        SmartWrenchMode mode = SmartWrenchMode.MODE_WRENCH;
        NBTTagCompound tagCompound = itemStack.func_77978_p();
        if (tagCompound != null && (modeString = tagCompound.func_74779_i("mode")) != null && !modeString.isEmpty()) {
            mode = SmartWrenchMode.getMode((String)modeString);
        }
        return mode;
    }

    public static void setCurrentBlock(ItemStack itemStack, GlobalCoordinate c) {
        NBTTagCompound tagCompound = itemStack.func_77978_p();
        if (tagCompound == null) {
            tagCompound = new NBTTagCompound();
            itemStack.func_77982_d(tagCompound);
        }
        if (c == null) {
            tagCompound.func_82580_o("selectedX");
            tagCompound.func_82580_o("selectedY");
            tagCompound.func_82580_o("selectedZ");
            tagCompound.func_82580_o("selectedDim");
        } else {
            tagCompound.func_74768_a("selectedX", c.getCoordinate().func_177958_n());
            tagCompound.func_74768_a("selectedY", c.getCoordinate().func_177956_o());
            tagCompound.func_74768_a("selectedZ", c.getCoordinate().func_177952_p());
            tagCompound.func_74768_a("selectedDim", c.getDimension());
        }
    }

    public static GlobalCoordinate getCurrentBlock(ItemStack itemStack) {
        NBTTagCompound tagCompound = itemStack.func_77978_p();
        if (tagCompound != null && tagCompound.func_74764_b("selectedX")) {
            int x = tagCompound.func_74762_e("selectedX");
            int y = tagCompound.func_74762_e("selectedY");
            int z = tagCompound.func_74762_e("selectedZ");
            int dim = tagCompound.func_74762_e("selectedDim");
            return new GlobalCoordinate(new BlockPos(x, y, z), dim);
        }
        return null;
    }

    public int func_77626_a(ItemStack stack) {
        return 1;
    }
}

