/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.item;

import com.buuz135.industrial.item.IFCustomItem;
import com.buuz135.industrial.proxy.BlockRegistry;
import com.buuz135.industrial.proxy.ItemRegistry;
import com.buuz135.industrial.utils.RecipeUtils;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;

public class MobImprisonmentToolItem
extends IFCustomItem {
    public MobImprisonmentToolItem() {
        super("mob_imprisonment_tool");
        this.func_77625_d(1);
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World worldIn, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemStack stack = player.func_184586_b(hand);
        if (player.func_130014_f_().field_72995_K) {
            return EnumActionResult.FAIL;
        }
        if (!this.containsEntity(stack)) {
            return EnumActionResult.FAIL;
        }
        Entity entity = this.getEntityFromStack(stack, worldIn, true);
        BlockPos blockPos = pos.func_177972_a(facing);
        entity.func_70080_a((double)blockPos.func_177958_n() + 0.5, (double)blockPos.func_177956_o(), (double)blockPos.func_177952_p() + 0.5, 0.0f, 0.0f);
        stack.func_77982_d(new NBTTagCompound());
        player.func_184611_a(hand, stack);
        worldIn.func_72838_d(entity);
        if (entity instanceof EntityLiving) {
            ((EntityLiving)entity).func_70642_aH();
        }
        return EnumActionResult.SUCCESS;
    }

    public boolean func_111207_a(ItemStack stack, EntityPlayer playerIn, EntityLivingBase target, EnumHand hand) {
        if (target.func_130014_f_().field_72995_K) {
            return false;
        }
        if (target instanceof EntityPlayer || !target.func_184222_aU() || !target.func_70089_S()) {
            return false;
        }
        if (this.containsEntity(stack)) {
            return false;
        }
        String entityID = EntityList.func_191301_a((Entity)target).toString();
        if (this.isBlacklisted(entityID)) {
            return false;
        }
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74778_a("entity", entityID);
        nbt.func_74768_a("id", EntityList.getID(target.getClass()));
        target.func_189511_e(nbt);
        stack.func_77982_d(nbt);
        playerIn.func_184609_a(hand);
        playerIn.func_184611_a(hand, stack);
        target.func_70106_y();
        return true;
    }

    public boolean isBlacklisted(String entity) {
        return false;
    }

    public boolean containsEntity(ItemStack stack) {
        return !stack.func_190926_b() && stack.func_77942_o() && stack.func_77978_p().func_74764_b("entity");
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        if (this.containsEntity(stack) && EntityList.func_191302_a((ResourceLocation)new ResourceLocation(this.getID(stack))) != null) {
            tooltip.add("Mob: " + new TextComponentTranslation(EntityList.func_191302_a((ResourceLocation)new ResourceLocation(this.getID(stack))), new Object[0]).func_150261_e());
            tooltip.add("Health: " + stack.func_77978_p().func_74769_h("Health"));
            if (BlockRegistry.mobDuplicatorBlock.blacklistedEntities.contains(stack.func_77978_p().func_74779_i("entity"))) {
                tooltip.add(TextFormatting.RED + "Entity blacklisted in the Mob Duplicator");
            }
        }
    }

    public Entity getEntityFromStack(ItemStack stack, World world, boolean withInfo) {
        Entity entity = EntityList.func_188429_b((ResourceLocation)new ResourceLocation(stack.func_77978_p().func_74779_i("entity")), (World)world);
        if (withInfo) {
            entity.func_70020_e(stack.func_77978_p());
        }
        return entity;
    }

    public String getID(ItemStack stack) {
        return stack.func_77978_p().func_74779_i("entity");
    }

    @Override
    public void createRecipe() {
        RecipeUtils.addShapedRecipe(new ItemStack((Item)this), new Object[]{" p ", "pgp", " p ", Character.valueOf('p'), ItemRegistry.plastic, Character.valueOf('g'), new ItemStack(Items.field_151073_bk)});
    }

    public String func_77653_i(ItemStack stack) {
        if (!this.containsEntity(stack)) {
            return new TextComponentTranslation(super.func_77667_c(stack) + ".name", new Object[0]).func_150261_e();
        }
        return new TextComponentTranslation(super.func_77667_c(stack) + ".name", new Object[0]).func_150261_e() + " (" + EntityList.func_191302_a((ResourceLocation)new ResourceLocation(this.getID(stack))) + ")";
    }
}

