/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.item.addon.movility;

import com.buuz135.industrial.item.addon.movility.TransferAddon;
import com.buuz135.industrial.proxy.ItemRegistry;
import com.buuz135.industrial.utils.RecipeUtils;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class FluidTransferAddon
extends TransferAddon {
    public FluidTransferAddon(TransferAddon.ActionMode mode) {
        super("fluid_transfer_addon", mode);
    }

    @Override
    public void createRecipe() {
        RecipeUtils.addShapedRecipe(new ItemStack((Item)this), new Object[]{"pcp", "dtd", "pcp", Character.valueOf('p'), ItemRegistry.plastic, Character.valueOf('c'), Items.field_151133_ar, Character.valueOf('d'), "dyeLightBlue", Character.valueOf('t'), this.getMode() == TransferAddon.ActionMode.PUSH ? Blocks.field_150331_J : Blocks.field_150320_F});
    }

    @Override
    public boolean actionTransfer(World world, BlockPos pos, EnumFacing facing, int transferAmount) {
        TileEntity tileEntityOrigin = world.func_175625_s(pos);
        TileEntity tileEntityDestination = world.func_175625_s(pos.func_177972_a(facing));
        if (tileEntityOrigin != null && tileEntityDestination != null && tileEntityOrigin.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, facing) && tileEntityDestination.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, facing.func_176734_d())) {
            IFluidHandler fluidHandlerOrigin = this.getCapabilityOriginByMode(tileEntityOrigin, tileEntityDestination, facing);
            IFluidHandler fluidHandlerDestination = this.getCapabilityDestinationByMode(tileEntityOrigin, tileEntityDestination, facing);
            FluidStack fluidStack = fluidHandlerOrigin.drain(transferAmount * 100, false);
            if (fluidStack != null) {
                fluidHandlerOrigin.drain(fluidHandlerDestination.fill(fluidStack, true), true);
                return true;
            }
        }
        return false;
    }

    public IFluidHandler getCapabilityOriginByMode(TileEntity origin, TileEntity destination, EnumFacing facing) {
        return this.getMode() == TransferAddon.ActionMode.PUSH ? (IFluidHandler)origin.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, facing) : (IFluidHandler)destination.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, facing.func_176734_d());
    }

    public IFluidHandler getCapabilityDestinationByMode(TileEntity origin, TileEntity destination, EnumFacing facing) {
        return this.getMode() == TransferAddon.ActionMode.PUSH ? (IFluidHandler)destination.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, facing.func_176734_d()) : (IFluidHandler)origin.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, facing);
    }
}

