/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.tile;

import com.buuz135.industrial.item.addon.RangeAddonItem;
import com.buuz135.industrial.proxy.CommonProxy;
import com.buuz135.industrial.proxy.client.ClientProxy;
import com.buuz135.industrial.tile.CustomElectricMachine;
import com.buuz135.industrial.utils.WorkUtils;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.ndrei.teslacorelib.gui.BasicTeslaGuiContainer;
import net.ndrei.teslacorelib.gui.IGuiContainerPiece;
import net.ndrei.teslacorelib.gui.ToggleButtonPiece;
import net.ndrei.teslacorelib.inventory.BoundingRectangle;
import net.ndrei.teslacorelib.render.IWorkAreaProvider;
import net.ndrei.teslacorelib.render.WorkingAreaRenderer;
import net.ndrei.teslacorelib.utils.BlockCube;
import org.jetbrains.annotations.NotNull;

public abstract class WorkingAreaElectricMachine
extends CustomElectricMachine
implements IWorkAreaProvider {
    private int color = CommonProxy.random.nextInt();
    private boolean showArea;

    protected WorkingAreaElectricMachine(int typeId) {
        super(typeId);
    }

    @Override
    protected void initializeInventories() {
        super.initializeInventories();
    }

    public List<IGuiContainerPiece> getGuiContainerPieces(BasicTeslaGuiContainer container) {
        List<IGuiContainerPiece> list = super.getGuiContainerPieces(container);
        list.add((IGuiContainerPiece)new ToggleButtonPiece(136, 84, 13, 13, 0){

            protected int getCurrentState() {
                return WorkingAreaElectricMachine.this.showArea ? 1 : 0;
            }

            protected void renderState(BasicTeslaGuiContainer container, int state, BoundingRectangle box) {
            }

            public void drawBackgroundLayer(BasicTeslaGuiContainer container, int guiX, int guiY, float partialTicks, int mouseX, int mouseY) {
                super.drawBackgroundLayer(container, guiX, guiY, partialTicks, mouseX, mouseY);
                if (this.getCurrentState() == 0) {
                    container.field_146297_k.func_110434_K().func_110577_a(ClientProxy.GUI);
                    container.drawTexturedRect(this.getLeft() - 1, this.getTop() - 1, 78, 1, 16, 16);
                } else {
                    container.field_146297_k.func_110434_K().func_110577_a(ClientProxy.GUI);
                    container.drawTexturedRect(this.getLeft() - 1, this.getTop() - 1, 78, 17, 16, 16);
                }
            }

            protected void clicked() {
                WorkingAreaElectricMachine.this.showArea = !WorkingAreaElectricMachine.this.showArea;
            }

            @NotNull
            protected List<String> getStateToolTip(int state) {
                return Collections.singletonList(state == 0 ? new TextComponentTranslation("text.industrialforegoing.button.show_area", new Object[0]).func_150254_d() : new TextComponentTranslation("text.industrialforegoing.button.hide_area", new Object[0]).func_150254_d());
            }
        });
        return list;
    }

    public abstract float work();

    protected float performWork() {
        float work = 0.0f;
        for (int i = 0; i < this.getActionsWork(); ++i) {
            float temp = this.work();
            if (temp < 0.0f) {
                return 1.0f;
            }
            if (!(temp > work)) continue;
            work = temp;
        }
        return work;
    }

    public BlockCube getWorkArea() {
        return new BlockCube(new BlockPos(this.getWorkingArea().field_72340_a, this.getWorkingArea().field_72338_b, this.getWorkingArea().field_72339_c), new BlockPos(this.getWorkingArea().field_72336_d - 1.0, this.getWorkingArea().field_72337_e - 1.0, this.getWorkingArea().field_72334_f - 1.0));
    }

    @SideOnly(value=Side.CLIENT)
    public int getWorkAreaColor() {
        return this.color;
    }

    public int getRadius() {
        return Math.min(WorkUtils.getMachineWidth(this.field_145850_b, this.field_174879_c) + 1, this.hasAddon(RangeAddonItem.class) ? this.getAddonStack(RangeAddonItem.class).func_77960_j() + 1 : 0);
    }

    public int getHeight() {
        return WorkUtils.getMachineHeight(this.field_145850_b, this.field_174879_c);
    }

    public boolean canAcceptRangeUpgrades() {
        return WorkUtils.acceptsRangeAddons(this.field_145850_b, this.field_174879_c);
    }

    public int getActionsWork() {
        return 1 + this.getRadius() / 4 * this.speedUpgradeLevel();
    }

    public List<TileEntitySpecialRenderer<TileEntity>> getRenderers() {
        List renderers = super.getRenderers();
        if (this.showArea) {
            renderers.add(WorkingAreaRenderer.INSTANCE);
        }
        return renderers;
    }

    public AxisAlignedBB getWorkingArea() {
        return WorkUtils.getMachineWorkingArea(this.field_145850_b, this.field_174879_c, this.getRadius(), this.getHeight(), this.getFacing());
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return this.getWorkingArea();
    }
}

