/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.tile.block;

import com.buuz135.industrial.book.BookCategory;
import com.buuz135.industrial.proxy.ItemRegistry;
import com.buuz135.industrial.tile.block.CustomOrientedBlock;
import com.buuz135.industrial.tile.misc.BlackHoleUnitTile;
import com.buuz135.industrial.utils.RecipeUtils;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.ndrei.teslacorelib.items.MachineCaseItem;

public class BlackHoleUnitBlock
extends CustomOrientedBlock<BlackHoleUnitTile> {
    public BlackHoleUnitBlock() {
        super("black_hole_unit", BlackHoleUnitTile.class, Material.field_151576_e, 0, 0);
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        if (world.func_175625_s(pos) instanceof BlackHoleUnitTile) {
            BlackHoleUnitTile tile = (BlackHoleUnitTile)world.func_175625_s(pos);
            ItemStack stack = new ItemStack(Item.func_150898_a((Block)this), 1);
            if (tile.getAmount() > 0) {
                if (!stack.func_77942_o()) {
                    stack.func_77982_d(new NBTTagCompound());
                }
                stack.func_77978_p().func_74768_a("amount", tile.getAmount());
                stack.func_77978_p().func_74778_a("itemstack", tile.getItemStack().func_77973_b().getRegistryName().toString());
                stack.func_77978_p().func_74768_a("meta", tile.getItemStack().func_77960_j());
                if (tile.getItemStack().func_77942_o()) {
                    stack.func_77978_p().func_74782_a("stack_nbt", (NBTBase)tile.getItemStack().func_77978_p());
                }
            }
            float f = 0.7f;
            float d0 = world.field_73012_v.nextFloat() * f + (1.0f - f) * 0.5f;
            float d1 = world.field_73012_v.nextFloat() * f + (1.0f - f) * 0.5f;
            float d2 = world.field_73012_v.nextFloat() * f + (1.0f - f) * 0.5f;
            EntityItem entityitem = new EntityItem(world, (double)((float)pos.func_177958_n() + d0), (double)((float)pos.func_177956_o() + d1), (double)((float)pos.func_177952_p() + d2), stack);
            entityitem.func_174869_p();
            if (stack.func_77942_o()) {
                entityitem.func_92059_d().func_77982_d(stack.func_77978_p().func_74737_b());
            }
            world.func_72838_d((Entity)entityitem);
        }
        world.func_175713_t(pos);
    }

    public void getDrops(NonNullList<ItemStack> drops, IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        super.func_180633_a(world, pos, state, placer, stack);
        if (stack.func_77942_o() && world.func_175625_s(pos) != null && world.func_175625_s(pos) instanceof BlackHoleUnitTile && Item.func_111206_d((String)stack.func_77978_p().func_74779_i("itemstack")) != null) {
            BlackHoleUnitTile tile = (BlackHoleUnitTile)world.func_175625_s(pos);
            if (stack.func_77978_p().func_74764_b("itemstack") && stack.func_77978_p().func_74764_b("meta")) {
                ItemStack item = new ItemStack(Item.func_111206_d((String)stack.func_77978_p().func_74779_i("itemstack")), 1, stack.func_77978_p().func_74762_e("meta"));
                if (stack.func_77978_p().func_74764_b("stack_nbt")) {
                    item.func_77982_d(stack.func_77978_p().func_74775_l("stack_nbt"));
                }
                tile.setStack(item);
            }
            if (stack.func_77978_p().func_74764_b("amount")) {
                tile.setAmount(stack.func_77978_p().func_74762_e("amount"));
            }
        }
    }

    @Override
    public List<String> getTooltip(ItemStack stack) {
        List<String> tooltip = super.getTooltip(stack);
        if (stack.func_77942_o() && Item.func_111206_d((String)stack.func_77978_p().func_74779_i("itemstack")) != null) {
            if (stack.func_77978_p().func_74764_b("itemstack") && stack.func_77978_p().func_74764_b("meta")) {
                tooltip.add(new TextComponentTranslation("text.industrialforegoing.display.item", new Object[0]).func_150260_c() + " " + new TextComponentTranslation(new ItemStack(Item.func_111206_d((String)stack.func_77978_p().func_74779_i("itemstack")), 1, stack.func_77978_p().func_74762_e("meta")).func_77977_a() + ".name", new Object[0]).func_150260_c());
            }
            if (stack.func_77978_p().func_74764_b("amount")) {
                tooltip.add(new TextComponentTranslation("text.industrialforegoing.display.amount", new Object[0]).func_150260_c() + " " + stack.func_77978_p().func_74762_e("amount"));
            }
        }
        return tooltip;
    }

    @Override
    public void createRecipe() {
        RecipeUtils.addShapedRecipe(new ItemStack((Block)this), new Object[]{"ppp", "eae", "cmc", Character.valueOf('p'), ItemRegistry.plastic, Character.valueOf('e'), Items.field_151061_bv, Character.valueOf('a'), Items.field_151079_bi, Character.valueOf('c'), "chestWood", Character.valueOf('m'), MachineCaseItem.INSTANCE});
    }

    public ItemStack getItemStack(ItemStack blackHole) {
        NBTTagCompound compound = blackHole.func_77978_p();
        ItemStack stack = ItemStack.field_190927_a;
        if (compound == null || !compound.func_74764_b("itemstack")) {
            return stack;
        }
        Item item = Item.func_111206_d((String)compound.func_74779_i("itemstack"));
        if (item != null) {
            stack = new ItemStack(item, 1, compound.func_74764_b("meta") ? compound.func_74762_e("meta") : 0);
            if (compound.func_74764_b("stack_nbt")) {
                stack.func_77982_d(compound.func_74775_l("stack_nbt"));
            }
        }
        return stack;
    }

    public int getAmount(ItemStack blackHole) {
        NBTTagCompound compound = blackHole.func_77978_p();
        int amount = 0;
        if (compound != null && compound.func_74764_b("amount")) {
            amount = compound.func_74762_e("amount");
        }
        return amount;
    }

    public void setAmount(ItemStack blackHole, int amount) {
        NBTTagCompound compound = blackHole.func_77978_p();
        if (compound != null) {
            compound.func_74768_a("amount", amount);
        }
    }

    public void setItemStack(ItemStack hole, ItemStack item) {
        if (!hole.func_77942_o()) {
            hole.func_77982_d(new NBTTagCompound());
        }
        hole.func_77978_p().func_74778_a("itemstack", item.func_77973_b().getRegistryName().toString());
        hole.func_77978_p().func_74768_a("meta", item.func_77960_j());
        if (item.func_77942_o()) {
            hole.func_77978_p().func_74782_a("stack_nbt", (NBTBase)item.func_77978_p());
        }
    }

    @Override
    public BookCategory getCategory() {
        return BookCategory.STORAGE;
    }
}

