/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.tile.misc;

import com.buuz135.industrial.proxy.client.infopiece.OreDictionaryInfoPiece;
import com.buuz135.industrial.tile.CustomColoredItemHandler;
import com.buuz135.industrial.tile.CustomSidedTileEntity;
import com.buuz135.industrial.utils.ItemStackUtils;
import java.util.Arrays;
import java.util.List;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagString;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;
import net.ndrei.teslacorelib.gui.BasicTeslaGuiContainer;
import net.ndrei.teslacorelib.gui.IGuiContainerPiece;
import net.ndrei.teslacorelib.inventory.SyncProviderLevel;
import org.jetbrains.annotations.NotNull;

public class OreDictionaryConverterTile
extends CustomSidedTileEntity {
    public static final String[] ACCEPTED_ENTRIES = new String[]{"ore", "ingot", "nugget", "gem", "dust", "block", "gear", "plate"};
    private static final String MOD_ID = "ModId";
    private static final String ORE_DICT = "OreDict";
    private ItemStackHandler filter;
    private ItemStackHandler change;
    private String modid = "";
    private String oreDict = "";

    public OreDictionaryConverterTile() {
        super(OreDictionaryConverterTile.class.getName().hashCode());
    }

    @Override
    protected void initializeInventories() {
        super.initializeInventories();
        this.filter = new ItemStackHandler(1){

            public int getSlotLimit(int slot) {
                return 1;
            }

            protected void onContentsChanged(int slot) {
                List<String> dicts;
                OreDictionaryConverterTile.this.func_70296_d();
                if (!this.getStackInSlot(0).func_190926_b() && (dicts = ItemStackUtils.getOreDictionaryEntries(this.getStackInSlot(0))).size() > 0) {
                    OreDictionaryConverterTile.this.modid = this.getStackInSlot(0).func_77973_b().getRegistryName().func_110624_b();
                    OreDictionaryConverterTile.this.oreDict = dicts.get(0);
                    OreDictionaryConverterTile.this.forceSync();
                }
            }
        };
        this.addInventory((IItemHandler)new CustomColoredItemHandler((IItemHandler)this.filter, EnumDyeColor.BLUE, "filter", 18, 25, 1, 1){

            public boolean canInsertItem(int slot, ItemStack stack) {
                return ItemStackUtils.getOreDictionaryEntries(stack).stream().anyMatch(s -> Arrays.stream(ACCEPTED_ENTRIES).anyMatch(s::startsWith));
            }

            public boolean canExtractItem(int slot) {
                return false;
            }
        });
        this.addInventoryToStorage(this.filter, "filter");
        this.change = new ItemStackHandler(9){

            protected void onContentsChanged(int slot) {
                super.onContentsChanged(slot);
                if (!this.getStackInSlot(slot).func_190926_b() && !OreDictionaryConverterTile.this.filter.getStackInSlot(0).func_77969_a(this.getStackInSlot(slot))) {
                    int size = this.getStackInSlot(slot).func_190916_E();
                    this.setStackInSlot(slot, ItemStack.field_190927_a);
                    ItemStack stack = OreDictionaryConverterTile.this.filter.getStackInSlot(0).func_77946_l();
                    stack.func_190920_e(size);
                    ItemHandlerHelper.insertItem((IItemHandler)OreDictionaryConverterTile.this.change, (ItemStack)stack, (boolean)false);
                }
            }
        };
        this.addInventory((IItemHandler)new CustomColoredItemHandler((IItemHandler)this.change, EnumDyeColor.ORANGE, "change", 18, 61, 9, 1){

            public boolean canInsertItem(int slot, ItemStack stack) {
                return !OreDictionaryConverterTile.this.filter.getStackInSlot(0).func_190926_b() && !OreDictionaryConverterTile.this.filter.getStackInSlot(0).func_77969_a(stack) && ItemStackUtils.getOreDictionaryEntries(stack).contains(OreDictionaryConverterTile.this.oreDict);
            }

            public boolean canExtractItem(int slot) {
                return true;
            }
        });
        this.registerSyncStringPart(MOD_ID, nbtTagString -> {
            this.modid = nbtTagString.func_150285_a_();
        }, () -> new NBTTagString(this.modid), SyncProviderLevel.GUI);
        this.registerSyncStringPart(ORE_DICT, nbtTagString -> {
            this.oreDict = nbtTagString.func_150285_a_();
        }, () -> new NBTTagString(this.oreDict), SyncProviderLevel.GUI);
    }

    protected void innerUpdate() {
    }

    public void func_145839_a(NBTTagCompound compound) {
        this.modid = compound.func_74779_i(MOD_ID);
        this.oreDict = compound.func_74779_i(ORE_DICT);
        super.func_145839_a(compound);
    }

    @NotNull
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        NBTTagCompound compound1 = super.func_189515_b(compound);
        compound1.func_74778_a(MOD_ID, this.modid);
        compound1.func_74778_a(ORE_DICT, this.oreDict);
        return compound1;
    }

    @NotNull
    public List<IGuiContainerPiece> getGuiContainerPieces(BasicTeslaGuiContainer<?> container) {
        List pieces = super.getGuiContainerPieces(container);
        pieces.add(new OreDictionaryInfoPiece(this, 42, 21));
        return pieces;
    }

    protected boolean supportsAddons() {
        return false;
    }

    protected boolean getShowPauseDrawerPiece() {
        return false;
    }

    protected boolean getShowRedstoneControlPiece() {
        return false;
    }

    public ItemStackHandler getFilter() {
        return this.filter;
    }

    public String getModid() {
        return this.modid;
    }

    public String getOreDict() {
        return this.oreDict;
    }
}

