/*
 * Decompiled with CFR 0.152.
 */
package omtteam.omlib.handler;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.command.ICommandSender;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraftforge.common.DimensionManager;
import omtteam.omlib.handler.OMLibNetworkingHandler;
import omtteam.omlib.network.messages.MessageSetSharePlayerList;
import omtteam.omlib.util.Player;

public class OwnerShareHandler
implements Serializable {
    private static OwnerShareHandler instance;
    private HashMap<Player, ArrayList<Player>> ownerShareMap = new HashMap();

    private OwnerShareHandler() {
    }

    public static OwnerShareHandler getInstance() {
        if (instance == null) {
            instance = new OwnerShareHandler();
        }
        return instance;
    }

    static void saveToDisk() {
        File saveRoot = DimensionManager.getCurrentSaveRootDirectory();
        if (saveRoot != null) {
            Path path = Paths.get(saveRoot.toString() + "/omlib/", new String[0]);
            Path fullpath = Paths.get(saveRoot.toString() + "/omlib/OwnerShare.sav", new String[0]);
            try {
                if (Files.notExists(path, new LinkOption[0]) && !path.toFile().mkdir()) {
                    throw new Exception("Failed to create dir");
                }
                if (OwnerShareHandler.getInstance() != null && OwnerShareHandler.getInstance().getOwnerShareMap() != null) {
                    FileOutputStream saveFile = new FileOutputStream(fullpath.toFile());
                    ObjectOutputStream save = new ObjectOutputStream(saveFile);
                    save.writeObject(OwnerShareHandler.getInstance().getOwnerShareMap());
                    save.close();
                    saveFile.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                try {
                    Files.deleteIfExists(fullpath);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
    }

    static void loadFromDisk() {
        HashMap input = new HashMap();
        try {
            Path fullpath = Paths.get(DimensionManager.getCurrentSaveRootDirectory().toString() + "/omlib/OwnerShare.sav", new String[0]);
            FileInputStream saveFile = new FileInputStream(fullpath.toFile());
            ObjectInputStream save = new ObjectInputStream(saveFile);
            Object object = save.readObject();
            if (object instanceof HashMap) {
                input = (HashMap)object;
            }
            OwnerShareHandler.getInstance().setOwnerShareMap(input);
            save.close();
            saveFile.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public HashMap<Player, ArrayList<Player>> getOwnerShareMap() {
        return this.ownerShareMap;
    }

    public void setOwnerShareMap(@Nullable HashMap<Player, ArrayList<Player>> ownerShareMap) {
        if (ownerShareMap != null) {
            this.ownerShareMap = ownerShareMap;
        }
    }

    @Nullable
    public Map.Entry<Player, ArrayList<Player>> getEntryFromName(String name) {
        for (Map.Entry<Player, ArrayList<Player>> entry : this.ownerShareMap.entrySet()) {
            if (!entry.getKey().getName().equals(name)) continue;
            return entry;
        }
        return null;
    }

    @Nullable
    private Map.Entry<Player, ArrayList<Player>> getEntry(Player player) {
        for (Map.Entry<Player, ArrayList<Player>> entry : this.ownerShareMap.entrySet()) {
            if (!entry.getKey().equals(player)) continue;
            return entry;
        }
        return null;
    }

    public void addSharePlayer(Player owner, Player sharePlayer, @Nullable ICommandSender sender) {
        Map.Entry<Player, ArrayList<Player>> entryFound = null;
        if (owner.equals(sharePlayer)) {
            return;
        }
        for (Map.Entry<Player, ArrayList<Player>> entry : this.ownerShareMap.entrySet()) {
            if (!entry.getKey().equals(owner)) continue;
            entryFound = entry;
        }
        if (entryFound == null) {
            ArrayList<Player> list = new ArrayList<Player>();
            list.add(sharePlayer);
            if (sender != null) {
                sender.func_145747_a((ITextComponent)new TextComponentString("Added player " + sharePlayer.getName() + " to your Share List!"));
            }
            this.ownerShareMap.put(owner, list);
        } else if (!((ArrayList)entryFound.getValue()).contains(sharePlayer)) {
            ((ArrayList)entryFound.getValue()).add(sharePlayer);
            if (sender != null) {
                sender.func_145747_a((ITextComponent)new TextComponentString("Added player " + sharePlayer.getName() + " to your Share List!"));
            }
        }
        OMLibNetworkingHandler.sendMessageToAllPlayers(new MessageSetSharePlayerList(this));
    }

    public void removeSharePlayer(Player owner, Player sharePlayer, @Nullable ICommandSender sender) {
        Map.Entry<Player, ArrayList<Player>> entryFound = null;
        if (owner.equals(sharePlayer)) {
            if (sender != null) {
                sender.func_145747_a((ITextComponent)new TextComponentString("You cannot add/remove yourself to/from your Share List!"));
            }
            return;
        }
        for (Map.Entry<Player, ArrayList<Player>> entry : this.ownerShareMap.entrySet()) {
            if (!entry.getKey().equals(owner)) continue;
            entryFound = entry;
        }
        if (entryFound != null) {
            int sizeBefore = ((ArrayList)entryFound.getValue()).size();
            Predicate<Player> predicate = p -> p.equals(sharePlayer);
            entryFound.getValue().removeIf(predicate);
            if (sender != null) {
                if (entryFound.getValue().size() < sizeBefore) {
                    sender.func_145747_a((ITextComponent)new TextComponentString("Removed player " + sharePlayer.getName() + " from your Share List!"));
                } else {
                    sender.func_145747_a((ITextComponent)new TextComponentString("Could not remove player " + sharePlayer.getName() + " from your Share List!"));
                }
            }
        } else if (sender != null) {
            sender.func_145747_a((ITextComponent)new TextComponentString("Could not remove player " + sharePlayer.getName() + " from your Share List!"));
        }
        OMLibNetworkingHandler.sendMessageToAllPlayers(new MessageSetSharePlayerList(this));
    }

    public void printSharePlayers(Player owner, ICommandSender sender) {
        StringBuilder playerList = new StringBuilder();
        Map.Entry<Player, ArrayList<Player>> entryFound = null;
        for (Map.Entry<Player, ArrayList<Player>> entry : this.ownerShareMap.entrySet()) {
            if (!entry.getKey().equals(owner)) continue;
            entryFound = entry;
        }
        if (entryFound != null) {
            ArrayList list = (ArrayList)entryFound.getValue();
            for (int i = 0; i < list.size(); ++i) {
                Player player = (Player)list.get(i);
                if (i < list.size() - 1) {
                    playerList.append(player.getName());
                    playerList.append(", ");
                    continue;
                }
                playerList.append(player.getName());
            }
        }
        sender.func_145747_a((ITextComponent)new TextComponentString("Players on your share list: " + playerList.toString()));
    }

    public boolean isPlayerSharedOwner(Player owner, Player shareCheck) {
        Map.Entry<Player, ArrayList<Player>> entry = this.getEntry(owner);
        if (entry != null) {
            for (Player player : entry.getValue()) {
                if (!player.equals(shareCheck)) continue;
                return true;
            }
        }
        return false;
    }
}

