/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block.subtile.functional;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityItemFrame;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import vazkii.botania.api.corporea.InvWithLocation;
import vazkii.botania.api.lexicon.LexiconEntry;
import vazkii.botania.api.mana.IManaItem;
import vazkii.botania.api.subtile.RadiusDescriptor;
import vazkii.botania.api.subtile.SubTileFunctional;
import vazkii.botania.common.block.subtile.functional.SubTileSpectranthemum;
import vazkii.botania.common.core.helper.InventoryHelper;
import vazkii.botania.common.lexicon.LexiconData;

public class SubTileHopperhock
extends SubTileFunctional {
    private static final String TAG_FILTER_TYPE = "filterType";
    private static final int RANGE_MANA = 10;
    private static final int RANGE = 6;
    private static final int RANGE_MANA_MINI = 2;
    private static final int RANGE_MINI = 1;
    private int filterType = 0;

    @Override
    public void onUpdate() {
        super.onUpdate();
        if (this.supertile.func_145831_w().field_72995_K || this.redstoneSignal > 0) {
            return;
        }
        boolean pulledAny = false;
        int range = this.getRange();
        BlockPos pos = this.supertile.func_174877_v();
        List items = this.supertile.func_145831_w().func_72872_a(EntityItem.class, new AxisAlignedBB(pos.func_177982_a(-range, -range, -range), pos.func_177982_a(range + 1, range + 1, range + 1)));
        int slowdown = this.getSlowdownFactor();
        for (EntityItem item : items) {
            if (item.field_70292_b < 60 + slowdown || item.field_70292_b >= 105 && item.field_70292_b < 110 || item.field_70128_L || item.func_92059_d().func_190926_b()) continue;
            ItemStack stack = item.func_92059_d();
            IItemHandler invToPutItemIn = null;
            boolean priorityInv = false;
            int amountToPutIn = 0;
            for (EnumFacing dir : EnumFacing.field_82609_l) {
                boolean priority;
                BlockPos pos_ = pos.func_177972_a(dir);
                InvWithLocation inv = InventoryHelper.getInventoryWithLocation(this.supertile.func_145831_w(), pos_, dir);
                if (inv == null) continue;
                List<ItemStack> filter = this.getFilterForInventory(pos_, true);
                boolean canAccept = this.canAcceptItem(stack, filter, this.filterType);
                ItemStack simulate = ItemHandlerHelper.insertItem((IItemHandler)inv.handler, (ItemStack)stack, (boolean)true);
                int availablePut = stack.func_190916_E() - simulate.func_190916_E();
                if (!(canAccept &= availablePut > 0)) continue;
                boolean bl = priority = !filter.isEmpty();
                if (priorityInv && !priority) continue;
                invToPutItemIn = inv.handler;
                priorityInv = priority;
                amountToPutIn = availablePut;
            }
            if (invToPutItemIn == null || item.field_70128_L) continue;
            SubTileSpectranthemum.spawnExplosionParticles((Entity)item, 3);
            ItemHandlerHelper.insertItem(invToPutItemIn, (ItemStack)stack.func_77979_a(amountToPutIn), (boolean)false);
            item.func_92058_a(stack);
            pulledAny = true;
        }
        if (pulledAny && this.mana > 0) {
            --this.mana;
        }
    }

    public boolean canAcceptItem(ItemStack stack, List<ItemStack> filter, int filterType) {
        if (stack.func_190926_b()) {
            return false;
        }
        if (filter.isEmpty()) {
            return true;
        }
        switch (filterType) {
            case 0: {
                boolean anyFilter = false;
                for (ItemStack filterEntry : filter) {
                    if (filterEntry == null) continue;
                    anyFilter = true;
                    boolean itemEqual = stack.func_77973_b() == filterEntry.func_77973_b();
                    boolean damageEqual = stack.func_77952_i() == filterEntry.func_77952_i();
                    boolean nbtEqual = ItemStack.func_77970_a((ItemStack)filterEntry, (ItemStack)stack);
                    if (itemEqual && damageEqual && nbtEqual) {
                        return true;
                    }
                    if (!stack.func_77981_g() && stack.func_77984_f() && stack.func_77976_d() == 1 && itemEqual && nbtEqual) {
                        return true;
                    }
                    if (!(stack.func_77973_b() instanceof IManaItem) || !itemEqual) continue;
                    return true;
                }
                return !anyFilter;
            }
            case 1: {
                return !this.canAcceptItem(stack, filter, 0);
            }
        }
        return true;
    }

    public List<ItemStack> getFilterForInventory(BlockPos pos, boolean recursiveForDoubleChests) {
        ArrayList<ItemStack> filter = new ArrayList<ItemStack>();
        if (recursiveForDoubleChests) {
            TileEntity tileEntity = this.supertile.func_145831_w().func_175625_s(pos);
            Block chest = this.supertile.func_145831_w().func_180495_p(pos).func_177230_c();
            if (tileEntity instanceof TileEntityChest) {
                for (EnumFacing dir : EnumFacing.field_176754_o) {
                    if (this.supertile.func_145831_w().func_180495_p(pos.func_177972_a(dir)).func_177230_c() != chest) continue;
                    filter.addAll(this.getFilterForInventory(pos.func_177972_a(dir), false));
                    break;
                }
            }
        }
        for (EnumFacing dir : EnumFacing.field_176754_o) {
            AxisAlignedBB aabb = new AxisAlignedBB(pos.func_177972_a(dir), pos.func_177972_a(dir).func_177982_a(1, 1, 1));
            List frames = this.supertile.func_145831_w().func_72872_a(EntityItemFrame.class, aabb);
            for (EntityItemFrame frame : frames) {
                if (frame.field_174860_b != dir) continue;
                filter.add(frame.func_82335_i());
            }
        }
        return filter;
    }

    @Override
    public boolean acceptsRedstone() {
        return true;
    }

    @Override
    public boolean onWanded(EntityPlayer player, ItemStack wand) {
        if (player == null) {
            return false;
        }
        if (player.func_70093_af()) {
            this.filterType = this.filterType == 2 ? 0 : this.filterType + 1;
            this.sync();
            return true;
        }
        return super.onWanded(player, wand);
    }

    @Override
    public RadiusDescriptor getRadius() {
        return new RadiusDescriptor.Square(this.toBlockPos(), this.getRange());
    }

    public int getRange() {
        return this.mana > 0 ? 10 : 6;
    }

    @Override
    public void writeToPacketNBT(NBTTagCompound cmp) {
        super.writeToPacketNBT(cmp);
        cmp.func_74768_a(TAG_FILTER_TYPE, this.filterType);
    }

    @Override
    public void readFromPacketNBT(NBTTagCompound cmp) {
        super.readFromPacketNBT(cmp);
        this.filterType = cmp.func_74762_e(TAG_FILTER_TYPE);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderHUD(Minecraft mc, ScaledResolution res) {
        super.renderHUD(mc, res);
        int color = this.getColor();
        String filter = I18n.func_135052_a((String)("botaniamisc.filter" + this.filterType), (Object[])new Object[0]);
        GlStateManager.func_179147_l();
        GlStateManager.func_179112_b((int)770, (int)771);
        int x = res.func_78326_a() / 2 - mc.field_71466_p.func_78256_a(filter) / 2;
        int y = res.func_78328_b() / 2 + 30;
        mc.field_71466_p.func_175063_a(filter, (float)x, (float)y, color);
        GlStateManager.func_179084_k();
    }

    @Override
    public LexiconEntry getEntry() {
        return LexiconData.hopperhock;
    }

    @Override
    public int getMaxMana() {
        return 20;
    }

    @Override
    public int getColor() {
        return 0x3F3F3F;
    }

    public static class Mini
    extends SubTileHopperhock {
        @Override
        public int getRange() {
            return this.mana > 0 ? 2 : 1;
        }
    }
}

