/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item.block;

import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.api.lexicon.IRecipeKeyProvider;
import vazkii.botania.api.subtile.SubTileEntity;
import vazkii.botania.api.subtile.SubTileFunctional;
import vazkii.botania.api.subtile.SubTileGenerating;
import vazkii.botania.api.subtile.signature.SubTileSignature;
import vazkii.botania.common.block.ModBlocks;
import vazkii.botania.common.block.tile.TileSpecialFlower;
import vazkii.botania.common.core.handler.ConfigHandler;
import vazkii.botania.common.core.helper.ItemNBTHelper;
import vazkii.botania.common.core.helper.PlayerHelper;
import vazkii.botania.common.item.block.ItemBlockMod;

@Mod.EventBusSubscriber(modid="botania")
public class ItemBlockSpecialFlower
extends ItemBlockMod
implements IRecipeKeyProvider {
    public ItemBlockSpecialFlower(Block block1) {
        super(block1);
        this.func_77627_a(true);
    }

    public boolean placeBlockAt(@Nonnull ItemStack stack, @Nonnull EntityPlayer player, World world, @Nonnull BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, @Nonnull IBlockState newState) {
        boolean placed = super.placeBlockAt(stack, player, world, pos, side, hitX, hitY, hitZ, newState);
        if (placed) {
            String type = ItemBlockSpecialFlower.getType(stack);
            TileEntity te = world.func_175625_s(pos);
            if (te instanceof TileSpecialFlower) {
                TileSpecialFlower tile = (TileSpecialFlower)te;
                tile.setSubTile(type);
                tile.onBlockAdded(world, pos, newState);
                tile.onBlockPlacedBy(world, pos, newState, (EntityLivingBase)player, stack);
                if (!world.field_72995_K) {
                    world.func_184138_a(pos, world.func_180495_p(pos), world.func_180495_p(pos), 8);
                }
            }
        }
        return placed;
    }

    @Nonnull
    public String func_77667_c(ItemStack stack) {
        return BotaniaAPI.getSignatureForName(ItemBlockSpecialFlower.getType(stack)).getUnlocalizedNameForStack(stack);
    }

    @Override
    @Nonnull
    public String func_77657_g(@Nonnull ItemStack par1ItemStack) {
        return this.getUnlocalizedNameInefficiently_(par1ItemStack);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(@Nonnull ItemStack par1ItemStack, World world, @Nonnull List<String> stacks, @Nonnull ITooltipFlag flag) {
        String refUnlocalized;
        String refLocalized;
        String type = ItemBlockSpecialFlower.getType(par1ItemStack);
        SubTileSignature sig = BotaniaAPI.getSignatureForName(type);
        sig.addTooltip(par1ItemStack, world, stacks);
        if (ConfigHandler.referencesEnabled && !(refLocalized = I18n.func_135052_a((String)(refUnlocalized = sig.getUnlocalizedLoreTextForStack(par1ItemStack)), (Object[])new Object[0])).equals(refUnlocalized)) {
            stacks.add(TextFormatting.ITALIC + refLocalized);
        }
    }

    public String getCreatorModId(ItemStack itemStack) {
        String mod = BotaniaAPI.subTileMods.get(ItemBlockSpecialFlower.getType(itemStack));
        if (mod != null) {
            return mod;
        }
        return "botania";
    }

    public static String getType(ItemStack stack) {
        return stack.func_77942_o() ? ItemNBTHelper.getString(stack, "type", "") : "";
    }

    public static ItemStack ofType(String type) {
        return ItemBlockSpecialFlower.ofType(new ItemStack(ModBlocks.specialFlower), type);
    }

    public static ItemStack ofType(ItemStack stack, String type) {
        ItemNBTHelper.setString(stack, "type", type);
        return stack;
    }

    @Override
    public String getKey(ItemStack stack) {
        return "flower." + ItemBlockSpecialFlower.getType(stack);
    }

    @SubscribeEvent
    public static void onItemPickup(EntityItemPickupEvent evt) {
        if (evt.getItem().func_92059_d().func_77973_b() == Item.func_150898_a((Block)ModBlocks.specialFlower)) {
            String type = ItemBlockSpecialFlower.getType(evt.getItem().func_92059_d());
            Class<? extends SubTileEntity> subtile = BotaniaAPI.getSubTileMapping(type);
            if (SubTileGenerating.class.isAssignableFrom(subtile)) {
                PlayerHelper.grantCriterion((EntityPlayerMP)evt.getEntityPlayer(), new ResourceLocation("botania", "main/generating_flower"), "code_triggered");
            }
            if (SubTileFunctional.class.isAssignableFrom(subtile)) {
                PlayerHelper.grantCriterion((EntityPlayerMP)evt.getEntityPlayer(), new ResourceLocation("botania", "main/functional_flower"), "code_triggered");
            }
            if ("".equals(type)) {
                PlayerHelper.grantCriterion((EntityPlayerMP)evt.getEntityPlayer(), new ResourceLocation("botania", "challenge/null_flower"), "code_triggered");
            }
        }
    }
}

