/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsdim.blocks.workbench;

import java.awt.Rectangle;
import java.util.ArrayList;
import mcjty.lib.base.ModBase;
import mcjty.lib.base.StyleConfig;
import mcjty.lib.gui.GenericGuiContainer;
import mcjty.lib.gui.Window;
import mcjty.lib.gui.events.SelectionEvent;
import mcjty.lib.gui.layout.HorizontalAlignment;
import mcjty.lib.gui.layout.Layout;
import mcjty.lib.gui.layout.LayoutHint;
import mcjty.lib.gui.layout.PositionalLayout;
import mcjty.lib.gui.widgets.AbstractContainerWidget;
import mcjty.lib.gui.widgets.AbstractWidget;
import mcjty.lib.gui.widgets.BlockRender;
import mcjty.lib.gui.widgets.EnergyBar;
import mcjty.lib.gui.widgets.Label;
import mcjty.lib.gui.widgets.Panel;
import mcjty.lib.gui.widgets.Slider;
import mcjty.lib.gui.widgets.TextField;
import mcjty.lib.gui.widgets.ToggleButton;
import mcjty.lib.gui.widgets.Widget;
import mcjty.lib.gui.widgets.WidgetList;
import mcjty.lib.tileentity.GenericEnergyStorageTileEntity;
import mcjty.lib.tileentity.GenericTileEntity;
import mcjty.lib.typed.TypedMap;
import mcjty.rftoolsdim.RFToolsDim;
import mcjty.rftoolsdim.blocks.workbench.DimletWorkbenchContainer;
import mcjty.rftoolsdim.blocks.workbench.DimletWorkbenchTileEntity;
import mcjty.rftoolsdim.config.Settings;
import mcjty.rftoolsdim.dimensions.dimlets.DimletKey;
import mcjty.rftoolsdim.dimensions.dimlets.KnownDimletConfiguration;
import mcjty.rftoolsdim.dimensions.dimlets.types.DimletCraftingTools;
import mcjty.rftoolsdim.items.ModItems;
import mcjty.rftoolsdim.network.RFToolsDimMessages;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.inventory.Container;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;

public class GuiDimletWorkbench
extends GenericGuiContainer<DimletWorkbenchTileEntity> {
    public static final int WORKBENCH_WIDTH = 256;
    public static final int WORKBENCH_HEIGHT = 244;
    private EnergyBar energyBar;
    private ToggleButton extractButton;
    private TextField searchBar;
    private WidgetList itemList;
    private Slider slider;
    private boolean listDirty = true;
    private static final ResourceLocation iconLocation = new ResourceLocation("rftoolsdim", "textures/gui/dimletworkbench.png");

    public GuiDimletWorkbench(DimletWorkbenchTileEntity dimletWorkbenchTileEntity, DimletWorkbenchContainer container) {
        super((ModBase)RFToolsDim.instance, RFToolsDimMessages.INSTANCE, (GenericTileEntity)dimletWorkbenchTileEntity, (Container)container, RFToolsDim.GUI_MANUAL_DIMENSION, "create");
        this.field_146999_f = 256;
        this.field_147000_g = 244;
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.searchBar = ((TextField)new TextField(this.field_146297_k, (Gui)this).setLayoutHint((LayoutHint)new PositionalLayout.PositionalHint(120, 7, 128, 16))).addTextEvent((widget, string) -> {
            this.itemList.setSelected(-1);
            this.listDirty = true;
        });
        this.itemList = ((WidgetList)((WidgetList)new WidgetList(this.field_146297_k, (Gui)this).setName("items")).setLayoutHint((LayoutHint)new PositionalLayout.PositionalHint(120, 25, 118, 133))).setLeftMargin(0).setRowheight(-1).addSelectionEvent(new SelectionEvent(){

            public void select(Widget widget, int i) {
            }

            public void doubleClick(Widget widget, int i) {
                EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
                if (player.func_184812_l_() && (Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54))) {
                    GuiDimletWorkbench.this.cheatDimlet();
                } else {
                    GuiDimletWorkbench.this.suggestParts();
                }
            }
        });
        this.slider = ((Slider)((Slider)new Slider(this.field_146297_k, (Gui)this).setLayoutHint((LayoutHint)new PositionalLayout.PositionalHint(239, 25, 9, 133))).setDesiredWidth(11)).setVertical().setScrollableName("items");
        long maxEnergyStored = ((DimletWorkbenchTileEntity)this.tileEntity).getCapacity();
        this.energyBar = ((EnergyBar)new EnergyBar(this.field_146297_k, (Gui)this).setVertical().setMaxValue(maxEnergyStored).setLayoutHint((LayoutHint)new PositionalLayout.PositionalHint(88, 9, 30, 10))).setShowText(false).setHorizontal();
        this.energyBar.setValue(GenericEnergyStorageTileEntity.getCurrentRF());
        this.extractButton = (ToggleButton)((ToggleButton)((ToggleButton)((ToggleButton)new ToggleButton(this.field_146297_k, (Gui)this).setName("extract")).setText("Extract")).setLayoutHint((LayoutHint)new PositionalLayout.PositionalHint(30, 7, 56, 14))).setCheckMarker(true).setTooltips(new String[]{"If on dimlets will be reconstructed into parts"});
        Panel toplevel = (Panel)((Panel)((Panel)((Panel)((Panel)((Panel)new Panel(this.field_146297_k, (Gui)this).setBackground(iconLocation)).setLayout((Layout)new PositionalLayout()).addChild((Widget)this.extractButton)).addChild((Widget)this.energyBar)).addChild((Widget)this.itemList)).addChild((Widget)this.slider)).addChild((Widget)this.searchBar);
        toplevel.setBounds(new Rectangle(this.field_147003_i, this.field_147009_r, this.field_146999_f, this.field_147000_g));
        this.listDirty = true;
        this.window = new Window((GuiScreen)this, (AbstractContainerWidget)toplevel);
        this.window.bind(RFToolsDimMessages.INSTANCE, "extract", this.tileEntity, DimletWorkbenchTileEntity.VALUE_EXTRACT.getName());
    }

    private void cheatDimlet() {
        int selected = this.itemList.getSelected();
        if (selected == -1) {
            return;
        }
        Widget widget = this.itemList.getChild(selected);
        Object userObject = widget.getUserObject();
        if (userObject instanceof DimletKey) {
            DimletKey key = (DimletKey)userObject;
            this.sendServerCommand(RFToolsDimMessages.INSTANCE, "workbench.cheatDimlet", TypedMap.builder().put(DimletWorkbenchTileEntity.PARAM_TYPE, (Object)key.getType().dimletType.getName()).put(DimletWorkbenchTileEntity.PARAM_ID, (Object)key.getId()).build());
        }
    }

    private void suggestParts() {
        int selected = this.itemList.getSelected();
        if (selected == -1) {
            return;
        }
        Widget widget = this.itemList.getChild(selected);
        Object userObject = widget.getUserObject();
        if (userObject instanceof DimletKey) {
            DimletKey key = (DimletKey)userObject;
            this.sendServerCommand(RFToolsDimMessages.INSTANCE, "workbench.suggestParts", TypedMap.builder().put(DimletWorkbenchTileEntity.PARAM_TYPE, (Object)key.getType().dimletType.getName()).put(DimletWorkbenchTileEntity.PARAM_ID, (Object)key.getId()).build());
        }
    }

    private void updateList() {
        if (!this.listDirty) {
            return;
        }
        this.listDirty = false;
        this.itemList.removeChildren();
        String filter = this.searchBar.getText().toLowerCase();
        KnownDimletConfiguration.getKnownDimlets().keySet().stream().filter(key -> this.dimletMatches(filter, (DimletKey)key)).sorted().forEachOrdered(this::addItemToList);
        if (this.itemList.getFirstSelected() >= this.itemList.getChildCount()) {
            this.itemList.setFirstSelected(0);
        }
    }

    private boolean dimletMatches(String filter, DimletKey key) {
        return KnownDimletConfiguration.getDisplayName(key).toLowerCase().contains(filter) || key.getType().dimletType.getName().toLowerCase().contains(filter);
    }

    private void addItemToList(DimletKey key) {
        Panel panel = (Panel)((Panel)new Panel(this.field_146297_k, (Gui)this).setLayout((Layout)new PositionalLayout()).setDesiredWidth(116)).setDesiredHeight(16);
        panel.setUserObject((Object)key);
        this.itemList.addChild((Widget)panel);
        BlockRender blockRender = (BlockRender)((BlockRender)new BlockRender(this.field_146297_k, (Gui)this).setRenderItem((Object)KnownDimletConfiguration.getDimletStack(key)).setLayoutHint((LayoutHint)new PositionalLayout.PositionalHint(1, 0, 16, 16))).setUserObject((Object)key);
        panel.addChild((Widget)blockRender);
        String displayName = KnownDimletConfiguration.getDisplayName(key);
        AbstractWidget label = ((Label)((Label)((Label)((Label)new Label(this.field_146297_k, (Gui)this).setText(displayName)).setColor(StyleConfig.colorTextInListNormal)).setHorizontalAlignment(HorizontalAlignment.ALIGN_LEFT)).setLayoutHint((LayoutHint)new PositionalLayout.PositionalHint(20, 0, 95, 16))).setUserObject((Object)key);
        panel.addChild((Widget)label);
    }

    protected void func_146976_a(float v, int i, int i2) {
        int extracting = ((DimletWorkbenchTileEntity)this.tileEntity).getExtracting();
        if (extracting == 0) {
            this.extractButton.setText("Extract");
            this.extractButton.setEnabled(true);
        } else {
            switch (extracting % 4) {
                case 0: {
                    this.extractButton.setText(".");
                    break;
                }
                case 1: {
                    this.extractButton.setText("..");
                    break;
                }
                case 2: {
                    this.extractButton.setText("...");
                    break;
                }
                case 3: {
                    this.extractButton.setText("....");
                }
            }
            this.extractButton.setEnabled(false);
        }
        this.updateList();
        this.setDimletTooltip();
        this.drawWindow();
        this.energyBar.setValue(GenericEnergyStorageTileEntity.getCurrentRF());
        ((DimletWorkbenchTileEntity)this.tileEntity).requestRfFromServer("rftoolsdim");
        ((DimletWorkbenchTileEntity)this.tileEntity).requestExtractingFromServer();
    }

    private void setDimletTooltip() {
        Object userObject;
        this.itemList.setTooltips(new String[]{"All known dimlets"});
        int x = Mouse.getEventX() * this.field_146294_l / this.field_146297_k.field_71443_c;
        int y = this.field_146295_m - Mouse.getEventY() * this.field_146295_m / this.field_146297_k.field_71440_d - 1;
        Widget widget = this.window.getToplevel().getWidgetAtPosition(x, y);
        if (widget != null && !(widget instanceof BlockRender) && (userObject = widget.getUserObject()) instanceof DimletKey) {
            DimletKey key = (DimletKey)userObject;
            Settings settings = KnownDimletConfiguration.getSettings(key);
            int rarity = settings.getRarity();
            int level = DimletCraftingTools.calculateItemLevelFromRarity(rarity);
            ItemStack base = new ItemStack((Item)ModItems.dimletBaseItem, 1);
            ItemStack ctrl = new ItemStack((Item)ModItems.dimletControlCircuitItem, 1, rarity);
            ItemStack energy = new ItemStack((Item)ModItems.dimletEnergyModuleItem, 1, level);
            ItemStack memory = new ItemStack((Item)ModItems.dimletMemoryUnitItem, 1, level);
            ItemStack typectrl = new ItemStack((Item)ModItems.dimletTypeControllerItem, 1, key.getType().ordinal());
            ItemStack essence = key.getType().dimletType.getDefaultEssence(key);
            ArrayList<String> tooltips = new ArrayList<String>();
            if (Minecraft.func_71410_x().field_71439_g.func_184812_l_()) {
                tooltips.add(TextFormatting.RED + "Shift-Double-Click to cheat");
            }
            tooltips.add("Type: " + key.getType().dimletType.getName());
            tooltips.add("Name: " + GuiDimletWorkbench.escapeString((String)KnownDimletConfiguration.getDisplayName(key)));
            tooltips.add("Key: " + GuiDimletWorkbench.escapeString((String)key.getId()));
            tooltips.add("Rarity: " + settings.getRarity());
            tooltips.add("@0@1@2");
            tooltips.add("@3@4@5");
            if (essence.func_190926_b()) {
                tooltips.add(TextFormatting.RED + "(currently not craftable)");
            }
            widget.setTooltips(tooltips.toArray(new String[tooltips.size()]));
            widget.setTooltipItems(new ItemStack[]{base, ctrl, energy, memory, typectrl, essence});
        }
    }
}

