/*
 * Decompiled with CFR 0.152.
 */
package sonar.calculator.mod;

import com.google.common.primitives.Floats;
import java.io.File;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import net.minecraftforge.common.util.EnumHelper;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import sonar.calculator.mod.Calculator;

public class CalculatorConfig
extends Calculator {
    public static boolean beamEffect = false;
    public static boolean enableWaila;
    public static boolean enableGrenades;
    public static boolean enableToolModels;
    public static Property atomicblackList;
    public static Property blocksblackList;
    public static Property itemsblackList;
    public static final int BASIC_DEFAULT_TRANSFER_RATE = 400;
    public static final int SCIENTIFIC_TIER_DEFAULT_TRANSFER_RATE = 3200;
    public static final int ATOMIC_TIER_DEFAULT_TRANSFER_RATE = 12800;
    public static final int FLAWLESS_TIER_DEFAULT_TRANSFER_RATE = 64000;
    public static int CALCULATOR_STORAGE;
    public static int CRAFTING_CALCULATOR_STORAGE;
    public static int SCIENTIFIC_CALCULATOR_STORAGE;
    public static int TERRAIN_MODULE_STORAGE;
    public static int TERRAIN_MODULE_USAGE;
    public static int ADVANCED_TERRAIN_MODULE_STORAGE;
    public static int ADVANCED_TERRAIN_MODULE_USAGE;
    public static int WARP_MODULE_STORAGE;
    public static int JUMP_MODULE_STORAGE;
    public static int ENERGY_MODULE_STORAGE;
    public static int ENDER_PEARL_MODULE_USAGE;
    public static int GRENADE_MODULE_USAGE;
    public static int HEALTH_MODULE_CAPACITY;
    public static int HUNGER_MODULE_CAPACITY;
    public static int NUTRITION_MODULE_HEALTH_CAPACITY;
    public static int NUTRITION_MODULE_HUNGER_CAPACITY;
    public static int POWER_CUBE_STORAGE;
    public static int POWER_CUBE_TRANSFER_RATE;
    public static int POWER_CUBE_CHARGING_RATE;
    public static int ADVANCED_POWER_CUBE_STORAGE;
    public static int ADVANCED_POWER_CUBE_TRANSFER_RATE;
    public static int ADVANCED_POWER_CUBE_CHARGING_RATE;
    public static int CREATIVE_POWER_CUBE_TRANSFER_RATE;
    public static int HAND_CRANK_STORAGE;
    public static int HAND_CRANK_TRANSFER_RATE;
    public static int HAND_CRANK_PER_TICK;
    public static int STARCH_EXTRACTOR_STORAGE;
    public static int STARCH_EXTRACTOR_TRANSFER_RATE;
    public static int STARCH_EXTRACTOR_GENERATOR_CAPACITY;
    public static int STARCH_EXTRACTOR_GENERATOR_REQUIRED;
    public static int STARCH_EXTRACTOR_PER_TICK;
    public static int REDSTONE_EXTRACTOR_STORAGE;
    public static int REDSTONE_EXTRACTOR_TRANSFER_RATE;
    public static int REDSTONE_EXTRACTOR_GENERATOR_CAPACITY;
    public static int REDSTONE_EXTRACTOR_GENERATOR_REQUIRED;
    public static int REDSTONE_EXTRACTOR_PER_TICK;
    public static int GLOWSTONE_EXTRACTOR_STORAGE;
    public static int GLOWSTONE_EXTRACTOR_TRANSFER_RATE;
    public static int GLOWSTONE_EXTRACTOR_GENERATOR_CAPACITY;
    public static int GLOWSTONE_EXTRACTOR_GENERATOR_REQUIRED;
    public static int GLOWSTONE_EXTRACTOR_PER_TICK;
    public static int CONDUCTOR_MAST_STORAGE;
    public static int CONDUCTOR_MAST_TRANSFER_RATE;
    public static int CONDUCTOR_MAST_CHARGING_RATE;
    public static int CONDUCTOR_MAST_PER_TICK;
    public static int CONDUCTOR_MAST_SPEED;
    public static int WEATHER_STATION_PER_TICK;
    public static int CALCULATOR_LOCATOR_STORAGE;
    public static int CALCULATOR_LOCATOR_TRANSFER_RATE;
    public static int CALCULATOR_LOCATOR_CHARGING_RATE;
    public static float CALCULATOR_LOCATOR_MULTIPLIER;
    public static boolean CALCULATOR_LOCATOR_CAN_CHANGE_TIME;
    public static int FLAWLESS_GREENHOUSE_STORAGE;
    public static int FLAWLESS_GREENHOUSE_TRANSFER_RATE;
    public static int ADVANCED_GREENHOUSE_STORAGE;
    public static int ADVANCED_GREENHOUSE_TRANSFER_RATE;
    public static int BASIC_GREENHOUSE_STORAGE;
    public static int BASIC_GREENHOUSE_TRANSFER_RATE;
    public static int C02_GENERATOR_STORAGE;
    public static int C02_GENERATOR_TRANSFER_RATE;
    public static int GROWTH_ENERGY_USAGE;
    public static int BUILD_ENERGY_USAGE;
    public static int PLANTING_ENERGY_USAGE;
    public static int FARMLAND_GENERATION_USAGE;
    public static int WATER_GENERATION_USAGE;
    public static int SCARECROW_TICK_RATE;
    public static int SCARECROW_RANGE;
    public static int WEATHER_CONTROLLER_STORAGE;
    public static int WEATHER_CONTROLLER_TRANSFER_RATE;
    public static int WEATHER_CONTROLLER_USAGE;
    public static int ATOMIC_MULTIPLIER_STORAGE;
    public static int ATOMIC_MULTIPLIER_TRANSFER_RATE;
    public static int ATOMIC_MULTIPLIER_USAGE;
    public static int ATOMIC_MULTIPLIER_SPEED;
    public static int ANALYSING_CHAMBER_STORAGE;
    public static int ANALYSING_CHAMBER_TRANSFER_RATE;
    public static int DOCKING_STATION_STORAGE;
    public static int DOCKING_STATION_TRANSFER_RATE;
    public static int DOCKING_STATION_USAGE;
    public static int DOCKING_STATION_SPEED;
    public static int REINFORCED_FURNACE_STORAGE;
    public static int REINFORCED_FURNACE_TRANSFER_RATE;
    public static int REINFORCED_FURNACE_USAGE;
    public static int REINFORCED_FURNACE_SPEED;
    public static int STONE_SEPERATOR_STORAGE;
    public static int STONE_SEPERATOR_TRANSFER_RATE;
    public static int STONE_SEPERATOR_USAGE;
    public static int STONE_SEPERATOR_SPEED;
    public static int ALGORITHM_SEPERATOR_STORAGE;
    public static int ALGORITHM_SEPERATOR_TRANSFER_RATE;
    public static int ALGORITHM_SEPERATOR_USAGE;
    public static int ALGORITHM_SEPERATOR_SPEED;
    public static int EXTRACTION_CHAMBER_STORAGE;
    public static int EXTRACTION_CHAMBER_TRANSFER_RATE;
    public static int EXTRACTION_CHAMBER_USAGE;
    public static int EXTRACTION_CHAMBER_SPEED;
    public static int REASSEMBLY_CHAMBER_STORAGE;
    public static int REASSEMBLY_CHAMBER_TRANSFER_RATE;
    public static int REASSEMBLY_CHAMBER_USAGE;
    public static int REASSEMBLY_CHAMBER_SPEED;
    public static int RESTORATION_CHAMBER_STORAGE;
    public static int RESTORATION_CHAMBER_TRANSFER_RATE;
    public static int RESTORATION_CHAMBER_USAGE;
    public static int RESTORATION_CHAMBER_SPEED;
    public static int PRECISION_CHAMBER_STORAGE;
    public static int PRECISION_CHAMBER_TRANSFER_RATE;
    public static int PRECISION_CHAMBER_USAGE;
    public static int PRECISION_CHAMBER_SPEED;
    public static int PROCESSING_CHAMBER_STORAGE;
    public static int PROCESSING_CHAMBER_TRANSFER_RATE;
    public static int PROCESSING_CHAMBER_USAGE;
    public static int PROCESSING_CHAMBER_SPEED;
    public static Item.ToolMaterial TOOL_REINFORCED_STONE;
    public static Item.ToolMaterial TOOL_REDSTONE_INGOT;
    public static Item.ToolMaterial TOOL_ENRICHED_GOLD;
    public static Item.ToolMaterial TOOL_REINFORCED_IRON;
    public static Item.ToolMaterial TOOL_WEAKENED_DIAMOND;
    public static Item.ToolMaterial TOOL_FLAWLESS_DIAMOND;
    public static Item.ToolMaterial TOOL_FIRE_DIAMOND;
    public static Item.ToolMaterial TOOL_ELECTRIC_DIAMOND;
    public static Item.ToolMaterial TOOL_END_DIAMOND;

    public static void initConfiguration(FMLPreInitializationEvent event) {
        CalculatorConfig.loadMainConfig();
        CalculatorConfig.loadAtomicBlacklist();
        CalculatorConfig.loadBlocks();
        CalculatorConfig.loadItems();
    }

    public static void loadMainConfig() {
        Configuration config = new Configuration(new File("config/calculator/Calculator-Config.cfg"));
        config.load();
        CALCULATOR_STORAGE = CalculatorConfig.INT(config, "Calculator", "Energy Storage", 1000, 1, Integer.MAX_VALUE);
        CRAFTING_CALCULATOR_STORAGE = CalculatorConfig.INT(config, "Crafting Calculator", "Energy Storage", 5000, 1, Integer.MAX_VALUE);
        SCIENTIFIC_CALCULATOR_STORAGE = CalculatorConfig.INT(config, "Scientific Calculator", "Energy Storage", 2000, 1, Integer.MAX_VALUE);
        TERRAIN_MODULE_STORAGE = CalculatorConfig.INT(config, "Terrain Module", "Energy Storage", 400, 10, Integer.MAX_VALUE);
        TERRAIN_MODULE_USAGE = CalculatorConfig.INT(config, "Terrain Module", "Energy Usage", 1, 0, Integer.MAX_VALUE);
        ADVANCED_TERRAIN_MODULE_STORAGE = CalculatorConfig.INT(config, "Advanced Terrain Module", "Energy Storage", 2000, 1, Integer.MAX_VALUE);
        ADVANCED_TERRAIN_MODULE_USAGE = CalculatorConfig.INT(config, "Advanced Terrain Module", "Energy Usage", 1, 0, Integer.MAX_VALUE);
        ENERGY_MODULE_STORAGE = CalculatorConfig.INT(config, "Energy Module", "Energy Storage", 100000, 1, Integer.MAX_VALUE);
        WARP_MODULE_STORAGE = CalculatorConfig.INT(config, "Warp Module", "Energy Storage", 10000, 1, Integer.MAX_VALUE);
        JUMP_MODULE_STORAGE = CalculatorConfig.INT(config, "Jump Module", "Energy Storage", 10000, 1, Integer.MAX_VALUE);
        HEALTH_MODULE_CAPACITY = CalculatorConfig.INT(config, "Health Module", "Health Capacity", 1000, -1, Integer.MAX_VALUE);
        HUNGER_MODULE_CAPACITY = CalculatorConfig.INT(config, "Hunger Module", "Hunger Capacity", 1000, -1, Integer.MAX_VALUE);
        NUTRITION_MODULE_HUNGER_CAPACITY = CalculatorConfig.INT(config, "Nutrition Module", "Hunger Capacity", -1, -1, Integer.MAX_VALUE);
        NUTRITION_MODULE_HEALTH_CAPACITY = CalculatorConfig.INT(config, "Nutrition Module", "Health Capacity", -1, -1, Integer.MAX_VALUE);
        ENDER_PEARL_MODULE_USAGE = CalculatorConfig.INT(config, "Flawless Calculator", "Ender Pearl Module - Energy Usage", 1000, 0, Integer.MAX_VALUE);
        GRENADE_MODULE_USAGE = CalculatorConfig.INT(config, "Flawless Calculator", "Grenade Module - Energy Usage", 10000, 0, Integer.MAX_VALUE);
        POWER_CUBE_STORAGE = CalculatorConfig.INT(config, "Power Cube", "Energy Storage", 50000, 1, Integer.MAX_VALUE);
        POWER_CUBE_TRANSFER_RATE = CalculatorConfig.INT(config, "Power Cube", "Transfer Rate", 400, 1, Integer.MAX_VALUE);
        POWER_CUBE_CHARGING_RATE = CalculatorConfig.INT(config, "Power Cube", "Charging Rate", 4, 1, Integer.MAX_VALUE);
        ADVANCED_POWER_CUBE_STORAGE = CalculatorConfig.INT(config, "Advanced Power Cube", "Energy Storage", 100000, 1, Integer.MAX_VALUE);
        ADVANCED_POWER_CUBE_TRANSFER_RATE = CalculatorConfig.INT(config, "Advanced Power Cube", "Transfer Rate", 64000, 1, Integer.MAX_VALUE);
        ADVANCED_POWER_CUBE_CHARGING_RATE = CalculatorConfig.INT(config, "Advanced Power Cube", "Charging Rate", 100000, 1, Integer.MAX_VALUE);
        CREATIVE_POWER_CUBE_TRANSFER_RATE = CalculatorConfig.INT(config, "Creative Power Cube", "Transfer Rate", Integer.MAX_VALUE, 1, Integer.MAX_VALUE);
        HAND_CRANK_STORAGE = CalculatorConfig.INT(config, "Hand Cranked Generator", "Energy Storage", 1000, 1, Integer.MAX_VALUE);
        HAND_CRANK_TRANSFER_RATE = CalculatorConfig.INT(config, "Hand Cranked Generator", "Transfer Rate", 400, 1, Integer.MAX_VALUE);
        HAND_CRANK_PER_TICK = CalculatorConfig.INT(config, "Hand Cranked Generator", "Generation", 8, 1, Integer.MAX_VALUE);
        STARCH_EXTRACTOR_STORAGE = CalculatorConfig.INT(config, "Starch Extractor", "Energy Storage", 1000000, 1, Integer.MAX_VALUE);
        STARCH_EXTRACTOR_TRANSFER_RATE = CalculatorConfig.INT(config, "Starch Extractor", "Transfer Rate", 3200, 1, Integer.MAX_VALUE);
        STARCH_EXTRACTOR_GENERATOR_CAPACITY = CalculatorConfig.INT(config, "Starch Extractor", "Generator Capacity", 5000, 1, Integer.MAX_VALUE);
        STARCH_EXTRACTOR_GENERATOR_REQUIRED = CalculatorConfig.INT(config, "Starch Extractor", "Generator Requirement", 400, 1, Integer.MAX_VALUE);
        STARCH_EXTRACTOR_PER_TICK = CalculatorConfig.INT(config, "Starch Extractor", "Generation", 40, 1, Integer.MAX_VALUE);
        REDSTONE_EXTRACTOR_STORAGE = CalculatorConfig.INT(config, "Redstone Extractor", "Energy Storage", 1000000, 1, Integer.MAX_VALUE);
        REDSTONE_EXTRACTOR_TRANSFER_RATE = CalculatorConfig.INT(config, "Redstone Extractor", "Transfer Rate", 3200, 1, Integer.MAX_VALUE);
        REDSTONE_EXTRACTOR_GENERATOR_CAPACITY = CalculatorConfig.INT(config, "Redstone Extractor", "Generator Capacity", 5000, 1, Integer.MAX_VALUE);
        REDSTONE_EXTRACTOR_GENERATOR_REQUIRED = CalculatorConfig.INT(config, "Redstone Extractor", "Generator Requirement", 400, 1, Integer.MAX_VALUE);
        REDSTONE_EXTRACTOR_PER_TICK = CalculatorConfig.INT(config, "Redstone Extractor", "Generation", 80, 1, Integer.MAX_VALUE);
        GLOWSTONE_EXTRACTOR_STORAGE = CalculatorConfig.INT(config, "Glowstone Extractor", "Energy Storage", 1000000, 1, Integer.MAX_VALUE);
        GLOWSTONE_EXTRACTOR_TRANSFER_RATE = CalculatorConfig.INT(config, "Glowstone Extractor", "Transfer Rate", 3200, 1, Integer.MAX_VALUE);
        GLOWSTONE_EXTRACTOR_GENERATOR_CAPACITY = CalculatorConfig.INT(config, "Glowstone Extractor", "Generator Capacity", 5000, 1, Integer.MAX_VALUE);
        GLOWSTONE_EXTRACTOR_GENERATOR_REQUIRED = CalculatorConfig.INT(config, "Glowstone Extractor", "Generator Requirement", 400, 1, Integer.MAX_VALUE);
        GLOWSTONE_EXTRACTOR_PER_TICK = CalculatorConfig.INT(config, "Glowstone Extractor", "Generation", 160, 1, Integer.MAX_VALUE);
        CONDUCTOR_MAST_STORAGE = CalculatorConfig.INT(config, "Conductor Mast", "Energy Storage", 50000000, 1, Integer.MAX_VALUE);
        CONDUCTOR_MAST_TRANSFER_RATE = CalculatorConfig.INT(config, "Conductor Mast", "Transfer Rate", Integer.MAX_VALUE, 1, Integer.MAX_VALUE);
        CONDUCTOR_MAST_CHARGING_RATE = CalculatorConfig.INT(config, "Conductor Mast", "Charging Rate", 100000, 1, Integer.MAX_VALUE);
        CONDUCTOR_MAST_PER_TICK = CalculatorConfig.INT(config, "Conductor Mast", "Generation", 5000, 1, Integer.MAX_VALUE);
        CONDUCTOR_MAST_SPEED = CalculatorConfig.INT(config, "Conductor Mast", "Base Speed", 50, 1, Integer.MAX_VALUE);
        WEATHER_STATION_PER_TICK = CalculatorConfig.INT(config, "Conductor Mast", "Weather Station Generation", 1000, 1, Integer.MAX_VALUE);
        CALCULATOR_LOCATOR_STORAGE = CalculatorConfig.INT(config, "Calculator Locator", "Energy Storage", 50000000, 1, Integer.MAX_VALUE);
        CALCULATOR_LOCATOR_TRANSFER_RATE = CalculatorConfig.INT(config, "Calculator Locator", "Transfer Rate", Integer.MAX_VALUE, 1, Integer.MAX_VALUE);
        CALCULATOR_LOCATOR_CHARGING_RATE = CalculatorConfig.INT(config, "Calculator Locator", "Charging Rate", 5000000, 1, Integer.MAX_VALUE);
        CALCULATOR_LOCATOR_MULTIPLIER = config.getFloat("Calculator Locator", "Generation", 2.0f, 0.1f, 64.0f, "MULTIPLIER");
        CALCULATOR_LOCATOR_CAN_CHANGE_TIME = config.getBoolean("Locator Can Change Time", "Calculator Locator", true, "");
        FLAWLESS_GREENHOUSE_STORAGE = CalculatorConfig.INT(config, "Flawless Greenhouse", "Energy Storage", 500000, 1, Integer.MAX_VALUE);
        FLAWLESS_GREENHOUSE_TRANSFER_RATE = CalculatorConfig.INT(config, "Flawless Greenhouse", "Transfer Rate", 64000, 1, Integer.MAX_VALUE);
        ADVANCED_GREENHOUSE_STORAGE = CalculatorConfig.INT(config, "Advanced Greenhouse", "Energy Storage", 350000, 1, Integer.MAX_VALUE);
        ADVANCED_GREENHOUSE_TRANSFER_RATE = CalculatorConfig.INT(config, "Advanced Greenhouse", "Transfer Rate", 3200, 1, Integer.MAX_VALUE);
        BASIC_GREENHOUSE_STORAGE = CalculatorConfig.INT(config, "Basic Greenhouse", "Energy Storage", 350000, 1, Integer.MAX_VALUE);
        BASIC_GREENHOUSE_TRANSFER_RATE = CalculatorConfig.INT(config, "Basic Greenhouse", "Transfer Rate", 400, 1, Integer.MAX_VALUE);
        C02_GENERATOR_STORAGE = CalculatorConfig.INT(config, "Carbon Dioxide Generator", "Energy Storage", 1000000, 1, Integer.MAX_VALUE);
        C02_GENERATOR_TRANSFER_RATE = CalculatorConfig.INT(config, "Carbon Dioxide Generator", "Transfer Rate", 64000, 1, Integer.MAX_VALUE);
        DOCKING_STATION_STORAGE = CalculatorConfig.INT(config, "Docking Station", "Energy Storage", 50000, 1, Integer.MAX_VALUE);
        DOCKING_STATION_TRANSFER_RATE = CalculatorConfig.INT(config, "Docking Station", "Transfer Rate", 3200, 1, Integer.MAX_VALUE);
        DOCKING_STATION_USAGE = CalculatorConfig.INT(config, "Docking Station", "Energy Usage", 10, 1, Integer.MAX_VALUE);
        DOCKING_STATION_SPEED = CalculatorConfig.INT(config, "Docking Station", "Base Speed", 200, 1, Integer.MAX_VALUE);
        GROWTH_ENERGY_USAGE = CalculatorConfig.INT(config, "Greenhouses", "Growth Energy", 150, 1, Integer.MAX_VALUE);
        BUILD_ENERGY_USAGE = CalculatorConfig.INT(config, "Greenhouses", "Build Energy", 100, 1, Integer.MAX_VALUE);
        PLANTING_ENERGY_USAGE = CalculatorConfig.INT(config, "Greenhouses", "Plant Energy", 50, 1, Integer.MAX_VALUE);
        FARMLAND_GENERATION_USAGE = CalculatorConfig.INT(config, "Greenhouses", "Adding Farmland", 50, 1, Integer.MAX_VALUE);
        WATER_GENERATION_USAGE = CalculatorConfig.INT(config, "Greenhouses", "Adding Water", 1000, 1, Integer.MAX_VALUE);
        SCARECROW_TICK_RATE = CalculatorConfig.INT(config, "Scarecrow", "Scarecrow Tick Rate", 500, 1, Integer.MAX_VALUE);
        SCARECROW_RANGE = CalculatorConfig.INT(config, "Scarecrow", "Scarecrow Range", 3, 1, 32);
        WEATHER_CONTROLLER_STORAGE = CalculatorConfig.INT(config, "Weather Controller", "Energy Storage", 1000000, 1, Integer.MAX_VALUE);
        WEATHER_CONTROLLER_TRANSFER_RATE = CalculatorConfig.INT(config, "Weather Controller", "Transfer Rate", 64000, 1, Integer.MAX_VALUE);
        WEATHER_CONTROLLER_USAGE = CalculatorConfig.INT(config, "Weather Controller", "Energy Usage", 250000, 1, Integer.MAX_VALUE);
        ATOMIC_MULTIPLIER_STORAGE = CalculatorConfig.INT(config, "Atomic Multiplier", "Energy Storage", 1500000000, 1, Integer.MAX_VALUE);
        ATOMIC_MULTIPLIER_TRANSFER_RATE = CalculatorConfig.INT(config, "Atomic Multiplier", "Transfer Rate", Integer.MAX_VALUE, 1, Integer.MAX_VALUE);
        ATOMIC_MULTIPLIER_USAGE = CalculatorConfig.INT(config, "Atomic Multiplier", "Energy Usage", 1500000000, 1, Integer.MAX_VALUE);
        ATOMIC_MULTIPLIER_SPEED = CalculatorConfig.INT(config, "Atomic Multiplier", "Base Speed", 1000, 1, Integer.MAX_VALUE);
        ANALYSING_CHAMBER_STORAGE = CalculatorConfig.INT(config, "Analysing Chamber", "Energy Storage", 100000, 1, Integer.MAX_VALUE);
        ANALYSING_CHAMBER_TRANSFER_RATE = CalculatorConfig.INT(config, "Analysing Chamber", "Transfer Rate", 12800, 1, Integer.MAX_VALUE);
        REINFORCED_FURNACE_STORAGE = CalculatorConfig.INT(config, "Reinforced Furnace", "Energy Storage", 50000, 1, Integer.MAX_VALUE);
        REINFORCED_FURNACE_TRANSFER_RATE = CalculatorConfig.INT(config, "Reinforced Furnace", "Transfer Rate", 3200, 1, Integer.MAX_VALUE);
        REINFORCED_FURNACE_USAGE = CalculatorConfig.INT(config, "Reinforced Furnace", "Energy Usage", 500, 1, Integer.MAX_VALUE);
        REINFORCED_FURNACE_SPEED = CalculatorConfig.INT(config, "Reinforced Furnace", "Base Speed", 200, 1, Integer.MAX_VALUE);
        STONE_SEPERATOR_STORAGE = CalculatorConfig.INT(config, "Stone Seperator", "Energy Storage", 50000, 1, Integer.MAX_VALUE);
        STONE_SEPERATOR_TRANSFER_RATE = CalculatorConfig.INT(config, "Stone Seperator", "Transfer Rate", 3200, 1, Integer.MAX_VALUE);
        STONE_SEPERATOR_USAGE = CalculatorConfig.INT(config, "Stone Seperator", "Energy Usage", 500, 1, Integer.MAX_VALUE);
        STONE_SEPERATOR_SPEED = CalculatorConfig.INT(config, "Stone Seperator", "Base Speed", 200, 1, Integer.MAX_VALUE);
        ALGORITHM_SEPERATOR_STORAGE = CalculatorConfig.INT(config, "Algorithm Seperator", "Energy Storage", 50000, 1, Integer.MAX_VALUE);
        ALGORITHM_SEPERATOR_TRANSFER_RATE = CalculatorConfig.INT(config, "Algorithm Seperator", "Transfer Rate", 3200, 1, Integer.MAX_VALUE);
        ALGORITHM_SEPERATOR_USAGE = CalculatorConfig.INT(config, "Algorithm Seperator", "Energy Usage", 5000, 1, Integer.MAX_VALUE);
        ALGORITHM_SEPERATOR_SPEED = CalculatorConfig.INT(config, "Algorithm Seperator", "Base Speed", 200, 1, Integer.MAX_VALUE);
        EXTRACTION_CHAMBER_STORAGE = CalculatorConfig.INT(config, "Extraction Chamber", "Energy Storage", 50000, 1, Integer.MAX_VALUE);
        EXTRACTION_CHAMBER_TRANSFER_RATE = CalculatorConfig.INT(config, "Extraction Chamber", "Transfer Rate", 3200, 1, Integer.MAX_VALUE);
        EXTRACTION_CHAMBER_USAGE = CalculatorConfig.INT(config, "Extraction Chamber", "Energy Usage", 5000, 1, Integer.MAX_VALUE);
        EXTRACTION_CHAMBER_SPEED = CalculatorConfig.INT(config, "Extraction Chamber", "Base Speed", 1000, 1, Integer.MAX_VALUE);
        REASSEMBLY_CHAMBER_STORAGE = CalculatorConfig.INT(config, "Reassembly Chamber", "Energy Storage", 50000, 1, Integer.MAX_VALUE);
        REASSEMBLY_CHAMBER_TRANSFER_RATE = CalculatorConfig.INT(config, "Reassembly Chamber", "Transfer Rate", 3200, 1, Integer.MAX_VALUE);
        REASSEMBLY_CHAMBER_USAGE = CalculatorConfig.INT(config, "Reassembly Chamber", "Energy Usage", 1000, 1, Integer.MAX_VALUE);
        REASSEMBLY_CHAMBER_SPEED = CalculatorConfig.INT(config, "Reassembly Chamber", "Base Speed", 1000, 1, Integer.MAX_VALUE);
        RESTORATION_CHAMBER_STORAGE = CalculatorConfig.INT(config, "Restoration Chamber", "Energy Storage", 50000, 1, Integer.MAX_VALUE);
        RESTORATION_CHAMBER_TRANSFER_RATE = CalculatorConfig.INT(config, "Restoration Chamber", "Transfer Rate", 3200, 1, Integer.MAX_VALUE);
        RESTORATION_CHAMBER_USAGE = CalculatorConfig.INT(config, "Restoration Chamber", "Energy Usage", 1000, 1, Integer.MAX_VALUE);
        RESTORATION_CHAMBER_SPEED = CalculatorConfig.INT(config, "Restoration Chamber", "Base Speed", 1000, 1, Integer.MAX_VALUE);
        PRECISION_CHAMBER_STORAGE = CalculatorConfig.INT(config, "Precision Chamber", "Energy Storage", 50000, 1, Integer.MAX_VALUE);
        PRECISION_CHAMBER_TRANSFER_RATE = CalculatorConfig.INT(config, "Precision Chamber", "Transfer Rate", 3200, 1, Integer.MAX_VALUE);
        PRECISION_CHAMBER_USAGE = CalculatorConfig.INT(config, "Precision Chamber", "Energy Usage", 5000, 1, Integer.MAX_VALUE);
        PRECISION_CHAMBER_SPEED = CalculatorConfig.INT(config, "Precision Chamber", "Base Speed", 500, 1, Integer.MAX_VALUE);
        PROCESSING_CHAMBER_STORAGE = CalculatorConfig.INT(config, "Processing Chamber", "Energy Storage", 50000, 1, Integer.MAX_VALUE);
        PROCESSING_CHAMBER_TRANSFER_RATE = CalculatorConfig.INT(config, "Processing Chamber", "Transfer Rate", 3200, 1, Integer.MAX_VALUE);
        PROCESSING_CHAMBER_USAGE = CalculatorConfig.INT(config, "Processing Chamber", "Energy Usage", 1000, 1, Integer.MAX_VALUE);
        PROCESSING_CHAMBER_SPEED = CalculatorConfig.INT(config, "Processing Chamber", "Base Speed", 500, 1, Integer.MAX_VALUE);
        TOOL_REINFORCED_STONE = CalculatorConfig.loadToolMaterial(config, "Reinforced Stone", 1, 250, 5.0f, 1.5f, 5);
        TOOL_REDSTONE_INGOT = CalculatorConfig.loadToolMaterial(config, "Redstone Ingot", 2, 800, 7.5f, 2.5f, 18);
        TOOL_ENRICHED_GOLD = CalculatorConfig.loadToolMaterial(config, "Enriched Gold", 3, 1000, 8.0f, 0.0f, 20);
        TOOL_REINFORCED_IRON = CalculatorConfig.loadToolMaterial(config, "Reinforced Iron", 2, 400, 7.0f, 2.0f, 10);
        TOOL_WEAKENED_DIAMOND = CalculatorConfig.loadToolMaterial(config, "Weakened Diamond", 3, 1400, 8.0f, 3.0f, 10);
        TOOL_FLAWLESS_DIAMOND = CalculatorConfig.loadToolMaterial(config, "Flawless Diamond", 3, 1800, 14.0f, 5.0f, 30);
        TOOL_FIRE_DIAMOND = CalculatorConfig.loadToolMaterial(config, "Fire Diamond", 3, 2600, 16.0f, 7.0f, 30);
        TOOL_ELECTRIC_DIAMOND = CalculatorConfig.loadToolMaterial(config, "Electric Diamond", 4, 10000, 18.0f, 10.0f, 30);
        TOOL_END_DIAMOND = CalculatorConfig.loadToolMaterial(config, "End Diamond", 6, -1, 50.0f, 16.0f, 30);
        enableWaila = config.getBoolean("enable Waila integration", "api", true, "Waila");
        enableGrenades = config.getBoolean("allow grenades?", "settings", true, "Grenades");
        enableToolModels = config.getBoolean("Enable Tool Models", "settings", true, "Tool Models");
        config.save();
    }

    public static Item.ToolMaterial loadToolMaterial(Configuration config, String name, int harvestLevel, int maxUses, float efficiency, float damage, int enchantability) {
        int actual_harvest_level = CalculatorConfig.INT(config, "Tool Material: " + name, "Harvest Level", harvestLevel, 0, Integer.MAX_VALUE);
        int actual_max_uses = CalculatorConfig.INT(config, "Tool Material: " + name, "Max Uses", maxUses, -1, Integer.MAX_VALUE);
        int actual_enchant = CalculatorConfig.INT(config, "Tool Material: " + name, "Enchantibility", enchantability, 0, Integer.MAX_VALUE);
        float actual_efficiency = CalculatorConfig.FLOAT(config, "Tool Material: " + name, "Efficiency", efficiency, 0.0f, 1024.0f);
        float actual_damage = CalculatorConfig.FLOAT(config, "Tool Material: " + name, "Damage", damage, 0.0f, 1024.0f);
        return EnumHelper.addToolMaterial((String)name.replaceAll("\\s+", ""), (int)actual_harvest_level, (int)actual_max_uses, (float)actual_efficiency, (float)actual_damage, (int)actual_enchant);
    }

    public static void loadAtomicBlacklist() {
        Configuration blacklist = new Configuration(new File("config/calculator/AtomicMultiplier-BlackList.cfg"));
        blacklist.load();
        String[] blackDefaults = new String[]{"minecraft:nether_star", "Calculator:AtomicMultiplier", "Calculator:EndBlock", "Calculator:ElectricBlock", "Calculator:FlawlessFireBlock", "Calculator:FlawlessBlock", "Calculator:ElectricDiamond", "Calculator:FlawlessFireDiamond", "Calculator:FlawlessDiamond"};
        atomicblackList = blacklist.get("Atomic Multiplier Blacklist", "disabled", blackDefaults);
        blacklist.save();
    }

    public static void loadBlocks() {
        Configuration blocks = new Configuration(new File("config/calculator/Blocks-BlackList.cfg"));
        blocks.load();
        String[] blockExamples = new String[]{"ExampleBlock", "ExampleBlock2"};
        blocksblackList = blocks.get("Block Config", "Disabled", blockExamples);
        blocks.save();
    }

    public static void loadItems() {
        Configuration items = new Configuration(new File("config/calculator/Items-BlackList.cfg"));
        items.load();
        String[] itemExamples = new String[]{"ExampleItem", "ExampleItem2"};
        itemsblackList = items.get("Item Config", "Disabled", itemExamples);
        items.save();
    }

    private static boolean isBlockEnabled(String block) {
        if (block != null) {
            String[] blacklisted;
            for (String aBlacklisted : blacklisted = blocksblackList.getStringList()) {
                if (aBlacklisted == null || !aBlacklisted.equals(block)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private static boolean isItemEnabled(String item) {
        if (item != null) {
            String[] blacklisted;
            for (String aBlacklisted : blacklisted = itemsblackList.getStringList()) {
                if (aBlacklisted == null || !aBlacklisted.equals(item)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static boolean isEnabled(ItemStack stack) {
        return true;
    }

    public static int INT(Configuration config, String category, String name, int defaultValue, int minValue, int maxValue) {
        Property prop = config.get(category, name, defaultValue);
        prop.setLanguageKey(name);
        prop.setComment("");
        prop.setMinValue(minValue);
        prop.setMaxValue(maxValue);
        return prop.getInt(defaultValue) < minValue ? minValue : (prop.getInt(defaultValue) > maxValue ? maxValue : prop.getInt(defaultValue));
    }

    public static double DOUBLE(Configuration config, String category, String name, float defaultValue, float minValue, float maxValue) {
        Property prop = config.get(category, name, (double)defaultValue);
        prop.setLanguageKey(name);
        prop.setComment("");
        prop.setMinValue((double)minValue);
        prop.setMaxValue((double)maxValue);
        return prop.getDouble((double)defaultValue) < (double)minValue ? (double)minValue : (prop.getDouble((double)defaultValue) > (double)maxValue ? (double)maxValue : prop.getDouble((double)defaultValue));
    }

    public static float FLOAT(Configuration config, String name, String category, float defaultValue, float minValue, float maxValue) {
        Property prop = config.get(category, name, Float.toString(defaultValue), name);
        prop.setLanguageKey(name);
        prop.setComment("");
        prop.setMinValue((double)minValue);
        prop.setMaxValue((double)maxValue);
        try {
            float parseFloat = Float.parseFloat(prop.getString());
            return Floats.constrainToRange((float)parseFloat, (float)minValue, (float)maxValue);
        }
        catch (Exception e) {
            FMLLog.log.error("Failed to get float for {}/{}", (Object)name, (Object)category, (Object)e);
            return defaultValue;
        }
    }

    static {
        TOOL_REDSTONE_INGOT = EnumHelper.addToolMaterial((String)"RedstoneMaterial", (int)2, (int)800, (float)7.5f, (float)2.5f, (int)18);
        TOOL_ENRICHED_GOLD = EnumHelper.addToolMaterial((String)"EnrichedGold", (int)3, (int)1000, (float)8.0f, (float)0.0f, (int)20);
        TOOL_REINFORCED_IRON = EnumHelper.addToolMaterial((String)"ReinforcedIron", (int)2, (int)400, (float)7.0f, (float)2.0f, (int)10);
        TOOL_WEAKENED_DIAMOND = EnumHelper.addToolMaterial((String)"WeakenedDiamond", (int)3, (int)1400, (float)8.0f, (float)3.0f, (int)10);
        TOOL_FLAWLESS_DIAMOND = EnumHelper.addToolMaterial((String)"FlawlessDiamond", (int)3, (int)1800, (float)14.0f, (float)5.0f, (int)30);
        TOOL_FIRE_DIAMOND = EnumHelper.addToolMaterial((String)"FireDiamond", (int)3, (int)2600, (float)16.0f, (float)7.0f, (int)30);
        TOOL_ELECTRIC_DIAMOND = EnumHelper.addToolMaterial((String)"ElectricDiamond", (int)4, (int)10000, (float)18.0f, (float)10.0f, (int)30);
        TOOL_END_DIAMOND = EnumHelper.addToolMaterial((String)"EndForged", (int)6, (int)-1, (float)50.0f, (float)16.0f, (int)30);
    }
}

