/*
 * Decompiled with CFR 0.152.
 */
package sonar.calculator.mod.client.renderers;

import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;
import sonar.calculator.mod.client.models.ModelChamber;
import sonar.calculator.mod.client.models.ModelProcessing;
import sonar.calculator.mod.client.models.ModelSplit;
import sonar.calculator.mod.common.tileentity.TileEntityMachine;
import sonar.calculator.mod.common.tileentity.TileEntityProcess;
import sonar.core.helpers.FontHelper;
import sonar.core.helpers.RenderHelper;

public abstract class RenderChamber
extends TileEntitySpecialRenderer<TileEntity> {
    public ModelChamber model;
    public String texture;
    public ModelProcessing process = new ModelProcessing();
    public ModelSplit splitter = new ModelSplit();
    public ResourceLocation input = new ResourceLocation("Calculator:textures/blocks/overlays/machine_input.png");
    public ResourceLocation output = new ResourceLocation("Calculator:textures/blocks/overlays/machine_output.png");

    public RenderChamber(boolean white) {
        this.model = new ModelChamber();
        this.texture = white ? "Calculator:textures/model/machine_frame.png" : "Calculator:textures/model/machine_frame_black.png";
    }

    public abstract void renderAnimation(TileEntity var1, double var2, double var4, double var6);

    public abstract String getName(TileEntity var1);

    public void func_192841_a(TileEntity entity, double x, double y, double z, float partialTicks, int destroyStage, float f) {
        RenderHelper.beginRender((double)(x + 0.5), (double)(y + 1.5), (double)(z + 0.5), (int)RenderHelper.setMetaData((TileEntity)entity), (String)this.texture);
        if (destroyStage < 0) {
            // empty if block
        }
        this.model.func_78088_a(null, 0.0f, 0.0f, 0.1f, 0.0f, 0.0f, 0.0625f);
        this.renderAnimation(entity, x, y, z);
        if (entity != null && entity instanceof TileEntityProcess) {
            TileEntityProcess inv = (TileEntityProcess)entity;
            ItemStack target = (Integer)inv.cookTime.getObject() == 0 && inv.func_70301_a(2) != null ? inv.func_70301_a(2) : inv.func_70301_a(0);
            if (!target.func_190926_b()) {
                if (!Minecraft.func_71410_x().func_175599_af().func_175050_a(target)) {
                    GL11.glRotated((double)90.0, (double)1.0, (double)0.0, (double)0.0);
                    GL11.glTranslated((double)0.0, (double)-0.0, (double)-1.17);
                    GL11.glScaled((double)0.5, (double)0.5, (double)0.5);
                    Minecraft.func_71410_x().func_175599_af().func_181564_a(target, ItemCameraTransforms.TransformType.GROUND);
                } else {
                    GL11.glRotated((double)180.0, (double)1.0, (double)0.0, (double)0.0);
                    GL11.glRotated((double)180.0, (double)0.0, (double)1.0, (double)0.0);
                    GL11.glScaled((double)0.6, (double)0.6, (double)0.6);
                    GL11.glTranslated((double)0.0, (double)-2.05, (double)0.0);
                    Minecraft.func_71410_x().func_175599_af().func_181564_a(target, ItemCameraTransforms.TransformType.GROUND);
                }
            }
        }
        GL11.glPopMatrix();
        GL11.glPushMatrix();
        float f1 = 0.6666667f;
        int j = RenderHelper.setMetaData((TileEntity)entity);
        float f3 = 0.0f;
        if (j == 2) {
            f3 = 180.0f;
        }
        if (j == 4) {
            f3 = 90.0f;
        }
        if (j == 5) {
            f3 = -90.0f;
        }
        GL11.glRotated((double)(-f3), (double)0.0, (double)1.0, (double)0.0);
        f3 = 0.006666668f * f1;
        GL11.glScalef((float)f3, (float)(-f3), (float)f3);
        GL11.glTranslatef((float)0.0f, (float)0.0f, (float)-29.0f);
        GL11.glNormal3f((float)0.0f, (float)0.0f, (float)-1.0f);
        GL11.glRotated((double)25.0, (double)1.0, (double)0.0, (double)0.0);
        GL11.glDepthMask((boolean)false);
        FontHelper.textCentre((String)FontHelper.translate((String)this.getName(entity)), (int)0, (int)294, (int)1);
        GL11.glDepthMask((boolean)true);
        GL11.glRotated((double)-25.0, (double)1.0, (double)0.0, (double)0.0);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glPopMatrix();
        GL11.glPopMatrix();
    }

    public static class Precision
    extends RenderChamber {
        public Precision() {
            super(true);
        }

        @Override
        public void renderAnimation(TileEntity entity, double x, double y, double z) {
            if (entity != null) {
                float tick = ((TileEntityProcess)entity).getRenderPosition() / 4.5f;
                GL11.glTranslated((double)0.0, (double)tick, (double)0.0);
                this.splitter.renderSplitter(null, 0.0f, 0.0f, 0.1f, 0.0f, 0.0f, 0.0625f);
                GL11.glTranslated((double)0.0, (double)(-tick), (double)0.0);
                this.splitter.func_78088_a(null, 0.0f, 0.0f, 0.1f, 0.0f, 0.0f, 0.0625f);
            } else {
                this.splitter.func_78088_a(null, 0.0f, 0.0f, 0.1f, 0.0f, 0.0f, 0.0625f);
                this.splitter.renderSplitter(null, 0.0f, 0.0f, 0.1f, 0.0f, 0.0f, 0.0625f);
            }
        }

        @Override
        public String getName(TileEntity entity) {
            return "tile.PrecisionChamber.name";
        }
    }

    public static class Extraction
    extends RenderChamber {
        public Extraction() {
            super(false);
        }

        @Override
        public void renderAnimation(TileEntity entity, double x, double y, double z) {
            if (entity != null) {
                float tick = ((TileEntityProcess)entity).getRenderPosition() / 4.5f;
                GL11.glTranslated((double)0.0, (double)tick, (double)0.0);
                this.splitter.renderSplitter(null, 0.0f, 0.0f, 0.1f, 0.0f, 0.0f, 0.0625f);
                GL11.glTranslated((double)0.0, (double)(-tick), (double)0.0);
                this.splitter.func_78088_a(null, 0.0f, 0.0f, 0.1f, 0.0f, 0.0f, 0.0625f);
            } else {
                this.splitter.func_78088_a(null, 0.0f, 0.0f, 0.1f, 0.0f, 0.0f, 0.0625f);
                this.splitter.renderSplitter(null, 0.0f, 0.0f, 0.1f, 0.0f, 0.0f, 0.0625f);
            }
        }

        @Override
        public String getName(TileEntity entity) {
            return "tile.ExtractionChamber.name";
        }
    }

    public static class Removal
    extends RenderChamber {
        public Removal() {
            super(false);
        }

        @Override
        public void renderAnimation(TileEntity entity, double x, double y, double z) {
            if (entity != null) {
                float tick = ((TileEntityProcess)entity).getRenderPosition() / 2.0f;
                GL11.glTranslated((double)0.0, (double)0.0, (double)(-tick));
                this.process.func_78088_a(null, 0.0f, 0.0f, 0.1f, 0.0f, 0.0f, 0.0625f);
                GL11.glTranslated((double)0.0, (double)0.0, (double)tick);
            } else {
                this.process.func_78088_a(null, 0.0f, 0.0f, 0.1f, 0.0f, 0.0f, 0.0625f);
            }
        }

        @Override
        public String getName(TileEntity entity) {
            if (entity instanceof TileEntityMachine.RestorationChamber) {
                return "tile.RestorationChamber.name";
            }
            return "tile.ReassemblyChamber.name";
        }
    }

    public static class Processing
    extends RenderChamber {
        public Processing() {
            super(true);
        }

        @Override
        public void renderAnimation(TileEntity entity, double x, double y, double z) {
            if (entity != null) {
                float tick = ((TileEntityProcess)entity).getRenderPosition() / 2.0f;
                GL11.glTranslated((double)0.0, (double)0.0, (double)(-tick));
                this.process.func_78088_a(null, 0.0f, 0.0f, 0.1f, 0.0f, 0.0f, 0.0625f);
                GL11.glTranslated((double)0.0, (double)0.0, (double)tick);
            } else {
                this.process.func_78088_a(null, 0.0f, 0.0f, 0.1f, 0.0f, 0.0f, 0.0625f);
            }
        }

        @Override
        public String getName(TileEntity entity) {
            return "tile.ProcessingChamber.name";
        }
    }
}

