/*
 * Decompiled with CFR 0.152.
 */
package sonar.calculator.mod.common.block;

import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBush;
import net.minecraft.block.IGrowable;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenBigTree;
import net.minecraft.world.gen.feature.WorldGenTrees;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.event.terraingen.TerrainGen;
import sonar.calculator.mod.Calculator;
import sonar.calculator.mod.common.block.MaterialBlock;
import sonar.calculator.mod.utils.helpers.CalculatorTreeBuilder;

public class CalculatorSaplings
extends BlockBush
implements IGrowable {
    public static final PropertyInteger STAGE = PropertyInteger.func_177719_a((String)"stage", (int)0, (int)1);
    public int type;

    public CalculatorSaplings(int i) {
        this.type = i;
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)STAGE, (Comparable)Integer.valueOf(0)));
        float f = 0.4f;
    }

    public boolean func_176196_c(World worldIn, BlockPos pos) {
        IBlockState soil = worldIn.func_180495_p(pos.func_177977_b());
        return this.type != 3 ? super.func_176196_c(worldIn, pos) && soil.func_177230_c().canSustainPlant(soil, (IBlockAccess)worldIn, pos.func_177977_b(), EnumFacing.UP, (IPlantable)this) : soil.func_177230_c() == Calculator.material_block && soil.func_177229_b(MaterialBlock.VARIANTS) == MaterialBlock.Variants.END_DIAMOND;
    }

    public boolean func_180671_f(World worldIn, BlockPos pos, IBlockState state) {
        return this.type == 3 ? this.func_185514_i(worldIn.func_180495_p(pos.func_177977_b())) : super.func_180671_f(worldIn, pos, state);
    }

    protected boolean func_185514_i(IBlockState state) {
        return this.type != 3 ? state.func_177230_c() == Blocks.field_150349_c || state.func_177230_c() == Blocks.field_150346_d || state.func_177230_c() == Blocks.field_150458_ak : state.func_177230_c() == Calculator.material_block && state.func_177229_b(MaterialBlock.VARIANTS) == MaterialBlock.Variants.END_DIAMOND;
    }

    public void func_180650_b(@Nonnull World worldIn, @Nonnull BlockPos pos, @Nonnull IBlockState state, Random rand) {
        if (!worldIn.field_72995_K) {
            super.func_180650_b(worldIn, pos, state, rand);
            if (worldIn.func_175671_l(pos.func_177984_a()) >= 9 && rand.nextInt(7) == 0) {
                this.grow(worldIn, pos, state, rand);
            }
        }
    }

    public void grow(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        if ((Integer)state.func_177229_b((IProperty)STAGE) == 0) {
            worldIn.func_180501_a(pos, state.func_177231_a((IProperty)STAGE), 4);
        } else {
            this.generateTree(worldIn, pos, state, rand);
        }
    }

    public void generateTree(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        if (!TerrainGen.saplingGrowTree((World)worldIn, (Random)rand, (BlockPos)pos)) {
            return;
        }
        Object worldgenerator = rand.nextInt(10) == 0 ? new WorldGenBigTree(true) : new WorldGenTrees(true);
        int i = 0;
        int j = 0;
        boolean flag = false;
        switch (this.type) {
            case 0: {
                worldgenerator = new CalculatorTreeBuilder(true, Calculator.amethystSapling, Calculator.amethystLeaves, Calculator.amethystLog);
                break;
            }
            case 1: {
                worldgenerator = new CalculatorTreeBuilder(true, Calculator.tanzaniteSapling, Calculator.tanzaniteLeaves, Calculator.tanzaniteLog);
                break;
            }
            case 2: {
                worldgenerator = new CalculatorTreeBuilder(true, Calculator.pearSapling, Calculator.pearLeaves, Calculator.pearLog);
                break;
            }
            case 3: {
                worldgenerator = new CalculatorTreeBuilder(true, Calculator.diamondSapling, Calculator.diamondLeaves, Calculator.diamondLog);
            }
        }
        IBlockState iblockstate2 = Blocks.field_150350_a.func_176223_P();
        worldIn.func_180501_a(pos, iblockstate2, 4);
        if (!worldgenerator.func_180709_b(worldIn, rand, pos.func_177982_a(i, 0, j))) {
            worldIn.func_180501_a(pos, state, 4);
        }
    }

    public int func_180651_a(IBlockState state) {
        return 0;
    }

    public boolean func_176473_a(@Nonnull World worldIn, @Nonnull BlockPos pos, @Nonnull IBlockState state, boolean isClient) {
        return true;
    }

    public boolean func_180670_a(@Nonnull World worldIn, @Nonnull Random rand, @Nonnull BlockPos pos, @Nonnull IBlockState state) {
        return (double)worldIn.field_73012_v.nextFloat() < 0.45;
    }

    public void func_176474_b(@Nonnull World worldIn, @Nonnull Random rand, @Nonnull BlockPos pos, @Nonnull IBlockState state) {
        this.grow(worldIn, pos, state, rand);
    }

    @Nonnull
    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)STAGE, (Comparable)Integer.valueOf(meta));
    }

    public int func_176201_c(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)STAGE);
    }

    @Nonnull
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{STAGE});
    }
}

