/*
 * Decompiled with CFR 0.152.
 */
package sonar.calculator.mod.common.block.generators;

import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import sonar.calculator.mod.CalculatorConfig;
import sonar.calculator.mod.common.tileentity.generators.TileEntityGenerator;
import sonar.calculator.mod.utils.helpers.CalculatorHelper;
import sonar.core.common.block.SonarBlock;
import sonar.core.common.block.SonarMaterials;
import sonar.core.helpers.FontHelper;
import sonar.core.network.FlexibleGuiHandler;
import sonar.core.utils.ISpecialTooltip;

public class ExtractorBlock
extends SonarBlock
implements ITileEntityProvider,
ISpecialTooltip {
    public int type;

    public ExtractorBlock(int type) {
        super(SonarMaterials.machine, false);
        this.type = type;
        this.hasSpecialRenderer = true;
        this.setBlockBounds(0.0625, 0.0625, 0.0625, 0.9375, 0.9375, 0.9375);
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (player != null && !world.field_72995_K) {
            FlexibleGuiHandler.instance().openBasicTile(player, world, pos, 0);
        }
        return true;
    }

    public void func_176213_c(World world, BlockPos pos, IBlockState state) {
        super.func_176213_c(world, pos, state);
        TileEntity tileentity = world.func_175625_s(pos);
        if (tileentity instanceof TileEntityGenerator) {
            TileEntityGenerator tileEntityGenerator = (TileEntityGenerator)world.func_175625_s(pos);
        }
    }

    public void onNeighborChange(IBlockAccess world, BlockPos pos, BlockPos neighbour) {
        TileEntity tileentity = world.func_175625_s(pos);
        if (tileentity instanceof TileEntityGenerator) {
            TileEntityGenerator tileEntityGenerator = (TileEntityGenerator)world.func_175625_s(pos);
        }
    }

    public TileEntity func_149915_a(@Nonnull World world, int var) {
        switch (this.type) {
            case 0: {
                return new TileEntityGenerator.StarchExtractor();
            }
            case 1: {
                return new TileEntityGenerator.RedstoneExtractor();
            }
            case 2: {
                return new TileEntityGenerator.GlowstoneExtractor();
            }
        }
        return new TileEntityGenerator.StarchExtractor();
    }

    public void addSpecialToolTip(ItemStack stack, World world, List<String> list, NBTTagCompound tag) {
        CalculatorHelper.addEnergytoToolTip(stack, world, list);
        CalculatorHelper.addItemLevelToolTip(stack, world, list);
        switch (this.type) {
            case 0: {
                list.add(FontHelper.translate((String)"energy.generate") + ": " + CalculatorConfig.STARCH_EXTRACTOR_PER_TICK + " RF/t");
                break;
            }
            case 1: {
                list.add(FontHelper.translate((String)"energy.generate") + ": " + CalculatorConfig.REDSTONE_EXTRACTOR_PER_TICK + " RF/t");
                break;
            }
            case 2: {
                list.add(FontHelper.translate((String)"energy.generate") + ": " + CalculatorConfig.GLOWSTONE_EXTRACTOR_PER_TICK + " RF/t");
            }
        }
    }
}

