/*
 * Decompiled with CFR 0.152.
 */
package sonar.calculator.mod.common.block.machines;

import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import sonar.calculator.mod.common.tileentity.TileEntityGreenhouse;
import sonar.calculator.mod.common.tileentity.machines.TileEntityFlawlessGreenhouse;
import sonar.calculator.mod.utils.helpers.CalculatorHelper;
import sonar.core.api.blocks.IConnectedBlock;
import sonar.core.common.block.SonarBlock;
import sonar.core.common.block.SonarMaterials;
import sonar.core.helpers.FontHelper;
import sonar.core.network.FlexibleGuiHandler;
import sonar.core.utils.FailedCoords;
import sonar.core.utils.ISpecialTooltip;

public class FlawlessGreenhouse
extends SonarBlock
implements IConnectedBlock,
ITileEntityProvider,
ISpecialTooltip {
    public int[] connections = new int[]{0, 5, 6};

    public FlawlessGreenhouse() {
        super(SonarMaterials.machine, true);
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileEntityFlawlessGreenhouse) {
            TileEntityFlawlessGreenhouse house = (TileEntityFlawlessGreenhouse)tile;
            if (player.func_70093_af()) {
                if (house.houseState.getObject() == TileEntityGreenhouse.State.INCOMPLETE) {
                    FailedCoords coords = house.checkStructure(null);
                    if (!coords.getBoolean()) {
                        FontHelper.sendMessage((String)("X: " + coords.getCoords().getX() + " Y: " + coords.getCoords().getY() + " Z: " + coords.getCoords().getZ() + " - " + FontHelper.translate((String)"greenhouse.equal") + ' ' + coords.getBlock()), (World)world, (EntityPlayer)player);
                    }
                } else if (house.houseState.getObject() == TileEntityGreenhouse.State.COMPLETED) {
                    FontHelper.sendMessage((String)FontHelper.translate((String)"greenhouse.complete"), (World)world, (EntityPlayer)player);
                }
            } else if (player != null && !world.field_72995_K) {
                FlexibleGuiHandler.instance().openBasicTile(player, world, pos, 0);
            }
        }
        return true;
    }

    public TileEntity func_149915_a(@Nonnull World var1, int var2) {
        return new TileEntityFlawlessGreenhouse();
    }

    public void addSpecialToolTip(ItemStack stack, World world, List<String> list, NBTTagCompound tag) {
        CalculatorHelper.addEnergytoToolTip(stack, world, list);
    }

    public int[] getConnections() {
        return this.connections;
    }
}

