/*
 * Decompiled with CFR 0.152.
 */
package sonar.calculator.mod.common.block.misc;

import java.util.Iterator;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import sonar.calculator.mod.Calculator;
import sonar.calculator.mod.common.tileentity.misc.TileEntityGasLantern;
import sonar.core.common.block.SonarBlockContainer;
import sonar.core.common.block.SonarMaterials;
import sonar.core.network.FlexibleGuiHandler;

public class GasLantern
extends SonarBlockContainer {
    private static boolean keepInventory;
    public final boolean isActive;
    public static final PropertyDirection DIR;

    public GasLantern(boolean active) {
        super(SonarMaterials.machine, false);
        this.isActive = active;
        this.hasSpecialRenderer = true;
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)DIR, (Comparable)EnumFacing.NORTH));
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (!world.field_72995_K && player != null) {
            FlexibleGuiHandler.instance().openBasicTile(player, world, pos, 0);
        }
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState state, World world, BlockPos pos, Random random) {
        if (state.func_177230_c() == Calculator.gas_lantern_on) {
            float x1 = (float)pos.func_177958_n() + random.nextFloat();
            float y1 = (float)pos.func_177956_o() + 0.5f;
            float z1 = (float)pos.func_177952_p() + random.nextFloat();
            world.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, (double)x1, (double)y1, (double)z1, 0.0, 0.0, 0.0, new int[0]);
            world.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, (double)x1, (double)y1, (double)z1, 0.0, 0.0, 0.0, new int[0]);
        }
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        if (!keepInventory) {
            super.func_180663_b(world, pos, state);
        }
        world.func_175713_t(pos);
    }

    private EnumFacing getDefaultFacing(IBlockAccess world, BlockPos pos, IBlockState state) {
        if (world != null) {
            Iterator iterator = EnumFacing.Plane.VERTICAL.iterator();
            boolean vertical = false;
            do {
                EnumFacing facing;
                IBlockState stateOff;
                Block block;
                if (!iterator.hasNext()) {
                    vertical = true;
                    iterator = EnumFacing.Plane.HORIZONTAL.iterator();
                }
                if (!(block = (stateOff = world.func_180495_p(pos.func_177972_a(facing = (EnumFacing)iterator.next()))).func_177230_c()).func_149730_j(stateOff)) continue;
                return facing;
            } while (iterator.hasNext() || !vertical);
        }
        return EnumFacing.DOWN;
    }

    public static void setState(boolean active, World worldIn, BlockPos pos) {
        IBlockState iblockstate = worldIn.func_180495_p(pos);
        TileEntity tileentity = worldIn.func_175625_s(pos);
        keepInventory = true;
        if (active) {
            worldIn.func_180501_a(pos, Calculator.gas_lantern_on.func_176223_P().func_177226_a((IProperty)DIR, iblockstate.func_177229_b((IProperty)DIR)), 3);
        } else {
            worldIn.func_180501_a(pos, Calculator.gas_lantern_off.func_176223_P().func_177226_a((IProperty)DIR, iblockstate.func_177229_b((IProperty)DIR)), 3);
        }
        keepInventory = false;
        if (tileentity != null) {
            tileentity.func_145829_t();
            worldIn.func_175690_a(pos, tileentity);
        }
    }

    @Deprecated
    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        EnumFacing dir = this.getDefaultFacing(world, pos, state);
        return new AxisAlignedBB((double)(0.3f + (float)dir.func_82601_c() * 0.32f), (double)(0.0f + this.getY(dir)), (double)(0.3f + (float)dir.func_82599_e() * 0.32f), (double)(0.7f + (float)dir.func_82601_c() * 0.32f), (double)(0.7f + this.getY(dir)), (double)(0.7f + (float)dir.func_82599_e() * 0.32f));
    }

    public float getY(EnumFacing meta) {
        if (meta == EnumFacing.DOWN) {
            return 0.0f;
        }
        return 0.1f;
    }

    public TileEntity func_149915_a(@Nonnull World var1, int var2) {
        return new TileEntityGasLantern();
    }

    @Nonnull
    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return Item.func_150898_a((Block)Calculator.gas_lantern_off);
    }

    public IBlockState func_176203_a(int meta) {
        EnumFacing enumfacing = EnumFacing.func_82600_a((int)meta);
        if (enumfacing.func_176740_k() == EnumFacing.Axis.Y) {
            enumfacing = EnumFacing.NORTH;
        }
        return this.func_176223_P().func_177226_a((IProperty)DIR, (Comparable)enumfacing);
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)DIR)).func_176745_a();
    }

    @Nonnull
    public IBlockState func_176221_a(@Nonnull IBlockState state, IBlockAccess world, BlockPos pos) {
        return state.func_177226_a((IProperty)DIR, (Comparable)this.getDefaultFacing(world, pos, state));
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{DIR});
    }

    static {
        DIR = PropertyDirection.func_177714_a((String)"dir");
    }
}

