/*
 * Decompiled with CFR 0.152.
 */
package sonar.calculator.mod.common.item.calculators.modules;

import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import sonar.calculator.mod.api.modules.IModule;
import sonar.calculator.mod.common.item.calculators.ModuleItemRegistry;
import sonar.core.api.energy.EnergyType;
import sonar.core.api.utils.ActionType;
import sonar.core.handlers.energy.EnergyTransferHandler;
import sonar.core.helpers.FontHelper;

public abstract class ModuleBase
implements IModule {
    public boolean isLoadable() {
        return true;
    }

    @Override
    public String getClientName(NBTTagCompound tag) {
        return this.getItemStack(tag).func_82833_r();
    }

    @Override
    public ItemStack getItemStack(NBTTagCompound tag) {
        Item item = (Item)ModuleItemRegistry.instance().getValue(this.getName());
        if (item != null) {
            ItemStack moduleStack = new ItemStack(item, 1);
            moduleStack.func_77982_d(tag);
            return moduleStack;
        }
        return ItemStack.field_190927_a;
    }

    protected final boolean isCreativeMode(Entity entity) {
        return entity instanceof EntityPlayer && ((EntityPlayer)entity).field_71075_bZ.field_75098_d;
    }

    protected final boolean isEnergyAvailable(ItemStack container, Entity entity, World world, int required) {
        boolean toReturn;
        boolean bl = toReturn = this.isCreativeMode(entity) || (long)required <= this.getEnergyStored(container, entity);
        if (!toReturn && entity instanceof EntityPlayer) {
            FontHelper.sendMessage((String)FontHelper.translate((String)"energy.notEnough"), (World)world, (EntityPlayer)((EntityPlayer)entity));
        }
        return toReturn;
    }

    protected final long receiveEnergy(ItemStack container, Entity entity, long maxReceive, boolean simulate) {
        return (int)EnergyTransferHandler.INSTANCE_SC.chargeItem(container, maxReceive, EnergyType.FE, ActionType.getTypeForAction((boolean)simulate));
    }

    protected final long extractEnergy(ItemStack container, Entity entity, long maxExtract, boolean simulate) {
        if (!this.isCreativeMode(entity)) {
            return EnergyTransferHandler.INSTANCE_SC.dischargeItem(container, maxExtract, EnergyType.FE, ActionType.getTypeForAction((boolean)simulate));
        }
        return 0L;
    }

    protected final long getEnergyStored(ItemStack container, Entity entity) {
        return EnergyTransferHandler.INSTANCE_SC.getEnergyStored(container, EnergyType.FE);
    }

    protected final long getMaxEnergyStored(ItemStack container, Entity entity) {
        return EnergyTransferHandler.INSTANCE_SC.getEnergyCapacity(container, EnergyType.FE);
    }
}

