/*
 * Decompiled with CFR 0.152.
 */
package sonar.calculator.mod.common.tileentity;

import java.util.List;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import sonar.calculator.mod.Calculator;
import sonar.calculator.mod.common.item.misc.CircuitBoard;
import sonar.calculator.mod.common.tileentity.TileEntityProcess;
import sonar.core.api.IFlexibleGui;
import sonar.core.handlers.inventories.handling.EnumFilterType;
import sonar.core.handlers.inventories.handling.filters.SlotHelper;
import sonar.core.recipes.ISonarRecipe;
import sonar.core.recipes.ISonarRecipeObject;
import sonar.core.recipes.RecipeHelperV2;

public abstract class TileEntityAbstractProcess
extends TileEntityProcess
implements IFlexibleGui {
    public final int inputSize;
    public final int outputSize;
    public final int baseProcess;
    public final int baseEnergy;

    public TileEntityAbstractProcess(int inputSize, int outputSize, int baseProcess, int baseEnergy) {
        this.inputSize = inputSize;
        this.outputSize = outputSize;
        this.baseProcess = baseProcess;
        this.baseEnergy = baseEnergy;
        int[] inputs = new int[inputSize];
        int[] outputs = new int[outputSize];
        for (int i = 0; i < inputSize; ++i) {
            inputs[i] = i;
        }
        for (int o = inputSize; o < inputSize + outputSize; ++o) {
            outputs[o - inputSize] = o + 1;
        }
        this.sides.input = inputs;
        this.sides.output = outputs;
        this.storage.setCapacity(50000).setMaxTransfer(32000);
        this.inv.setSize(1 + inputSize + outputSize);
        this.inv.getInsertFilters().put((SLOT, STACK, FACE) -> this.isInputSlot(SLOT) ? Boolean.valueOf(this.recipeHelper() == null || this.recipeHelper().isValidInput((Object)STACK)) : null, EnumFilterType.EXTERNAL_INTERNAL);
        this.inv.getInsertFilters().put(SlotHelper.dischargeSlot((int)inputSize), EnumFilterType.INTERNAL);
        this.inv.getInsertFilters().put((SLOT, STACK, FACE) -> !this.isOutputSlot(SLOT), EnumFilterType.EXTERNAL_INTERNAL);
        this.inv.getExtractFilters().put((SLOT, COUNT, FACE) -> this.isOutputSlot(SLOT), EnumFilterType.EXTERNAL);
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        this.discharge(this.inputSize);
    }

    public int inputSize() {
        return this.inputSize;
    }

    public int outputSize() {
        return this.outputSize;
    }

    public boolean isInputSlot(int slot) {
        return slot < this.inputSize();
    }

    public boolean isOutputSlot(int slot) {
        return slot >= this.inputSize() + 1;
    }

    public int getBaseProcessTime() {
        return this.baseProcess;
    }

    @Override
    public int getBaseEnergyUsage() {
        return this.baseEnergy;
    }

    public RecipeHelperV2 recipeHelper() {
        return null;
    }

    public ISonarRecipe getRecipe(ItemStack[] inputs) {
        return this.recipeHelper().getRecipeFromInputs(null, (Object[])inputs);
    }

    @Override
    public boolean canProcess() {
        if (((ItemStack)this.slots().get(0)).func_190926_b() || (Integer)this.cookTime.getObject() == 0 && this.storage.getEnergyLevel() < (long)this.requiredEnergy()) {
            return false;
        }
        ISonarRecipe recipe = this.getRecipe(this.inputStacks());
        if (recipe == null) {
            return false;
        }
        for (int o = 0; o < this.outputSize(); ++o) {
            if (((ISonarRecipeObject)recipe.outputs().get(o)).isNull()) {
                return false;
            }
            ItemStack outputStack = RecipeHelperV2.getItemStackFromList((List)recipe.outputs(), (int)o);
            ItemStack stackInSlot = (ItemStack)this.slots().get(o + this.inputSize() + 1);
            if (stackInSlot.func_190926_b()) continue;
            if (!stackInSlot.func_77969_a(outputStack)) {
                return false;
            }
            if (stackInSlot.func_190916_E() + outputStack.func_190916_E() <= stackInSlot.func_77976_d()) continue;
            return false;
        }
        return true;
    }

    public boolean isOutputVoided(int slot, ItemStack outputStack) {
        return false;
    }

    public int getMaxInputSize() {
        int size = 1;
        for (int i = 0; i < this.inputSize(); ++i) {
            size = ((ItemStack)this.slots().get(i)).func_190926_b() ? Math.max(size, ((ItemStack)this.slots().get(i)).func_190916_E()) : 0;
        }
        return size;
    }

    public int getMaxOutputSize() {
        int size = 1;
        ISonarRecipe recipe = this.getRecipe(this.inputStacks());
        for (int o = 0; o < this.outputSize(); ++o) {
            ISonarRecipeObject outputObject = (ISonarRecipeObject)recipe.outputs().get(o);
            size = ((ItemStack)this.slots().get(o + this.inputSize() + 1)).func_190926_b() && outputObject != null ? Math.max((this.func_70297_j_() - ((ItemStack)this.slots().get(o + this.inputSize() + 1)).func_190916_E()) / outputObject.getStackSize(), size) : 0;
        }
        return size;
    }

    @Override
    public void finishProcess() {
        ISonarRecipe recipe = this.getRecipe(this.inputStacks());
        if (recipe == null) {
            return;
        }
        for (int o = 0; o < Math.min(recipe.outputs().size(), this.outputSize()); ++o) {
            ISonarRecipeObject outputObject = (ISonarRecipeObject)recipe.outputs().get(o);
            ItemStack stack = RecipeHelperV2.getItemStackFromList((List)recipe.outputs(), (int)o);
            if (stack.func_190926_b() || this.isOutputVoided(o + this.inputSize() + 1, stack)) continue;
            ItemStack stackInSlot = (ItemStack)this.slots().get(o + this.inputSize() + 1);
            if (stackInSlot.func_190926_b()) {
                ItemStack outputStack = stack.func_77946_l();
                if (outputStack.func_77973_b() == Calculator.circuitBoard) {
                    CircuitBoard.setData(outputStack);
                }
                this.slots().set(o + this.inputSize() + 1, outputStack);
                continue;
            }
            if (!stackInSlot.func_77969_a(stack)) continue;
            stackInSlot.func_190917_f(outputObject.getStackSize());
        }
        for (int i = 0; i < Math.min(recipe.inputs().size(), this.inputSize()); ++i) {
            ItemStack itemstack2;
            ItemStack input = ((ItemStack)this.slots().get(i)).func_77946_l();
            int shrinkSize = this.recipeHelper() != null ? ((ISonarRecipeObject)recipe.inputs().get(i)).getStackSize() : 1;
            boolean hasContainer = input.func_190916_E() - shrinkSize <= 0;
            ((ItemStack)this.slots().get(i)).func_190918_g(shrinkSize);
            if (!hasContainer || !input.func_77973_b().hasContainerItem(input) || !this.func_94041_b(i, itemstack2 = input.func_77973_b().getContainerItem(input))) continue;
            if (this.inv.getStackInSlot(i).func_190926_b()) {
                this.inv.setStackInSlot(i, itemstack2);
                continue;
            }
            InventoryHelper.func_180173_a((World)this.func_145831_w(), (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), (ItemStack)itemstack2);
        }
    }

    public ItemStack[] inputStacks() {
        ItemStack[] input = new ItemStack[this.inputSize()];
        for (int i = 0; i < this.inputSize(); ++i) {
            input[i] = (ItemStack)this.slots().get(i);
        }
        return input;
    }
}

