/*
 * Decompiled with CFR 0.152.
 */
package sonar.calculator.mod.common.tileentity;

import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import sonar.calculator.mod.Calculator;
import sonar.calculator.mod.CalculatorConfig;
import sonar.calculator.mod.client.gui.machines.GuiDualOutputSmelting;
import sonar.calculator.mod.client.gui.machines.GuiSmeltingBlock;
import sonar.calculator.mod.common.containers.ContainerDualOutputSmelting;
import sonar.calculator.mod.common.containers.ContainerSmeltingBlock;
import sonar.calculator.mod.common.item.misc.CircuitBoard;
import sonar.calculator.mod.common.recipes.AlgorithmSeparatorRecipes;
import sonar.calculator.mod.common.recipes.ExtractionChamberRecipes;
import sonar.calculator.mod.common.recipes.PrecisionChamberRecipes;
import sonar.calculator.mod.common.recipes.ProcessingChamberRecipes;
import sonar.calculator.mod.common.recipes.ReassemblyChamberRecipes;
import sonar.calculator.mod.common.recipes.RestorationChamberRecipes;
import sonar.calculator.mod.common.recipes.StoneSeparatorRecipes;
import sonar.calculator.mod.common.tileentity.TileEntityAbstractProcess;
import sonar.core.handlers.inventories.handling.EnumFilterType;
import sonar.core.recipes.RecipeHelperV2;

public class TileEntityMachine {

    public static class PrecisionChamber
    extends DualOutput {
        public PrecisionChamber() {
            super(1, 2, CalculatorConfig.PRECISION_CHAMBER_SPEED, CalculatorConfig.PRECISION_CHAMBER_USAGE);
            this.storage.setCapacity(CalculatorConfig.PRECISION_CHAMBER_STORAGE);
            this.storage.setMaxTransfer(CalculatorConfig.PRECISION_CHAMBER_TRANSFER_RATE);
            this.upgrades = this.upgrades.setAllowed(16, new Object[]{"ENERGY", "SPEED", "TRANSFER", "VOID"}).addMaxiumum("TRANSFER", 1).addMaxiumum("VOID", 1);
        }

        @Override
        public RecipeHelperV2 recipeHelper() {
            return PrecisionChamberRecipes.instance();
        }

        @Override
        public Object getClientElement(Object obj, int id, World world, EntityPlayer player, NBTTagCompound tag) {
            return new GuiDualOutputSmelting.PrecisionChamber(player.field_71071_by, this);
        }

        @Override
        public boolean isOutputVoided(int slot, ItemStack outputStack) {
            return slot == 2 && this.upgrades.getUpgradesInstalled("VOID") == 1;
        }
    }

    public static class ExtractionChamber
    extends DualOutput {
        public ExtractionChamber() {
            super(1, 2, CalculatorConfig.EXTRACTION_CHAMBER_SPEED, CalculatorConfig.EXTRACTION_CHAMBER_USAGE);
            this.storage.setCapacity(CalculatorConfig.EXTRACTION_CHAMBER_STORAGE);
            this.storage.setMaxTransfer(CalculatorConfig.EXTRACTION_CHAMBER_TRANSFER_RATE);
            this.upgrades = this.upgrades.setAllowed(16, new Object[]{"ENERGY", "SPEED", "TRANSFER", "VOID"}).addMaxiumum("TRANSFER", 1).addMaxiumum("VOID", 1);
        }

        @Override
        public RecipeHelperV2 recipeHelper() {
            return ExtractionChamberRecipes.instance();
        }

        @Override
        public Object getClientElement(Object obj, int id, World world, EntityPlayer player, NBTTagCompound tag) {
            return new GuiDualOutputSmelting.ExtractionChamber(player.field_71071_by, this);
        }

        @Override
        public boolean isOutputVoided(int slot, ItemStack outputStack) {
            return slot == 2 && this.upgrades.getUpgradesInstalled("VOID") == 1;
        }
    }

    public static class AlgorithmSeparator
    extends DualOutput {
        public AlgorithmSeparator() {
            super(1, 2, CalculatorConfig.ALGORITHM_SEPERATOR_SPEED, CalculatorConfig.ALGORITHM_SEPERATOR_USAGE);
            this.storage.setCapacity(CalculatorConfig.ALGORITHM_SEPERATOR_STORAGE);
            this.storage.setMaxTransfer(CalculatorConfig.ALGORITHM_SEPERATOR_TRANSFER_RATE);
        }

        @Override
        public RecipeHelperV2 recipeHelper() {
            return AlgorithmSeparatorRecipes.instance();
        }

        @Override
        public Object getClientElement(Object obj, int id, World world, EntityPlayer player, NBTTagCompound tag) {
            return new GuiDualOutputSmelting.AlgorithmSeperator(player.field_71071_by, this);
        }
    }

    public static class ProcessingChamber
    extends SingleOutput {
        public ProcessingChamber() {
            super(1, 1, CalculatorConfig.PROCESSING_CHAMBER_SPEED, CalculatorConfig.PROCESSING_CHAMBER_USAGE);
            this.storage.setCapacity(CalculatorConfig.PROCESSING_CHAMBER_STORAGE);
            this.storage.setMaxTransfer(CalculatorConfig.PROCESSING_CHAMBER_TRANSFER_RATE);
        }

        @Override
        public RecipeHelperV2 recipeHelper() {
            return ProcessingChamberRecipes.instance();
        }

        @Override
        public Object getClientElement(Object obj, int id, World world, EntityPlayer player, NBTTagCompound tag) {
            return new GuiSmeltingBlock.ProcessingChamber(player.field_71071_by, this);
        }
    }

    public static class RestorationChamber
    extends SingleOutput {
        public RestorationChamber() {
            super(1, 1, CalculatorConfig.RESTORATION_CHAMBER_SPEED, CalculatorConfig.RESTORATION_CHAMBER_USAGE);
            this.storage.setCapacity(CalculatorConfig.RESTORATION_CHAMBER_STORAGE);
            this.storage.setMaxTransfer(CalculatorConfig.RESTORATION_CHAMBER_TRANSFER_RATE);
        }

        @Override
        public RecipeHelperV2 recipeHelper() {
            return RestorationChamberRecipes.instance();
        }

        @Override
        public Object getClientElement(Object obj, int id, World world, EntityPlayer player, NBTTagCompound tag) {
            return new GuiSmeltingBlock.RestorationChamber(player.field_71071_by, this);
        }
    }

    public static class ReassemblyChamber
    extends SingleOutput {
        public ReassemblyChamber() {
            super(1, 1, CalculatorConfig.REASSEMBLY_CHAMBER_SPEED, CalculatorConfig.REASSEMBLY_CHAMBER_USAGE);
            this.storage.setCapacity(CalculatorConfig.REASSEMBLY_CHAMBER_STORAGE);
            this.storage.setMaxTransfer(CalculatorConfig.REASSEMBLY_CHAMBER_TRANSFER_RATE);
        }

        @Override
        public RecipeHelperV2 recipeHelper() {
            return ReassemblyChamberRecipes.instance();
        }

        @Override
        public Object getClientElement(Object obj, int id, World world, EntityPlayer player, NBTTagCompound tag) {
            return new GuiSmeltingBlock.ReassemblyChamber(player.field_71071_by, this);
        }
    }

    public static class StoneSeparator
    extends DualOutput {
        public StoneSeparator() {
            super(1, 2, CalculatorConfig.STONE_SEPERATOR_SPEED, CalculatorConfig.STONE_SEPERATOR_USAGE);
            this.storage.setCapacity(CalculatorConfig.STONE_SEPERATOR_STORAGE);
            this.storage.setMaxTransfer(CalculatorConfig.STONE_SEPERATOR_TRANSFER_RATE);
        }

        @Override
        public RecipeHelperV2 recipeHelper() {
            return StoneSeparatorRecipes.instance();
        }

        @Override
        public Object getClientElement(Object obj, int id, World world, EntityPlayer player, NBTTagCompound tag) {
            return new GuiDualOutputSmelting.StoneSeperator(player.field_71071_by, this);
        }
    }

    public static class ReinforcedFurnace
    extends SingleOutput {
        public ReinforcedFurnace() {
            super(1, 1, CalculatorConfig.REINFORCED_FURNACE_SPEED, CalculatorConfig.REINFORCED_FURNACE_USAGE);
            this.inv.getInsertFilters().put((SLOT, STACK, FACE) -> SLOT < this.inputSize(), EnumFilterType.EXTERNAL);
        }

        @Override
        public Object getClientElement(Object obj, int id, World world, EntityPlayer player, NBTTagCompound tag) {
            return new GuiSmeltingBlock.ReinforcedFurnace(player.field_71071_by, this);
        }

        @Nonnull
        public ItemStack getFurnaceOutput(ItemStack stack) {
            if (!stack.func_190926_b()) {
                return FurnaceRecipes.func_77602_a().func_151395_a(stack);
            }
            return ItemStack.field_190927_a;
        }

        @Override
        public boolean canProcess() {
            if (this.slots().get(0) == null || (Integer)this.cookTime.getObject() == 0 && this.storage.getEnergyLevel() < (long)this.requiredEnergy()) {
                return false;
            }
            ItemStack result = this.getFurnaceOutput(this.inputStacks()[0]);
            if (result.func_190926_b()) {
                return false;
            }
            for (int o = 0; o < this.outputSize(); ++o) {
                ItemStack output = (ItemStack)this.slots().get(o + this.inputSize() + 1);
                if (output.func_190926_b()) continue;
                if (!output.func_77969_a(result)) {
                    return false;
                }
                if (output.func_190916_E() + result.func_190916_E() <= output.func_77976_d()) continue;
                return false;
            }
            return true;
        }

        @Override
        public void finishProcess() {
            ItemStack stack = this.getFurnaceOutput(this.inputStacks()[0]);
            if (!stack.func_190926_b()) {
                ItemStack currentO = (ItemStack)this.slots().get(this.inputSize() + 1);
                if (currentO.func_190926_b()) {
                    ItemStack outputStack = stack.func_77946_l();
                    if (outputStack.func_77973_b() == Calculator.circuitBoard) {
                        CircuitBoard.setData(outputStack);
                    }
                    this.slots().set(this.inputSize() + 1, outputStack);
                } else if (currentO.func_77969_a(stack)) {
                    currentO.func_190917_f(stack.func_190916_E());
                }
            }
            ((ItemStack)this.slots().get(0)).func_190918_g(1);
        }
    }

    public static abstract class SingleOutput
    extends TileEntityAbstractProcess {
        public SingleOutput(int inputSize, int outputSize, int baseProcess, int baseEnergy) {
            super(inputSize, outputSize, baseProcess, baseEnergy);
        }

        public Object getServerElement(Object obj, int id, World world, EntityPlayer player, NBTTagCompound tag) {
            return new ContainerSmeltingBlock(player.field_71071_by, this);
        }

        public Object getClientElement(Object obj, int id, World world, EntityPlayer player, NBTTagCompound tag) {
            return new GuiSmeltingBlock(player.field_71071_by, this);
        }
    }

    public static class DualOutput
    extends TileEntityAbstractProcess {
        public DualOutput(int inputSize, int outputSize, int baseProcess, int baseEnergy) {
            super(inputSize, outputSize, baseProcess, baseEnergy);
        }

        public Object getServerElement(Object obj, int id, World world, EntityPlayer player, NBTTagCompound tag) {
            return new ContainerDualOutputSmelting(player.field_71071_by, this);
        }

        public Object getClientElement(Object obj, int id, World world, EntityPlayer player, NBTTagCompound tag) {
            return new GuiDualOutputSmelting(player.field_71071_by, this);
        }
    }
}

