/*
 * Decompiled with CFR 0.152.
 */
package sonar.calculator.mod.common.tileentity;

import com.google.common.collect.Lists;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.IItemHandler;
import sonar.calculator.mod.common.tileentity.TileEntityMachine;
import sonar.core.SonarCore;
import sonar.core.api.inventories.IAdditionalInventory;
import sonar.core.api.machines.IPausable;
import sonar.core.api.machines.IProcessMachine;
import sonar.core.api.upgrades.IUpgradableTile;
import sonar.core.common.tileentity.TileEntityEnergySidedInventory;
import sonar.core.handlers.inventories.handling.ItemTransferHelper;
import sonar.core.helpers.FontHelper;
import sonar.core.helpers.NBTHelper;
import sonar.core.network.sync.IDirtyPart;
import sonar.core.network.sync.SyncTagType;
import sonar.core.network.utils.IByteBufTile;
import sonar.core.upgrades.UpgradeInventory;
import sonar.core.utils.MachineSideConfig;

public abstract class TileEntityProcess
extends TileEntityEnergySidedInventory
implements IUpgradableTile,
IPausable,
IAdditionalInventory,
IProcessMachine,
IByteBufTile {
    public float renderTicks;
    public double energyBuffer;
    public SyncTagType.BOOLEAN invertPaused = new SyncTagType.BOOLEAN(0);
    public SyncTagType.BOOLEAN paused = new SyncTagType.BOOLEAN(1);
    public SyncTagType.INT cookTime = new SyncTagType.INT(2);
    public UpgradeInventory upgrades = new UpgradeInventory(3, 16, new Object[]{"ENERGY", "SPEED", "TRANSFER"}).addMaxiumum("TRANSFER", 1);
    public boolean isActive;
    private ProcessState state = ProcessState.UNKNOWN;
    private int currentProcessTime = -1;
    public static int lowestSpeed = 4;
    public static int lowestEnergy = 1000;
    public int currentSpeed;

    public TileEntityProcess() {
        this.syncList.addParts(new IDirtyPart[]{this.paused, this.invertPaused, this.cookTime, this.upgrades});
    }

    public abstract boolean canProcess();

    public abstract void finishProcess();

    public void func_73660_a() {
        super.func_73660_a();
        if (this.isServer()) {
            if (this.upgrades.getUpgradesInstalled("TRANSFER") > 0) {
                this.transferItems();
            }
            if (!this.isPaused()) {
                boolean forceUpdate = false;
                if (this.getProcessState().canProcess()) {
                    if ((Integer)this.cookTime.getObject() >= this.getProcessTime()) {
                        this.finishProcess();
                        this.cookTime.setObject((Object)0);
                        this.energyBuffer = 0.0;
                        forceUpdate = true;
                    } else if ((Integer)this.cookTime.getObject() > 0) {
                        this.cookTime.increaseBy(1);
                        this.modifyEnergy();
                    } else if ((Integer)this.cookTime.getObject() == 0) {
                        this.cookTime.increaseBy(1);
                        this.modifyEnergy();
                        forceUpdate = true;
                    }
                } else {
                    this.renderTicks = 0.0f;
                    if ((Integer)this.cookTime.getObject() != 0) {
                        this.cookTime.setObject((Object)0);
                        this.energyBuffer = 0.0;
                        SonarCore.sendPacketAround((TileEntity)this, (int)128, (int)2);
                        forceUpdate = true;
                    }
                }
                if (forceUpdate) {
                    this.isActive = this.isActive();
                    SonarCore.sendPacketAround((TileEntity)this, (int)128, (int)2);
                    this.field_145850_b.func_175641_c(this.field_174879_c, this.func_145838_q(), 1, 1);
                }
            }
        } else if (!this.isPaused()) {
            if (this.getProcessState().canProcess()) {
                this.renderTicks();
                this.cookTime.increaseBy(1);
            } else if ((Integer)this.cookTime.getObject() != 0) {
                this.renderTicks = 0.0f;
                this.cookTime.setObject((Object)0);
            }
        }
    }

    public ProcessState getProcessState() {
        this.state = this.canProcess() ? ProcessState.TRUE : ProcessState.FALSE;
        return this.state;
    }

    public void resetProcessState() {
        this.state = ProcessState.UNKNOWN;
        this.currentProcessTime = -1;
    }

    public void transferItems() {
        ArrayList outputs = this.sides.getSidesWithConfig(MachineSideConfig.OUTPUT);
        for (EnumFacing side : outputs) {
            IItemHandler handler = ItemTransferHelper.getItemHandlerOffset((World)this.field_145850_b, (BlockPos)this.func_174877_v(), (EnumFacing)side);
            if (handler == null) continue;
            ItemTransferHelper.doSimpleTransfer((Iterable)Lists.newArrayList((Object[])new IItemHandler[]{this.inv.getItemHandler(side)}), (Iterable)Lists.newArrayList((Object[])new IItemHandler[]{handler}), IS -> !IS.func_190926_b(), (int)4);
        }
    }

    public void onFirstTick() {
        super.onFirstTick();
        if (!this.field_145850_b.field_72995_K) {
            this.isActive = this.isActive();
            SonarCore.sendPacketAround((TileEntity)this, (int)128, (int)2);
            this.field_145850_b.func_175641_c(this.field_174879_c, this.func_145838_q(), 1, 1);
        }
    }

    public void modifyEnergy() {
        this.energyBuffer += this.getEnergyUsage();
        int energyUsage = (int)Math.floor(this.energyBuffer);
        this.energyBuffer = this.energyBuffer - (double)energyUsage < 0.0 ? 0.0 : (this.energyBuffer -= (double)energyUsage);
        this.storage.modifyEnergyStored((long)(-energyUsage));
    }

    public void renderTicks() {
        this.renderTicks = this instanceof TileEntityMachine.PrecisionChamber || this instanceof TileEntityMachine.ExtractionChamber ? (this.renderTicks += (float)Math.max(1, this.upgrades.getUpgradesInstalled("SPEED")) / 50.0f) : (this.renderTicks += (float)Math.max(1, this.upgrades.getUpgradesInstalled("SPEED") * 8) / 1000.0f);
        if (this.renderTicks >= 2.0f) {
            this.renderTicks = 0.0f;
        }
    }

    public float getRenderPosition() {
        return this.renderTicks < 1.0f ? this.renderTicks : 1.0f - (this.renderTicks - 1.0f);
    }

    private int roundNumber(double i) {
        return (int)(Math.ceil(i / 10.0) * 10.0);
    }

    public int requiredEnergy() {
        int speed = this.upgrades.getUpgradesInstalled("SPEED");
        int energy = this.upgrades.getUpgradesInstalled("ENERGY");
        float i = (float)((double)speed / 16.0) * (float)this.getBaseEnergyUsage();
        float e = (float)((double)energy / 16.0) * (float)this.getBaseEnergyUsage();
        return (int)((float)this.getBaseEnergyUsage() + i - e);
    }

    public boolean func_145842_c(int action, int param) {
        if (action == 1) {
            this.markBlockForUpdate();
        }
        return true;
    }

    public void readData(NBTTagCompound nbt, NBTHelper.SyncType type) {
        super.readData(nbt, type);
        if (type.isType(new NBTHelper.SyncType[]{NBTHelper.SyncType.DEFAULT_SYNC, NBTHelper.SyncType.SAVE}) && type.isType(new NBTHelper.SyncType[]{NBTHelper.SyncType.DEFAULT_SYNC})) {
            this.currentSpeed = nbt.func_74762_e("speed");
        }
    }

    public NBTTagCompound writeData(NBTTagCompound nbt, NBTHelper.SyncType type) {
        if (this.isServer() && this.forceSync) {
            SonarCore.sendPacketAround((TileEntity)this, (int)128, (int)2);
        }
        super.writeData(nbt, type);
        if (type.isType(new NBTHelper.SyncType[]{NBTHelper.SyncType.DEFAULT_SYNC, NBTHelper.SyncType.SAVE}) && type.isType(new NBTHelper.SyncType[]{NBTHelper.SyncType.DEFAULT_SYNC})) {
            nbt.func_74768_a("speed", this.getProcessTime());
        }
        return nbt;
    }

    public UpgradeInventory getUpgradeInventory() {
        return this.upgrades;
    }

    public boolean isActive() {
        if (this.field_145850_b.field_72995_K) {
            return this.isActive;
        }
        return !this.isPaused() && (Integer)this.cookTime.getObject() > 0;
    }

    public void onPause() {
        this.markBlockForUpdate();
        this.field_145850_b.func_175641_c(this.field_174879_c, this.field_145854_h, 1, 1);
    }

    public boolean isPaused() {
        return (Boolean)this.invertPaused.getObject();
    }

    public boolean canStack(ItemStack current, ItemStack stack) {
        if (current.func_190926_b()) {
            return true;
        }
        return current.func_190916_E() != current.func_77976_d();
    }

    @SideOnly(value=Side.CLIENT)
    public List<String> getWailaInfo(List<String> currenttip, IBlockState state) {
        int speed = this.upgrades.getUpgradesInstalled("SPEED");
        int energy = this.upgrades.getUpgradesInstalled("ENERGY");
        if (speed != 0) {
            currenttip.add(FontHelper.translate((String)"circuit.speed") + ": " + speed);
        }
        if (energy != 0) {
            currenttip.add(FontHelper.translate((String)"circuit.energy") + ": " + energy);
        }
        return currenttip;
    }

    public ItemStack[] getAdditionalStacks() {
        ArrayList drops = this.upgrades.getDrops();
        if (drops == null || drops.isEmpty()) {
            return new ItemStack[]{ItemStack.field_190927_a};
        }
        ItemStack[] toDrop = new ItemStack[drops.size()];
        int pos = 0;
        for (ItemStack drop : drops) {
            if (!drop.func_190926_b()) {
                toDrop[pos] = drop;
            }
            ++pos;
        }
        return toDrop;
    }

    public abstract int getBaseEnergyUsage();

    public int getCurrentProcessTime() {
        return (Integer)this.cookTime.getObject();
    }

    public int getProcessTime() {
        int speed = this.upgrades.getUpgradesInstalled("SPEED");
        int energy = this.upgrades.getUpgradesInstalled("ENERGY");
        double i = (double)speed / 17.0 * (double)this.getBaseProcessTime();
        if (speed == 16) {
            this.currentProcessTime = 8;
            return 8;
        }
        this.currentProcessTime = (int)Math.max((double)this.getBaseProcessTime() - i, (double)lowestSpeed);
        return this.currentProcessTime;
    }

    public double getEnergyUsage() {
        return (double)this.requiredEnergy() / (double)this.getProcessTime();
    }

    public void markChanged(IDirtyPart part) {
        super.markChanged(part);
        if (this.isServer() && (part == this.inv || part == this.upgrades)) {
            this.resetProcessState();
        }
    }

    public void writePacket(ByteBuf buf, int id) {
        if (id == 1) {
            this.invertPaused.invert();
            this.invertPaused.writeToBuf(buf);
        }
        if (id == 2) {
            this.invertPaused.writeToBuf(buf);
            this.paused.writeToBuf(buf);
            this.cookTime.writeToBuf(buf);
            buf.writeBoolean(this.isActive());
        }
    }

    public void readPacket(ByteBuf buf, int id) {
        if (id == 0) {
            ItemStack[] upgrades = this.getAdditionalStacks();
            Random rand = new Random();
            for (ItemStack stack : upgrades) {
                if (stack.func_190926_b()) continue;
                float f = rand.nextFloat() * 0.8f + 0.1f;
                float f1 = rand.nextFloat() * 0.8f + 0.1f;
                float f2 = rand.nextFloat() * 0.8f + 0.1f;
                EntityItem dropStack = new EntityItem(this.func_145831_w(), (double)((float)this.field_174879_c.func_177958_n() + f), (double)((float)this.field_174879_c.func_177956_o() + f1), (double)((float)this.field_174879_c.func_177952_p() + f2), stack);
                this.func_145831_w().func_72838_d((Entity)dropStack);
            }
        }
        if (id == 1) {
            this.invertPaused.readFromBuf(buf);
        }
        if (id == 2) {
            this.invertPaused.readFromBuf(buf);
            this.paused.readFromBuf(buf);
            this.cookTime.readFromBuf(buf);
            this.isActive = buf.readBoolean();
        }
    }

    public static enum ProcessState {
        TRUE,
        FALSE,
        UNKNOWN;


        public boolean canProcess() {
            return this == TRUE;
        }
    }
}

