/*
 * Decompiled with CFR 0.152.
 */
package sonar.calculator.mod.common.tileentity.generators;

import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import sonar.calculator.mod.CalculatorConfig;
import sonar.calculator.mod.api.machines.ICalculatorGenerator;
import sonar.calculator.mod.client.gui.generators.GuiExtractor;
import sonar.calculator.mod.common.containers.ContainerGenerator;
import sonar.calculator.mod.common.recipes.GlowstoneExtractorRecipes;
import sonar.calculator.mod.common.recipes.RedstoneExtractorRecipes;
import sonar.calculator.mod.common.recipes.StarchExtractorRecipes;
import sonar.core.api.IFlexibleGui;
import sonar.core.api.energy.EnergyMode;
import sonar.core.api.utils.ActionType;
import sonar.core.common.tileentity.TileEntityEnergyInventory;
import sonar.core.handlers.inventories.handling.EnumFilterType;
import sonar.core.handlers.inventories.handling.filters.SlotHelper;
import sonar.core.helpers.FontHelper;
import sonar.core.helpers.SonarHelper;
import sonar.core.network.sync.IDirtyPart;
import sonar.core.network.sync.SyncTagType;

public abstract class TileEntityGenerator
extends TileEntityEnergyInventory
implements IFlexibleGui,
ICalculatorGenerator {
    public SyncTagType.INT itemLevel = new SyncTagType.INT(0);
    public SyncTagType.INT burnTime = new SyncTagType.INT(1);
    public SyncTagType.INT maxBurnTime = new SyncTagType.INT(2);
    public int GENERATOR_CAPACITY;
    public int GENERATOR_REQUIRED;
    public int ENERGY_PER_TICK;
    private static final int[] slotsTop = new int[]{0};
    private static final int[] slotsBottom = new int[]{2, 1};
    private static final int[] slotsSides = new int[]{1};

    public TileEntityGenerator() {
        this.inv.setSize(2);
        this.inv.getInsertFilters().put((SLOT, STACK, FACE) -> FACE == EnumFacing.UP ? Boolean.valueOf(SonarHelper.intContains((int[])slotsSides, (int)SLOT)) : null, EnumFilterType.EXTERNAL);
        this.inv.getInsertFilters().put((SLOT, STACK, FACE) -> FACE != EnumFacing.UP ? Boolean.valueOf(SonarHelper.intContains((int[])slotsTop, (int)SLOT)) : null, EnumFilterType.EXTERNAL);
        this.inv.getInsertFilters().put(SlotHelper.filterSlot((int)0, s -> TileEntityFurnace.func_145954_b((ItemStack)s)), EnumFilterType.EXTERNAL_INTERNAL);
        this.inv.getInsertFilters().put(SlotHelper.filterSlot((int)1, s -> this.getItemValue((ItemStack)s) > 0), EnumFilterType.EXTERNAL_INTERNAL);
        this.inv.getExtractFilters().put((SLOT, COUNT, FACE) -> FACE == EnumFacing.DOWN && this.inv.getStackInSlot(SLOT).func_77973_b() == Items.field_151133_ar, EnumFilterType.EXTERNAL);
        this.energyMode = EnergyMode.SEND;
        this.syncList.addParts(new IDirtyPart[]{this.itemLevel, this.burnTime, this.maxBurnTime});
    }

    public void func_73660_a() {
        super.func_73660_a();
        if (!this.field_145850_b.field_72995_K) {
            this.processItemLevel();
            this.generateEnergy();
            this.addEnergy(EnumFacing.field_82609_l);
        }
        this.func_70296_d();
    }

    public void generateEnergy() {
        int itemBurnTime;
        ItemStack stack = this.func_70301_a(0);
        if (!stack.func_190926_b() && (Integer)this.burnTime.getObject() == 0 && TileEntityFurnace.func_145954_b((ItemStack)stack) && this.storage.getEnergyLevel() != this.storage.getFullCapacity() && (Integer)this.itemLevel.getObject() >= this.GENERATOR_REQUIRED && (itemBurnTime = TileEntityFurnace.func_145952_a((ItemStack)stack)) != 0) {
            this.maxBurnTime.setObject((Object)itemBurnTime);
            this.burnTime.increaseBy(1);
            ItemStack burnStack = (ItemStack)this.slots().get(0);
            if (!burnStack.func_190926_b()) {
                if (burnStack.func_190916_E() == 1) {
                    ItemStack container = burnStack.func_77973_b().getContainerItem(burnStack);
                    this.inv.setStackInSlot(0, container);
                } else {
                    burnStack.func_190918_g(1);
                }
            }
        }
        if ((Integer)this.burnTime.getObject() > 0 && (Integer)this.burnTime.getObject() < (Integer)this.maxBurnTime.getObject()) {
            this.storage.addEnergy((long)this.ENERGY_PER_TICK, null, ActionType.PERFORM);
            this.burnTime.increaseBy(1);
        }
        if ((Integer)this.maxBurnTime.getObject() != 0 && (Integer)this.burnTime.getObject() >= (Integer)this.maxBurnTime.getObject()) {
            this.storage.addEnergy((long)this.ENERGY_PER_TICK, null, ActionType.PERFORM);
            this.burnTime.setObject((Object)0);
            this.removeItem(this.GENERATOR_REQUIRED);
        }
    }

    public void processItemLevel() {
        ItemStack stack = (ItemStack)this.slots().get(1);
        if (stack.func_190926_b() || this.getItemValue(stack) <= 0) {
            return;
        }
        if ((Integer)this.itemLevel.getObject() + this.getItemValue(stack) <= this.GENERATOR_CAPACITY) {
            this.addItem(this.getItemValue(stack));
            stack.func_190918_g(1);
        }
    }

    public abstract int getItemValue(ItemStack var1);

    public void addItem(int add) {
        this.itemLevel.increaseBy(add);
    }

    public void removeItem(int remove) {
        this.itemLevel.increaseBy(-remove);
    }

    @Override
    public int getItemLevel() {
        return (Integer)this.itemLevel.getObject();
    }

    @Override
    public int getMaxItemLevel() {
        return this.GENERATOR_CAPACITY;
    }

    public Object getServerElement(Object obj, int id, World world, EntityPlayer player, NBTTagCompound tag) {
        return new ContainerGenerator(player.field_71071_by, this);
    }

    public static class GlowstoneExtractor
    extends TileEntityGenerator {
        public GlowstoneExtractor() {
            this.ENERGY_PER_TICK = CalculatorConfig.GLOWSTONE_EXTRACTOR_PER_TICK;
            this.GENERATOR_CAPACITY = CalculatorConfig.GLOWSTONE_EXTRACTOR_GENERATOR_CAPACITY;
            this.GENERATOR_REQUIRED = CalculatorConfig.GLOWSTONE_EXTRACTOR_GENERATOR_REQUIRED;
            this.storage.setCapacity(CalculatorConfig.GLOWSTONE_EXTRACTOR_STORAGE);
            this.storage.setMaxTransfer(CalculatorConfig.GLOWSTONE_EXTRACTOR_TRANSFER_RATE);
        }

        @Override
        public int getItemValue(ItemStack stack) {
            return GlowstoneExtractorRecipes.instance().getValue(null, new Object[]{stack});
        }

        @SideOnly(value=Side.CLIENT)
        public List<String> getWailaInfo(List<String> currenttip, IBlockState state) {
            currenttip.add(FontHelper.translate((String)"generator.glowstone") + ": " + (Integer)this.itemLevel.getObject() * 100 / this.GENERATOR_CAPACITY + '%');
            return currenttip;
        }

        public Object getClientElement(Object obj, int id, World world, EntityPlayer player, NBTTagCompound tag) {
            return new GuiExtractor.Glowstone(player.field_71071_by, this);
        }
    }

    public static class RedstoneExtractor
    extends TileEntityGenerator {
        public RedstoneExtractor() {
            this.ENERGY_PER_TICK = CalculatorConfig.REDSTONE_EXTRACTOR_PER_TICK;
            this.GENERATOR_CAPACITY = CalculatorConfig.REDSTONE_EXTRACTOR_GENERATOR_CAPACITY;
            this.GENERATOR_REQUIRED = CalculatorConfig.REDSTONE_EXTRACTOR_GENERATOR_REQUIRED;
            this.storage.setCapacity(CalculatorConfig.REDSTONE_EXTRACTOR_STORAGE);
            this.storage.setMaxTransfer(CalculatorConfig.REDSTONE_EXTRACTOR_TRANSFER_RATE);
        }

        @Override
        public int getItemValue(ItemStack stack) {
            return RedstoneExtractorRecipes.instance().getValue(null, new Object[]{stack});
        }

        @SideOnly(value=Side.CLIENT)
        public List<String> getWailaInfo(List<String> currenttip, IBlockState state) {
            currenttip.add(FontHelper.translate((String)"generator.redstone") + ": " + (Integer)this.itemLevel.getObject() * 100 / this.GENERATOR_CAPACITY + '%');
            return currenttip;
        }

        public Object getClientElement(Object obj, int id, World world, EntityPlayer player, NBTTagCompound tag) {
            return new GuiExtractor.Redstone(player.field_71071_by, this);
        }
    }

    public static class StarchExtractor
    extends TileEntityGenerator {
        public StarchExtractor() {
            this.ENERGY_PER_TICK = CalculatorConfig.STARCH_EXTRACTOR_PER_TICK;
            this.GENERATOR_CAPACITY = CalculatorConfig.STARCH_EXTRACTOR_GENERATOR_CAPACITY;
            this.GENERATOR_REQUIRED = CalculatorConfig.STARCH_EXTRACTOR_GENERATOR_REQUIRED;
            this.storage.setCapacity(CalculatorConfig.STARCH_EXTRACTOR_STORAGE);
            this.storage.setMaxTransfer(CalculatorConfig.STARCH_EXTRACTOR_TRANSFER_RATE);
        }

        @SideOnly(value=Side.CLIENT)
        public List<String> getWailaInfo(List<String> currenttip, IBlockState state) {
            currenttip.add(FontHelper.translate((String)"generator.starch") + ": " + (Integer)this.itemLevel.getObject() * 100 / this.GENERATOR_CAPACITY + '%');
            return currenttip;
        }

        @Override
        public int getItemValue(ItemStack stack) {
            return StarchExtractorRecipes.instance().getValue(null, new Object[]{stack});
        }

        public Object getClientElement(Object obj, int id, World world, EntityPlayer player, NBTTagCompound tag) {
            return new GuiExtractor.Starch(player.field_71071_by, this);
        }
    }
}

